/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.io.IOException;
import java.util.Iterator;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.auth.HeaderCallback;
import oracle.dbtools.auth.HttpServletRequestCallback;
import oracle.dbtools.auth.domain.IdentityDomain;
import oracle.dbtools.auth.domain.IdentityDomainCallback;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.rt.authentication.AllHeadersCallback;
import oracle.dbtools.rt.entity.EntityHeader;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.oauth.CompoundPrincipalCallback;
import oracle.dbtools.rt.session.ServletSessionCallback;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.Requests;

public abstract class BaseHandler
implements CallbackHandler {
    protected final RequestEntity request;
    private final String username;
    private final char[] password;

    protected BaseHandler(RequestEntity request, Pair<String, char[]> credentials) {
        this.request = request;
        if (credentials == null) {
            this.username = null;
            this.password = null;
        } else {
            this.username = (String)credentials.first();
            this.password = (char[])credentials.second();
        }
    }

    @Override
    public final void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            this.handle(callback);
        }
    }

    protected void handle(Callback callback) {
        if (callback instanceof NameCallback && this.username != null) {
            NameCallback name = (NameCallback)callback;
            name.setName(this.username);
        } else if (callback instanceof PasswordCallback && this.password != null) {
            PasswordCallback cb = (PasswordCallback)callback;
            cb.setPassword(this.password);
        } else if (callback instanceof HeaderCallback) {
            HeaderCallback cb = (HeaderCallback)callback;
            EntityHeader header = this.request.headers().header(cb.getName());
            if (header != null) {
                cb.setValues(header.values());
            }
        } else if (callback instanceof AllHeadersCallback) {
            ((AllHeadersCallback)callback).setHeaders(BaseHandler.headers(this.request));
        } else if (callback instanceof CompoundPrincipalCallback) {
            CompoundPrincipalCallback cb = (CompoundPrincipalCallback)callback;
            cb.setPrincipal(this.request.principal());
        } else if (callback instanceof ServletSessionCallback) {
            ServletSessionCallback cb = (ServletSessionCallback)callback;
            Object value = Requests.sessionAttribute(this.request, cb.getAttributeName());
            cb.setAttribute(value);
        } else if (callback instanceof HttpServletRequestCallback) {
            HttpServletRequest req = Requests.servletRequest(this.request);
            HttpServletRequestCallback cb = (HttpServletRequestCallback)callback;
            cb.setRequest(req);
        } else if (callback instanceof IdentityDomainCallback) {
            IdentityDomainCallback cb = (IdentityDomainCallback)callback;
            EntityHeader domainHeader = this.request.headers().header("X-APEX-IDENTITY-DOMAIN");
            EntityHeader serviceHeader = this.request.headers().header("X-APEX-IDENTITY-SERVICE");
            if (domainHeader == null || serviceHeader == null) {
                cb.setIdentityDomain(IdentityDomain.none());
            } else {
                cb.setIdentityDomain(IdentityDomain.identityDomain((String)domainHeader.value(), (String)serviceHeader.value()));
            }
        }
    }

    private static MultiAssociativeArray<String, String> headers(RequestEntity request) {
        final EntityHeaders headers = request.headers();
        return new MultiAssociativeArrays.Base<String, String>(){

            public Iterable<Pair<String, String>> values() {
                throw new IllegalStateException();
            }

            public Iterable<String> values(Object key) {
                if (key == null) {
                    return null;
                }
                EntityHeader h = headers.header(key.toString());
                if (h == null) {
                    return null;
                }
                return h.values();
            }

            public Iterator<String> iterator() {
                return headers.iterator();
            }

            public int size() {
                throw new IllegalStateException();
            }
        };
    }
}

