/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.wsc;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.xmlsec.util.Base64;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSXMLSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.util.WSSUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class WSCDerivedKeyToken
extends WSSElement
implements WSSXMLSecurityToken {
    public static final String DEFAULT_LABEL = "WS-SecureConversationWS-SecureConversation";
    public static final int DEFAULT_LENGTH = 32;
    private static final String PROPERTIES = "Properties";
    private static final String GENERATION = "Generation";
    private static final String OFFSET = "Offset";
    private static final String LENGTH = "Length";
    private static final String LABEL = "Label";
    private static final String NONCE = "Nonce";
    private static final String NAME = "Name";
    private static final String[] localNames = new String[]{"SecurityTokenReference", "Properties", "Generation", "Offset", "Length", "Label", "Nonce"};

    protected WSCDerivedKeyToken(Document owner, String nsURI, String localName) {
        super(owner, nsURI, localName);
    }

    protected WSCDerivedKeyToken(Element element, String systemId) {
        super(element, systemId);
    }

    protected WSCDerivedKeyToken(Element element) {
        super(element);
    }

    @Override
    public Object getToken() throws WSSException {
        return this;
    }

    @Override
    public QName getTokenName() {
        return new QName("DerivedKeyToken", this.getNamespaceURI(), null);
    }

    protected abstract String[] getNsURIs();

    public WSSecurityTokenReference getSecurityTokenReference() {
        return (WSSecurityTokenReference)WSSUtils.getChildElement(this, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
    }

    public void setSecurityTokenReference(WSSecurityTokenReference str) {
        WSSUtils.setChildElement(this, str, this.getNsURIs(), localNames);
    }

    public String getLabel() {
        return WSSUtils.collectTextFromChild(this, this.getNamespaceURI(), LABEL);
    }

    public void setLabel(String label) {
        if (label == null) {
            XMLUtils.removeChildren((Element)this.getElement(), (String)this.getNamespaceURI(), (String)LABEL);
        } else {
            WSSUtils.insertChildElementWithText(this, this.getNamespaceURI(), LABEL, this.getNsURIs(), localNames, label, true);
        }
    }

    public Integer getLength() {
        String sLength = WSSUtils.collectTextFromChild(this, this.getNamespaceURI(), LENGTH);
        return sLength == null ? null : Integer.valueOf(Integer.parseInt(sLength));
    }

    public void setLength(Integer length) {
        if (length == null) {
            XMLUtils.removeChildren((Element)this.getElement(), (String)this.getNamespaceURI(), (String)LENGTH);
        } else {
            WSSUtils.insertChildElementWithText(this, this.getNamespaceURI(), LENGTH, this.getNsURIs(), localNames, length.toString(), true);
        }
    }

    public Integer getOffset() {
        String sOffset = WSSUtils.collectTextFromChild(this, this.getNamespaceURI(), OFFSET);
        return sOffset == null ? null : Integer.valueOf(Integer.parseInt(sOffset));
    }

    public void setOffset(Integer offset) {
        if (offset == null) {
            XMLUtils.removeChildren((Element)this.getElement(), (String)this.getNamespaceURI(), (String)OFFSET);
        } else {
            WSSUtils.insertChildElementWithText(this, this.getNamespaceURI(), OFFSET, this.getNsURIs(), localNames, offset.toString(), true);
        }
    }

    public Integer getGeneration() {
        String sGeneration = WSSUtils.collectTextFromChild(this, this.getNamespaceURI(), GENERATION);
        return sGeneration == null ? null : Integer.valueOf(Integer.parseInt(sGeneration));
    }

    public void setGeneration(Integer generation) {
        if (generation == null) {
            XMLUtils.removeChildren((Element)this.getElement(), (String)this.getNamespaceURI(), (String)GENERATION);
        } else {
            WSSUtils.insertChildElementWithText(this, this.getNamespaceURI(), GENERATION, this.getNsURIs(), localNames, generation.toString(), true);
        }
    }

    public byte[] getNonce() {
        String sNonce = WSSUtils.collectTextFromChild(this, this.getNamespaceURI(), NONCE);
        return sNonce == null ? null : Base64.fromBase64((String)sNonce);
    }

    public void setNonce(byte[] nonce) {
        if (nonce == null) {
            XMLUtils.removeChildren((Element)this.getElement(), (String)this.getNamespaceURI(), (String)NONCE);
        } else {
            WSSUtils.insertChildElementWithText(this, this.getNamespaceURI(), NONCE, this.getNsURIs(), localNames, Base64.toBase64((byte[])nonce, (boolean)false), true);
        }
    }

    public static SecretKey deriveKey(SecretKey secret, byte[] nonce, String label, int offset, int length) {
        try {
            secret = new SecretKeySpec(secret.getEncoded(), "HmacSHA1");
            byte[] l = label.getBytes("UTF-8");
            byte[] seed = new byte[l.length + nonce.length];
            System.arraycopy(l, 0, seed, 0, l.length);
            System.arraycopy(nonce, 0, seed, l.length, nonce.length);
            Mac hmac_sha1 = Mac.getInstance("HmacSHA1");
            int size = 20;
            int n = (offset + length + 19) / 20;
            byte[] p_sha = new byte[n * 20];
            for (int i = 0; i < n * 20; ++i) {
                p_sha[i] = 0;
            }
            hmac_sha1.init(secret);
            byte[] a = hmac_sha1.doFinal(seed);
            for (int i = 0; i < n; ++i) {
                hmac_sha1.reset();
                hmac_sha1.init(secret);
                hmac_sha1.update(a);
                hmac_sha1.update(seed);
                hmac_sha1.doFinal(p_sha, i * 20);
                hmac_sha1.reset();
                hmac_sha1.init(secret);
                a = hmac_sha1.doFinal(a);
            }
            byte[] outputKey = new byte[length];
            System.arraycopy(p_sha, offset, outputKey, 0, length);
            return new SecretKeySpec(outputKey, "AES");
        }
        catch (ShortBufferException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (InvalidKeyException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (NoSuchAlgorithmException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
        catch (UnsupportedEncodingException e) {
            IllegalStateException e1 = new IllegalStateException(e.toString());
            e1.initCause(e);
            throw e1;
        }
    }

    public SecretKey deriveKey(SecretKey secret) {
        String label;
        Integer length = this.getLength();
        if (length == null) {
            length = 32;
        }
        Integer generation = this.getGeneration();
        Integer offset = this.getOffset();
        if (generation != null) {
            offset = generation * length;
        }
        if (offset == null) {
            offset = 0;
        }
        if ((label = this.getLabel()) == null) {
            label = DEFAULT_LABEL;
        }
        byte[] nonce = this.getNonce();
        return WSCDerivedKeyToken.deriveKey(secret, nonce, label, offset, length);
    }

    public SecretKey deriveKey() throws WSSException {
        WSSecurityTokenReference str = this.getSecurityTokenReference();
        SecretKey key = (SecretKey)str.getSTReference().getKey();
        return this.deriveKey(key);
    }

    public static class WSCDerivedKeyToken13
    extends WSCDerivedKeyToken {
        private static final String[] nsURIs = new String[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"};

        @Override
        protected String[] getNsURIs() {
            return nsURIs;
        }

        public WSCDerivedKeyToken13(Document owner) {
            super(owner, "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "DerivedKeyToken");
        }

        public WSCDerivedKeyToken13(Element element, String systemId) {
            super(element, systemId);
        }

        public WSCDerivedKeyToken13(Element element) {
            super(element);
        }
    }

    public static class WSCDerivedKeyToken12
    extends WSCDerivedKeyToken {
        private static final String[] nsURIs = new String[]{"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "http://schemas.xmlsoap.org/ws/2005/02/sc", "http://schemas.xmlsoap.org/ws/2005/02/sc", "http://schemas.xmlsoap.org/ws/2005/02/sc", "http://schemas.xmlsoap.org/ws/2005/02/sc", "http://schemas.xmlsoap.org/ws/2005/02/sc", "http://schemas.xmlsoap.org/ws/2005/02/sc"};

        @Override
        protected String[] getNsURIs() {
            return nsURIs;
        }

        public WSCDerivedKeyToken12(Document owner) {
            super(owner, "http://schemas.xmlsoap.org/ws/2005/02/sc", "DerivedKeyToken");
        }

        public WSCDerivedKeyToken12(Element element, String systemId) {
            super(element, systemId);
        }

        public WSCDerivedKeyToken12(Element element) {
            super(element);
        }
    }
}

