/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Date;
import oracle.security.xmlsec.saml2.core.Assertion;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.TagManager;
import oracle.security.xmlsec.util.URIManager;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSBinarySecurityToken;
import oracle.security.xmlsec.wss.WSSEmbedded;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSReference;
import oracle.security.xmlsec.wss.WSSURI;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.WSUCreated;
import oracle.security.xmlsec.wss.WSUExpires;
import oracle.security.xmlsec.wss.WSUTimestamp;
import oracle.security.xmlsec.wss.encoding.BinaryDataEncoder;
import oracle.security.xmlsec.wss.encoding.NullBinaryEncoder;
import oracle.security.xmlsec.wss.encoding.TimeDataEncoder;
import oracle.security.xmlsec.wss.kerberos.KerberosBinarySecurityToken;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionToken;
import oracle.security.xmlsec.wss.username.UsernameToken;
import oracle.security.xmlsec.wss.util.WSSInitializer;
import oracle.security.xmlsec.wss.x509.X509BinarySecurityToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSTokenUtils {
    public static UsernameToken createUsernameToken(String wsuId, String username) {
        UsernameToken unToken = new UsernameToken(XMLUtils.createDocument());
        unToken.setUsername(username);
        if (wsuId != null) {
            unToken.setWsuId(wsuId);
        }
        return unToken;
    }

    public static UsernameToken createUsernameToken(String wsuId, String username, byte[] nonce, WSUCreated created, char[] passwd) {
        UsernameToken unToken = WSSTokenUtils.createUsernameToken(wsuId, username);
        if (nonce != null) {
            unToken.setNonce(nonce);
        }
        if (created != null) {
            unToken.setCreated(created);
        }
        if (passwd != null) {
            unToken.setPassword(passwd);
        }
        return unToken;
    }

    public static UsernameToken createUsernameToken(String wsuId, String username, byte[] nonce, String nonceEncType, WSUCreated created, char[] password, String passwdType) {
        UsernameToken unToken = WSSTokenUtils.createUsernameToken(wsuId, username);
        if (nonce != null) {
            unToken.setNonce(nonce, nonceEncType);
        }
        if (created != null) {
            unToken.setCreated(created);
        }
        if (password != null) {
            unToken.setPassword(password, passwdType);
        }
        return unToken;
    }

    public static X509BinarySecurityToken createX509BinarySecurityToken(String wsuId, X509Certificate cert) {
        X509BinarySecurityToken bst = new X509BinarySecurityToken(XMLUtils.createDocument());
        if (wsuId != null) {
            bst.setWsuId(wsuId);
        }
        bst.setToken(cert);
        return bst;
    }

    public static WSUCreated createCreated(Date created) {
        WSUCreated cd = new WSUCreated(XMLUtils.createDocument());
        cd.setValue(created);
        return cd;
    }

    public static WSUCreated createCreated(Date created, String valType) {
        WSUCreated cd = new WSUCreated(XMLUtils.createDocument(), valType);
        cd.setValue(created);
        return cd;
    }

    public static WSUExpires createExpires(Date expires) {
        WSUExpires es = new WSUExpires(XMLUtils.createDocument());
        es.setValue(expires);
        return es;
    }

    public static WSUExpires createExpires(Date expires, String valType) {
        WSUExpires es = new WSUExpires(XMLUtils.createDocument(), valType);
        es.setValue(expires);
        return es;
    }

    public static WSUTimestamp createTimestamp(String wsuId, WSUCreated created, WSUExpires expires) {
        WSUTimestamp timestamp = new WSUTimestamp(XMLUtils.createDocument());
        if (wsuId != null) {
            timestamp.setWsuId(wsuId);
        }
        if (created != null) {
            timestamp.setCreated(created);
        }
        if (expires != null) {
            timestamp.setExpires(expires);
        }
        return timestamp;
    }

    public static WSSEmbedded createEmbedded(String wsuId, WSSecurityToken token) {
        WSSEmbedded embedded = new WSSEmbedded(XMLUtils.createDocument());
        if (wsuId != null) {
            embedded.setWsuId(wsuId);
        }
        embedded.setSecurityToken(token);
        return embedded;
    }

    public static WSSecurityTokenReference createSecurityTokenReference(String wsuId, WSSecurityTokenReferenceType stRef) {
        return WSSTokenUtils.createSecurityTokenReference(wsuId, stRef, null);
    }

    public static WSSecurityTokenReference createSecurityTokenReference(String wsuId, WSSecurityTokenReferenceType stRef, String usage) {
        WSSecurityTokenReference ref = new WSSecurityTokenReference(XMLUtils.createDocument());
        if (wsuId != null) {
            ref.setWsuId(wsuId);
        }
        ref.setSTReference(stRef);
        if (usage != null) {
            ref.setUsage(usage);
        }
        return ref;
    }

    public static WSSBinarySecurityToken createBinarySecurityToken(String wsuId, String valType, String encType, byte[] value) throws WSSException {
        WSSBinarySecurityToken bst = null;
        try {
            Class c = URIManager.getURIManager().getClassForURI(valType, "useBinaryToken");
            if (c != null) {
                Constructor x = c.getConstructor(Document.class, String.class, String.class);
                bst = (WSSBinarySecurityToken)x.newInstance(XMLUtils.createDocument(), valType, encType);
                if (wsuId != null) {
                    bst.setWsuId(wsuId);
                }
                bst.setValue(value);
            }
        }
        catch (NoSuchMethodException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (SecurityException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (Exception ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        return bst;
    }

    public static WSSecurityToken createSecurityToken(Element token) throws WSSException {
        String ns;
        WSSecurityToken st = null;
        String localName = token.getLocalName();
        QName tag = new QName(localName, ns = token.getNamespaceURI(), null);
        if (WSSURI.st_USERNAME.equals((Object)tag)) {
            st = new UsernameToken(token);
        } else {
            try {
                Class c = null;
                if (WSSURI.st_BINARY.equals((Object)tag)) {
                    String valTypeStr = token.getAttribute("ValueType");
                    try {
                        c = URIManager.getURIManager().getClassForURI(valTypeStr, "useBinaryToken");
                    }
                    catch (ClassNotFoundException ex) {
                        c = null;
                    }
                } else {
                    c = TagManager.getTagManager().getClassForTag(tag.getNamespace(), tag.getLocalPart());
                }
                if (c.getName().equals(oracle.security.xmlsec.saml.Assertion.class.getName())) {
                    c = SAMLAssertionToken.class;
                } else if (c.getName().equals(Assertion.class.getName())) {
                    c = SAML2AssertionToken.class;
                }
                if (c != null) {
                    Constructor x = c.getConstructor(Element.class);
                    st = (WSSecurityToken)x.newInstance(token);
                }
            }
            catch (NoSuchMethodException ex) {
                throw new WSSException(ex, WSSException.INVALID_SECURITY);
            }
            catch (SecurityException ex) {
                throw new WSSException(ex, WSSException.INVALID_SECURITY);
            }
            catch (Exception ex) {
                throw new WSSException(ex, WSSException.INVALID_SECURITY);
            }
        }
        return st;
    }

    public static WSSReference createReference(String uri) throws WSSException {
        return new WSSReference(XMLUtils.createDocument(), uri);
    }

    public static WSSReference createReference(String uri, String valTypeURI) throws WSSException {
        WSSReference ref = null;
        try {
            Class<WSSReference> c = URIManager.getURIManager().getClassForURI(valTypeURI, "useReference");
            if (c == null) {
                c = WSSReference.class;
            }
            Constructor x = c.getConstructor(Document.class, String.class);
            ref = (WSSReference)x.newInstance(XMLUtils.createDocument(), uri);
            if (valTypeURI != null) {
                ref.setValueType(valTypeURI);
            }
        }
        catch (NoSuchMethodException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (SecurityException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (Exception ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        return ref;
    }

    public static WSSKeyIdentifier createKeyIdentifier(String wsuId, String valTypeURI, String encTypeURI, byte[] value) throws WSSException {
        WSSKeyIdentifier ki = null;
        try {
            Class c = URIManager.getURIManager().getClassForURI(valTypeURI, "useIdentifier");
            if (c == null) {
                throw new WSSException("...Unable to find Class Mapping...");
            }
            Constructor x = c.getConstructor(Document.class, String.class);
            ki = (WSSKeyIdentifier)x.newInstance(XMLUtils.createDocument(), valTypeURI);
            if (encTypeURI != null) {
                ki.setEncodingType(encTypeURI);
            }
            if (wsuId != null) {
                ki.setWsuId(wsuId);
            }
            ki.setValue(value);
        }
        catch (NoSuchMethodException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (SecurityException ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        catch (Exception ex) {
            throw new WSSException(ex, WSSException.INVALID_SECURITY);
        }
        return ki;
    }

    public static BinaryDataEncoder createBinaryDataEncoder(String encTypeURI) {
        BinaryDataEncoder bd = null;
        try {
            Class<NullBinaryEncoder> c = null;
            try {
                c = URIManager.getURIManager().getClassForURI(encTypeURI, "useBinaryEncoder");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (c == null) {
                c = NullBinaryEncoder.class;
            }
            Constructor x = c.getConstructor(new Class[0]);
            bd = (BinaryDataEncoder)x.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            throw new IllegalStateException(sw.toString());
        }
        catch (SecurityException ex) {
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            throw new IllegalStateException(sw.toString());
        }
        catch (Exception ex) {
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            throw new IllegalStateException(sw.toString());
        }
        return bd;
    }

    public static TimeDataEncoder createTimeDataEncoder(String valTypeURI) {
        TimeDataEncoder td = null;
        try {
            Class c = URIManager.getURIManager().getClassForURI(valTypeURI, "useDateEncoder");
            if (c != null) {
                Constructor x = c.getConstructor(new Class[0]);
                td = (TimeDataEncoder)x.newInstance(new Object[0]);
            }
        }
        catch (NoSuchMethodException ex) {
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            throw new IllegalStateException(sw.toString());
        }
        catch (SecurityException ex) {
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            throw new IllegalStateException(sw.toString());
        }
        catch (Exception ex) {
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            throw new IllegalStateException(sw.toString());
        }
        return td;
    }

    public static byte[] getKeyIdentifier(KerberosBinarySecurityToken kst) {
        try {
            byte[] tokenBytes = kst.getValue();
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(tokenBytes);
            return md.digest();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.fillInStackTrace();
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter((Writer)sw, true);
            ex.printStackTrace(pw);
            throw new IllegalStateException(sw.toString());
        }
    }

    static {
        WSSInitializer.initialize();
    }
}

