/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.transform;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.c14n.C14NImpl;
import oracle.security.xmlsec.c14n.CanonicalizationException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.transform.XSTransformer;
import oracle.security.xmlsec.util.NodeIterator;
import oracle.security.xmlsec.util.NodeListImpl;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.util.XPathException;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSEmbedded;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSReference;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.saml.SAMLAssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionKeyIdentifier;
import oracle.security.xmlsec.wss.saml2.SAML2AssertionToken;
import org.jaxen.dom.DocumentNavigator;
import org.jaxen.dom.NamespaceNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class STRTransform
extends XSTransformer {
    private String canonicalMethod;
    boolean exclusiveMode;
    boolean comments;
    private static DocumentNavigator docNavigator = XMLUtils.getDocumentNavigator();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public STRTransform(XSAlgorithmIdentifier trans) {
        super(trans);
        if (!"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(trans.getAlgorithm())) {
            throw new IllegalArgumentException("STR-Transform required");
        }
        NodeList params = trans.getParameters();
        if (params.getLength() != 1) throw new IllegalArgumentException("Illegal Transform parameter");
        Element transParams = (Element)params.item(0);
        if (!transParams.getLocalName().equals("TransformationParameters") || !transParams.getNamespaceURI().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd")) {
            throw new IllegalArgumentException("Illegal wsse Transform parameter");
        }
        NodeList cmList = XMLElement.getChildElementsByTagNameNS((Element)transParams, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"CanonicalizationMethod");
        if (cmList.getLength() != 1) {
            throw new IllegalArgumentException("Cannot find mandatory element ds:CanonicalizationMethod inside wsse:TransformationParameters");
        }
        Element cm = (Element)cmList.item(0);
        this.canonicalMethod = cm.getAttribute("Algorithm");
        if (this.canonicalMethod.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            this.exclusiveMode = true;
            this.comments = false;
            return;
        } else if (this.canonicalMethod.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            this.exclusiveMode = true;
            this.comments = true;
            return;
        } else if (this.canonicalMethod.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) {
            this.exclusiveMode = false;
            this.comments = false;
            return;
        } else {
            if (!this.canonicalMethod.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) throw new IllegalArgumentException("Illegal Transform parameter");
            this.exclusiveMode = false;
            this.comments = true;
        }
    }

    public String getAlgorithmURI() {
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform";
    }

    public String getCanonicalizationMethod() {
        return this.canonicalMethod;
    }

    public XMLContainer transform(XMLContainer source) throws TransformationException {
        HashMap STRToST = new HashMap();
        return this.transform(source, STRToST);
    }

    public XMLContainer transform(XMLContainer source, Map STRToST) throws TransformationException {
        try {
            return this.strTransform(source.getNodeSet(), STRToST);
        }
        catch (IOException ex) {
            throw new TransformationException((Throwable)ex);
        }
        catch (SAXException ex) {
            throw new TransformationException((Throwable)ex);
        }
        catch (XPathException ex) {
            throw new TransformationException((Throwable)ex);
        }
    }

    XMLContainer strTransform(Set nodes, Map STRToST) throws TransformationException {
        HashSet N = new HashSet(nodes);
        HashMap Y = this.derefNodeSet(N, STRToST);
        String B = new C14NWithReplace(N, Y, null, this.comments, this.exclusiveMode).canonicalize();
        XMLContainer O = null;
        try {
            O = new XMLContainer(Utils.toUTF8((String)B));
        }
        catch (IOException ex) {
            throw new TransformationException((Throwable)ex);
        }
        return O;
    }

    private HashMap derefNodeSet(Set N, Map STRToST) throws TransformationException {
        HashMap<Node, NodeListImpl> Y = new HashMap<Node, NodeListImpl>();
        List list = XMLUtils.toDocumentOrderList((Collection)N);
        NodeIterator D = new NodeIterator((Collection)list, (NodeIterator.NodeFilter)new SecurityTokenReferenceFilter());
        while (D.hasNext()) {
            WSSecurityToken token;
            WSSecurityTokenReference str;
            block14: {
                str = new WSSecurityTokenReference((Element)D.next());
                token = null;
                WSSecurityTokenReferenceType tokentype = null;
                Node node = null;
                try {
                    WSSElement tmp;
                    tokentype = str.getSTReference();
                    if (tokentype instanceof WSSEmbedded) {
                        node = ((WSSEmbedded)tokentype).getNode();
                        tmp = new WSSEmbedded((Element)node);
                        token = ((WSSEmbedded)tmp).getSecurityToken();
                        break block14;
                    }
                    if (tokentype instanceof WSSReference) {
                        node = ((WSSReference)tokentype).getNode();
                        tmp = new WSSReference((Element)node);
                        token = ((WSSReference)tmp).getSecurityToken();
                        break block14;
                    }
                    if (tokentype instanceof WSSKeyIdentifier) {
                        Element se;
                        String samlkid;
                        node = ((WSSKeyIdentifier)tokentype).getNode();
                        if (tokentype instanceof SAMLAssertionKeyIdentifier) {
                            samlkid = new String(((WSSKeyIdentifier)tokentype).getValue());
                            se = XMLUtils.getElementById((Document)node.getOwnerDocument(), (String)samlkid);
                            if (se != null) {
                                token = new SAMLAssertionToken(se);
                            }
                        } else if (tokentype instanceof SAML2AssertionKeyIdentifier) {
                            samlkid = new String(((WSSKeyIdentifier)tokentype).getValue());
                            se = XMLUtils.getElementById((Document)node.getOwnerDocument(), (String)samlkid);
                            if (se != null) {
                                token = new SAML2AssertionToken(se);
                            }
                        }
                        if (token == null) {
                            token = ((WSSKeyIdentifier)tokentype).getSecurityToken();
                        }
                        break block14;
                    }
                    throw new WSSException("Unsupported Reference Mechanism");
                }
                catch (WSSException ex) {
                    throw new TransformationException((Throwable)((Object)ex));
                }
            }
            HashSet Od = null;
            try {
                Od = new HashSet();
                Od.addAll(XMLContainer.subtreeToNodeSet((Node)token.getNode(), (boolean)true));
            }
            catch (XPathException ex) {
                throw new TransformationException((Throwable)ex);
            }
            NodeListImpl nl = new NodeListImpl(token.getNode());
            Y.put(str.getNode(), nl);
            STRToST.put(str, token);
        }
        return Y;
    }

    private Node parentOf(Node node) {
        if (node.getNodeType() == 2) {
            return ((Attr)node).getOwnerElement();
        }
        return node.getParentNode();
    }

    class C14NWithReplace
    extends C14NImpl {
        private SecurityTokenReferenceFilter filter;
        private Set N;
        private HashMap Y;
        private SortedMap xmlAttrMap;

        public C14NWithReplace(Set N, HashMap Y, SortedMap xmlAttrMap, boolean comments, boolean exclusiveMode) {
            super(comments, exclusiveMode);
            this.filter = new SecurityTokenReferenceFilter();
            this.N = N;
            this.Y = Y;
            this.xmlAttrMap = xmlAttrMap;
        }

        public String canonicalizeNode(Node n, SortedMap inScopeNamespaces, SortedMap xmlAttributes) throws CanonicalizationException {
            this.processNode(n, inScopeNamespaces, xmlAttributes);
            return this.output.toString();
        }

        public String canonicalize() throws CanonicalizationException {
            this.processNodeSet(this.N);
            return this.output.toString();
        }

        protected void processElement(Element element, SortedMap inScopeNamespaces, SortedMap xmlAttributes) throws CanonicalizationException {
            if (this.filter.matches(element) && this.Y.containsKey(element)) {
                try {
                    NodeList apexNodes = (NodeList)this.Y.get(element);
                    if (this.xmlAttrMap == null && apexNodes.getLength() > 0 && !this.N.contains(STRTransform.this.parentOf(element))) {
                        this.xmlAttrMap = C14NWithReplace.getAncestorXMLAttrs((Element)element);
                    }
                    int len = apexNodes.getLength();
                    for (int i = 0; i < len; ++i) {
                        Node node = apexNodes.item(i);
                        if (this.xmlAttrMap != null && !STRTransform.this.exclusiveMode && node.getNodeType() == 1) {
                            for (String attrName : this.xmlAttrMap.keySet()) {
                                Attr attr = (Attr)this.xmlAttrMap.get(attrName);
                                ((Element)node).setAttribute(attrName, attr.getNodeValue());
                            }
                        }
                        Set nodeSet = XMLContainer.subtreeToNodeSet((Node)node, (boolean)true);
                        C14NWithReplace c14n = new C14NWithReplace(nodeSet, this.Y, this.xmlAttrMap, STRTransform.this.comments, STRTransform.this.exclusiveMode);
                        if (node.getNodeType() == 1 && !this.hasDefaultNS(node)) {
                            c14n.canonicalizeNode(node, inScopeNamespaces, xmlAttributes);
                            int n = c14n.output.length();
                            for (int j = 0; j < n; ++j) {
                                char c = c14n.output.charAt(j);
                                if (c != ' ' && c != '>') continue;
                                c14n.output.insert(j, " xmlns=\"\"");
                                break;
                            }
                            String tmp = c14n.output.toString();
                            this.output.append(tmp);
                            continue;
                        }
                        this.output.append(c14n.canonicalizeNode(node, inScopeNamespaces, xmlAttributes));
                    }
                    this.N.removeAll(XMLContainer.subtreeToNodeSet((Node)element, (boolean)true));
                    this.xmlAttrMap = null;
                }
                catch (XPathException ex) {
                    throw new CanonicalizationException((Throwable)ex);
                }
            } else {
                super.processElement(element, inScopeNamespaces, xmlAttributes);
            }
        }

        private boolean hasDefaultNS(Node node) {
            Iterator nsIter = docNavigator.getNamespaceAxisIterator((Object)node);
            while (nsIter.hasNext()) {
                NamespaceNode ns = (NamespaceNode)nsIter.next();
                if (!"".equals(ns.getNodeName())) continue;
                return true;
            }
            return false;
        }
    }

    class SecurityTokenReferenceFilter
    extends NodeIterator.ElementFilter {
        public SecurityTokenReferenceFilter() {
            super("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
        }

        public boolean matches(Node node) {
            return super.matches(node);
        }
    }
}

