/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.swa;

import java.awt.Image;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.crypto.SecretKey;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.ParseException;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.stream.StreamSource;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.xmlsec.dsig.ObjectReference;
import oracle.security.xmlsec.dsig.ReferenceException;
import oracle.security.xmlsec.dsig.XSAlgorithmIdentifier;
import oracle.security.xmlsec.enc.EncryptOutputStream;
import oracle.security.xmlsec.enc.XECipherData;
import oracle.security.xmlsec.enc.XECipherReference;
import oracle.security.xmlsec.enc.XEEncryptedData;
import oracle.security.xmlsec.enc.XEEncryptionMethod;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.enc.XESchemaException;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.swa.MimeHeaderC14N;
import oracle.security.xmlsec.wss.util.WSSEncryptionParams;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SWAUtil {
    public static final String SWAURI = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1";
    public static final String AttachmentContentSignatureTransform = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform";
    public static final String AttachmentCompleteSignatureTransform = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete-Signature-Transform";
    public static final String AttachmentContentOnly = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Only";
    public static final String AttachmentComplete = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Complete";
    public static final String AttachmentCiphertextTransform = "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform";
    static LinkedHashMap headersToBeEncrypted = new LinkedHashMap();
    private static ThreadLocal tlsMsg;

    public static AttachmentPart getAttachment(SOAPMessage msg, String uri) {
        if (uri.startsWith("cid:")) {
            String contentId = "";
            String contentId1 = "";
            contentId = "<" + uri.substring(4) + ">";
            contentId1 = uri.substring(4);
            Iterator i = msg.getAttachments();
            while (i.hasNext()) {
                AttachmentPart ap = (AttachmentPart)i.next();
                if (!contentId.equals(ap.getContentId()) && !contentId1.equals(ap.getContentId())) continue;
                return ap;
            }
            return null;
        }
        Iterator i = msg.getAttachments();
        if (i.hasNext()) {
            AttachmentPart ap = (AttachmentPart)i.next();
            try {
                if (uri.equals(MimeHeaderC14N.canonicalizeContentLocation(ap.getContentLocation(), true))) {
                    return ap;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void canonicalizeBodyText(AttachmentPart ap) {
    }

    public static XEEncryptedData encryptAttachment(AttachmentPart ap, WSSEncryptionParams encParam, Document doc, String contentId, boolean includeHeaders) throws XEException {
        EncryptOutputStream encOs;
        if (ap.getContentId() != null || ap.getContentId().length() > 0) {
            contentId = ap.getContentId();
            try {
                contentId = MimeHeaderC14N.canonicalizeContentId(contentId);
            }
            catch (AddressException ex) {
                throw new XEException("Illegal ContentId format in attachment", (Throwable)ex);
            }
            if (contentId.startsWith("<")) {
                contentId = contentId.substring(1);
            }
            if (contentId.endsWith(">")) {
                contentId = contentId.substring(0, contentId.length() - 1);
            }
        } else if (contentId == null) {
            contentId = XMLUtils.randomName();
        }
        String origContentType = ap.getContentType();
        UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
        XEEncryptedData ed = XEEncryptedData.newInstance((Document)doc, (String)contentId, (String)(includeHeaders ? AttachmentComplete : AttachmentContentOnly));
        XEEncryptionMethod em = ed.createEncryptionMethod(encParam.getDataEncryptionAlg());
        ed.setEncryptionMethod(em);
        try {
            encOs = ed.createEncryptOutputStream(encParam.getDataEncryptionKey(), encParam.getIv(), (OutputStream)bos);
        }
        catch (IOException e) {
            throw new XEException("Can't encrypt attachment", (Throwable)e);
        }
        if (includeHeaders) {
            try {
                OutputStreamWriter pw = new OutputStreamWriter((OutputStream)encOs, "ASCII");
                Iterator i = ap.getAllMimeHeaders();
                while (i.hasNext()) {
                    MimeHeader mh = (MimeHeader)i.next();
                    if (!headersToBeEncrypted.containsKey(mh.getName().toLowerCase())) continue;
                    pw.write(mh.getName() + ":" + mh.getValue() + "\r\n");
                    i.remove();
                }
                pw.write("\r\n");
                pw.flush();
            }
            catch (IOException pw) {
                // empty catch block
            }
        }
        try {
            InputStream is = SWAUtil.getInputStream(ap);
            byte[] buf = new byte[8192];
            int n = is.read(buf);
            while (n != -1) {
                encOs.write(buf, 0, n);
                n = is.read(buf);
            }
            encOs.close();
        }
        catch (SOAPException e) {
            throw new XEException("Can't extract attachment bytes", (Throwable)e);
        }
        catch (IOException e) {
            throw new XEException("Can't extract attachment bytes", (Throwable)e);
        }
        XECipherReference cref = ed.createCipherReference("cid:" + contentId);
        XECipherData cdata = ed.createCipherData();
        cdata.setCipherReference(cref);
        ed.setCipherData(cdata);
        XSAlgorithmIdentifier trans = new XSAlgorithmIdentifier(doc, "Transform", AttachmentCiphertextTransform);
        cref.addTransform(trans);
        ed.setMimeType(origContentType);
        ap.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(bos.toByteArray())));
        ap.setContentId("<" + contentId + ">");
        return ed;
    }

    public static boolean isEncryptedAttacment(XEEncryptedData ed) {
        return ed.getDataType().equals(AttachmentComplete) || ed.getDataType().equals(AttachmentContentOnly);
    }

    public static AttachmentPart decryptAttachment(XEEncryptedData ed, SecretKey key, SOAPMessage msg) throws XEException {
        SWAUtil.setSOAPMessage(msg);
        if (ed.getCipherData() == null) {
            throw new XESchemaException("EncryptedData/CipherData is missing");
        }
        if (ed.getCipherData().getCipherReference() == null) {
            throw new XESchemaException("EncryptedData/CipherData/CipherReference is missing");
        }
        XECipherReference ref = ed.getCipherData().getCipherReference();
        if (ref.getURI() == null) {
            throw new XESchemaException("EncryptedData/CipherData/CipherReference@URI is missing");
        }
        if (ref.getTransforms() == null || ref.getTransforms().size() == 0) {
            throw new XESchemaException("EncryptedData/CipherData/Transforms are missing");
        }
        if (ref.getTransforms().size() > 1) {
            throw new XESchemaException("EncryptedData/CipherData/Transforms should have only one transform");
        }
        XSAlgorithmIdentifier trans = (XSAlgorithmIdentifier)ref.getTransforms().get(0);
        if (!trans.getAlgorithm().equals(AttachmentCiphertextTransform)) {
            throw new XESchemaException("EncryptedData/CipherData/Transforms does not have Attachment-Ciphertext-Transform");
        }
        AttachmentPart ap = SWAUtil.getAttachment(msg, ref.getURI());
        if (ap == null) {
            throw new XEException("Can't find cipher reference " + ref.getURI());
        }
        byte[] decryptedData = ed.decrypt(key);
        if (ed.getDataType().equals(AttachmentContentOnly)) {
            InternetHeaders headers = new InternetHeaders();
            String mimeType = ed.getMimeType();
            if (mimeType == null || mimeType.isEmpty()) {
                mimeType = ap.getContentType();
            }
            headers.addHeader("Content-Type", mimeType);
            MimeBodyPart mb = null;
            try {
                mb = new MimeBodyPart(headers, decryptedData);
                ap.setDataHandler(mb.getDataHandler());
            }
            catch (MessagingException ex) {
                throw new XEException("Can't create a Mimebody part from the decrypted content", (Throwable)ex);
            }
        }
        if (ed.getDataType().equals(AttachmentComplete)) {
            UnsyncByteArrayInputStream bis = new UnsyncByteArrayInputStream(decryptedData);
            try {
                MimeBodyPart mb = new MimeBodyPart((InputStream)bis);
                Enumeration en = mb.getAllHeaders();
                while (en.hasMoreElements()) {
                    Header hdr = (Header)en.nextElement();
                    ap.setMimeHeader(hdr.getName(), hdr.getValue());
                }
                ap.setDataHandler(mb.getDataHandler());
            }
            catch (MessagingException ex) {
                throw new XEException("Can't create a Mimebody part from the decrypted content", (Throwable)ex);
            }
        }
        return ap;
    }

    public static void setSOAPMessage(SOAPMessage msg) {
        tlsMsg.set(msg);
    }

    public static SOAPMessage getSOAPMessage() {
        return (SOAPMessage)tlsMsg.get();
    }

    public static InputStream getInputStream(AttachmentPart ap) throws IOException, SOAPException {
        Object content = ap.getDataHandler().getContent();
        Object is = content instanceof StreamSource ? ((StreamSource)content).getInputStream() : (content instanceof byte[] ? new UnsyncByteArrayInputStream((byte[])content) : (content instanceof String ? new UnsyncByteArrayInputStream(((String)content).getBytes("UTF8")) : (content instanceof Image ? ap.getDataHandler().getInputStream() : (content instanceof InputStream ? (InputStream)content : null))));
        if (((InputStream)is).markSupported()) {
            ((InputStream)is).reset();
        }
        return is;
    }

    public static void writeTo(SOAPMessage msg, OutputStream out) throws IOException, SOAPException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)bos);
        PrintStream osw = null;
        try {
            osw = new PrintStream(out, false, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        Iterator it = msg.getMimeHeaders().getAllHeaders();
        while (it.hasNext()) {
            MimeHeader mh = (MimeHeader)it.next();
            osw.print(mh.getName());
            osw.print(':');
            osw.print(mh.getValue());
            osw.print("\r\n");
        }
        osw.print("\r\n");
        out.write(bos.toByteArray());
    }

    public static SOAPMessage readFrom(MessageFactory mf, InputStream in) throws IOException, SOAPException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
        boolean newlineFound = false;
        int c = in.read();
        while (c != -1) {
            if (c != 13) {
                if (c == 10) {
                    if (newlineFound) break;
                    newlineFound = true;
                } else {
                    newlineFound = false;
                }
                bos.write(c);
            }
            c = in.read();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new UnsyncByteArrayInputStream(bos.toByteArray())));
        String line = br.readLine();
        String lastHeader = null;
        String lastValue = null;
        while (line != null) {
            if (line.startsWith(" ") || line.startsWith("\t")) {
                lastValue = lastValue + line;
            } else {
                if (lastHeader != null) {
                    mimeHeaders.addHeader(lastHeader, lastValue);
                    lastHeader = null;
                    lastValue = null;
                }
                if (line.indexOf(58) >= 0) {
                    lastHeader = line.substring(0, line.indexOf(58));
                    lastValue = line.substring(line.indexOf(58) + 1);
                }
            }
            line = br.readLine();
        }
        if (lastHeader != null) {
            mimeHeaders.addHeader(lastHeader, lastValue);
        }
        return mf.createMessage(mimeHeaders, in);
    }

    static {
        headersToBeEncrypted.put("Content-Description".toLowerCase(), "");
        headersToBeEncrypted.put("Content-Disposition".toLowerCase(), "");
        headersToBeEncrypted.put("Content-ID".toLowerCase(), "");
        headersToBeEncrypted.put("Content-Location".toLowerCase(), "");
        headersToBeEncrypted.put("Content-Type".toLowerCase(), "");
        tlsMsg = new ThreadLocal();
    }

    public static class ByteArrayDataSource
    implements DataSource {
        byte[] content;

        public ByteArrayDataSource(byte[] content) {
            this.content = content;
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.content);
        }

        public String getName() {
            return null;
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Can't write to this DataSource");
        }
    }

    public static class SWACIDResolver
    implements ObjectReference.CIDResolver {
        public XMLContainer resolveReference(String refUri, Element refElement) throws ReferenceException {
            SOAPMessage msg = SWAUtil.getSOAPMessage();
            AttachmentPart ap = SWAUtil.getAttachment(msg, refUri);
            if (ap == null) {
                throw new ReferenceException("cid reference " + refUri + " could not be resolved");
            }
            try {
                XMLContainer container = new XMLContainer(SWAUtil.getInputStream(ap));
                container.setUserData((Object)ap);
                return container;
            }
            catch (SOAPException ex) {
                throw new ReferenceException("Couldn't extract data from cid reference", (Throwable)ex);
            }
            catch (IOException ex) {
                throw new ReferenceException("Couldn't extract data from cid reference", (Throwable)ex);
            }
        }
    }
}

