/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKey;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.wss.WSSEncryptedKeyIdentifierResolver;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSKeyIdentifier;
import oracle.security.xmlsec.wss.WSSecurityToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSEncryptedKeyIdentifier
extends WSSKeyIdentifier {
    public static final String vt_EncryptedKeySHA1 = "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKeySHA1";
    private static ArrayList resolverList = new ArrayList();

    public static void addResolver(WSSEncryptedKeyIdentifierResolver resolver) {
        resolverList.add(resolver);
    }

    public static List getResolvers() {
        return resolverList;
    }

    public WSSEncryptedKeyIdentifier(Document owner) {
        super(owner);
    }

    public WSSEncryptedKeyIdentifier(Document owner, String valType) {
        super(owner, valType);
    }

    public WSSEncryptedKeyIdentifier(Document owner, String valType, String encType) {
        super(owner, valType, encType);
    }

    public WSSEncryptedKeyIdentifier(Element element) {
        super(element);
    }

    public WSSEncryptedKeyIdentifier(Element element, String systemId) {
        super(element, systemId);
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        return null;
    }

    @Override
    public Object getKey() throws WSSException {
        int n = resolverList.size();
        for (int i = 0; i < n; ++i) {
            WSSEncryptedKeyIdentifierResolver r = (WSSEncryptedKeyIdentifierResolver)resolverList.get(i);
            SecretKey key = r.getKey(this);
            if (key == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public byte[] getThumbprint() {
        return this.getValueType().equals(vt_EncryptedKeySHA1) ? this.getValue() : null;
    }

    public boolean matches(XEEncryptedKey encKey) {
        try {
            MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
            byte[] sha1 = sha1Digester.digest(encKey.getCipherData().getCipherValue());
            return Arrays.equals(sha1, this.getThumbprint());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return false;
        }
    }
}

