/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.file;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLKey;
import oracle.ideimpl.file.InvalidationRecord;

public final class InvalidationQueue
extends AbstractCollection<InvalidationRecord> {
    private Map<URLKey, InvalidationRecord> records;

    public InvalidationQueue() {
        this.records = new HashMap<URLKey, InvalidationRecord>(5);
    }

    private InvalidationQueue(Map<URLKey, InvalidationRecord> records) {
        this.records = records;
    }

    public boolean invalidateFile(URL file, boolean isBufferChange) {
        URL dir = URLFileSystem.getParent((URL)file);
        URLKey dirKey = URLKey.getInstance((URL)dir);
        InvalidationRecord record = this.records.get(dirKey);
        URLKey fileKey = URLKey.getInstance((URL)file);
        if (record == null || !record.isFileInvalid(fileKey, isBufferChange)) {
            InvalidationRecord newRecord = InvalidationRecord.get(dir, file, isBufferChange);
            record = record == null ? newRecord : newRecord.mergeTo(record);
            this.records.put(dirKey, record);
            return true;
        }
        return false;
    }

    public boolean invalidateDirectory(URL dir, boolean includeSubdirectories, URL renameHintOldURL, URL renameHintNewURL) {
        URLKey dirKey = URLKey.getInstance((URL)dir);
        InvalidationRecord record = this.records.get(dirKey);
        if (record == null || !record.isDirectoryInvalid(includeSubdirectories, renameHintOldURL, renameHintNewURL)) {
            InvalidationRecord newRecord = InvalidationRecord.get(dir, includeSubdirectories, renameHintOldURL, renameHintNewURL);
            record = record == null ? newRecord : newRecord.mergeTo(record);
            this.records.put(dirKey, record);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(InvalidationRecord record) {
        URLKey key = URLKey.getInstance((URL)record.getDirectory());
        InvalidationRecord existing = this.records.get(key);
        if (existing != null) {
            record = record.mergeTo(existing);
        }
        this.records.put(key, record);
        return true;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof InvalidationRecord) {
            InvalidationRecord record = this.records.get(URLKey.getInstance((URL)((InvalidationRecord)o).getDirectory()));
            return o.equals(record);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        URLKey key;
        InvalidationRecord record;
        if (o instanceof InvalidationRecord && o.equals(record = this.records.get(key = URLKey.getInstance((URL)((InvalidationRecord)o).getDirectory())))) {
            this.records.remove(URLKey.getInstance((URL)record.getDirectory()));
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public void clear() {
        this.records.clear();
    }

    public InvalidationQueue drain() {
        InvalidationQueue copy = new InvalidationQueue(this.records);
        this.records = new HashMap<URLKey, InvalidationRecord>(5);
        return copy;
    }

    public void mergeFrom(InvalidationQueue queue) {
        for (Map.Entry<URLKey, InvalidationRecord> entry : queue.records.entrySet()) {
            URLKey key = entry.getKey();
            InvalidationRecord record = entry.getValue();
            InvalidationRecord existing = this.records.get(key);
            if (existing != null) {
                record = record.mergeTo(existing);
            }
            this.records.put(key, record);
        }
    }

    public void coalesce() {
        if (this.records.size() > 1) {
            Iterator<Map.Entry<URLKey, InvalidationRecord>> iterator = this.records.entrySet().iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry<URLKey, InvalidationRecord> child = iterator.next();
                for (Map.Entry<URLKey, InvalidationRecord> parent : this.records.entrySet()) {
                    if (child == parent || !parent.getValue().isRecursive() || !URLFileSystem.isBaseURLFor((URL)parent.getKey().toURL(), (URL)child.getKey().toURL())) continue;
                    parent.setValue(child.getValue().mergeTo(parent.getValue()));
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    @Override
    public Iterator<InvalidationRecord> iterator() {
        return new Iterator<InvalidationRecord>(){
            private final Iterator<Map.Entry<URLKey, InvalidationRecord>> iterator;
            {
                this.iterator = InvalidationQueue.this.records.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public InvalidationRecord next() {
                return this.iterator.next().getValue();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }
}

