/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import oracle.ide.file.Path;
import oracle.javatools.util.NullArgumentException;

public final class LibraryPaths {
    private final String name;
    private final Path sourcePath;
    private final Path classPath;

    public static LibraryPaths getInstance(String name, Path sourcePath, Path classPath) {
        if (name == null) {
            name = "";
        }
        if (sourcePath == null) {
            throw new NullArgumentException("null source path");
        }
        if (classPath == null) {
            throw new NullArgumentException("null class path");
        }
        return new LibraryPaths(name, sourcePath, classPath);
    }

    private LibraryPaths(String name, Path sourcePath, Path classPath) {
        this.name = name;
        this.sourcePath = sourcePath;
        this.classPath = classPath;
    }

    public String getLibraryName() {
        return this.name;
    }

    public Path getSourcePath() {
        return this.sourcePath;
    }

    public Path getClassPath() {
        return this.classPath;
    }

    public int hashCode() {
        int hash = this.name.hashCode();
        hash += 31 * this.sourcePath.hashCode();
        return hash += 31 * this.classPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LibraryPaths)) {
            return false;
        }
        LibraryPaths other = (LibraryPaths)obj;
        return this.name.equals(other.name) && this.sourcePath.equals(other.sourcePath) && this.classPath.equals(other.classPath);
    }
}

