/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.file;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.ide.file.DataBlock;
import oracle.ide.file.InvalidFileTableException;
import oracle.ide.persistence.NameSpace;

final class DataStore {
    private final NameSpace namespace;
    private final ArrayList<DataBlock> blocks;
    private int size;

    static DataStore getInstance(NameSpace namespace, int size) {
        return new DataStore(namespace, size);
    }

    private DataStore(NameSpace namespace, int size) {
        this.namespace = namespace;
        this.size = size;
        int length = size / 20;
        if (size % 20 != 0) {
            ++length;
        }
        this.blocks = new ArrayList<DataBlock>(Arrays.asList(new DataBlock[length]));
    }

    void add(int version, long lastModified, long length, boolean isNodeTimestamp) throws InvalidFileTableException {
        int blockNum = this.size / 20;
        if (blockNum >= this.blocks.size()) {
            this.blocks.add(DataBlock.getInstance(this.size));
        }
        this.getBlock(this.size).add(version, lastModified, length, isNodeTimestamp);
        ++this.size;
    }

    int getSize() {
        return this.size;
    }

    long getLastModified(int id) throws InvalidFileTableException {
        return this.getBlock(id).getLastModified(id);
    }

    long getLength(int id) throws InvalidFileTableException {
        return this.getBlock(id).getLength(id);
    }

    int getVersion(int id) throws InvalidFileTableException {
        return this.getBlock(id).getVersion(id);
    }

    boolean isNodeTimestamp(int id) throws InvalidFileTableException {
        return this.getBlock(id).isNodeTimestamp(id);
    }

    void setLastModified(int id, int version, long lastModified, long length, boolean isNodeTimestamp) throws InvalidFileTableException {
        this.getBlock(id).setLastModified(id, version, lastModified, length, isNodeTimestamp);
    }

    private DataBlock getBlock(int id) throws InvalidFileTableException {
        int blockNum = id / 20;
        if (blockNum >= this.blocks.size()) {
            throw new InvalidFileTableException("no data block " + blockNum + " for ID " + id);
        }
        DataBlock block = this.blocks.get(blockNum);
        if (block == null) {
            byte[] data = this.namespace.getRecord(DataStore.getBlockKey(blockNum));
            if (data == null) {
                throw new InvalidFileTableException("no data block " + blockNum + " for ID " + id);
            }
            block = DataBlock.getInstance(data, blockNum * 20);
            this.blocks.set(blockNum, block);
        }
        return block;
    }

    void save() {
        for (int i = 0; i < this.blocks.size(); ++i) {
            DataBlock block = this.blocks.get(i);
            if (block == null || !block.isDirty()) continue;
            this.namespace.putRecord(DataStore.getBlockKey(i), block.toByteArray());
        }
    }

    private static final String getBlockKey(int blockNum) {
        return Integer.toString(blockNum, 36);
    }
}

