/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory.db;

import javax.swing.table.AbstractTableModel;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDB;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryItem;

public class HistoryDBTableModel
extends AbstractTableModel {
    private static String[] colNames = new String[]{Messages.getString("SqlEditorHistory.4"), Messages.getString("SqlEditorHistory.3"), Messages.getString("SqlEditorHistory.2"), Messages.getString("SqlEditorHistory.0"), Messages.getString("SqlEditorHistory.1"), Messages.getString("SqlEditorHistory.5")};
    private static HistoryDBTableModel _INSTANCE;
    private String filter = "";

    public static synchronized HistoryDBTableModel getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new HistoryDBTableModel();
        }
        return _INSTANCE;
    }

    private HistoryDBTableModel() {
    }

    @Override
    public String getColumnName(int n) {
        return colNames[n];
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public int getRowCount() {
        return HistoryDB.getInstance().historySize();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        HistoryItem historyItem = HistoryDB.getInstance().getRowAt(n);
        Object object = null;
        if (historyItem != null) {
            switch (n2) {
                case 0: {
                    object = historyItem.getSql();
                    break;
                }
                case 1: {
                    object = historyItem.getConn();
                    break;
                }
                case 2: {
                    object = historyItem.getTime();
                    break;
                }
                case 3: {
                    object = historyItem.getType();
                    break;
                }
                case 4: {
                    object = historyItem.getExeCount();
                    break;
                }
                case 5: {
                    object = Float.valueOf(historyItem.getExecTime());
                }
            }
        }
        return object;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public synchronized void setFilter(String string) {
        if (!string.equals("")) {
            this.filter = string;
            this.fireTableDataChanged();
        }
    }

    public String getFilter() {
        return this.filter;
    }
}

