/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory.db;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import oracle.dbtools.parser.plsql.SqlHistory;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryItem;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HistoryDB {
    private static List<HistoryItem> _data = new ArrayList<HistoryItem>();
    private static HistoryDB INSTANCE = null;
    private static Logger LOGGER = Logger.getLogger(HistoryDB.class.getName());
    private static Random random = new Random();

    public static HistoryDB getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HistoryDB();
        }
        return INSTANCE;
    }

    private HistoryDB() {
        this.readHistory();
    }

    public void readHistory() {
        File file = new File(SqlEditorHistory.NEW_HISTORY_DIR_PATH);
        if (file.exists() && file.isDirectory()) {
            String[] stringArray = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    if (string.endsWith(".xml")) {
                        try {
                            Long.parseLong(string.substring(0, string.indexOf("history.")));
                        }
                        catch (NumberFormatException numberFormatException) {
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
            });
            Node node = null;
            DOMParser dOMParser = new DOMParser();
            dOMParser.setPreserveWhitespace(false);
            int n = DBConfig.getInstance().getInt("MAXHISTORYROWS");
            int n2 = 0;
            int n3 = 0;
            for (String string : stringArray) {
                Object object;
                try {
                    object = new BufferedReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(SqlEditorHistory.NEW_HISTORY_DIR_PATH + File.separator + string), "UTF-8")));
                    dOMParser.parse((Reader)object);
                    node = dOMParser.getDocument();
                }
                catch (SAXException sAXException) {
                    LOGGER.log(Level.WARNING, sAXException.getStackTrace()[0].toString(), sAXException);
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                if (node != null && n3 < n) {
                    object = node.getFirstChild();
                    Node node2 = object.getFirstChild();
                    HistoryItem historyItem = new HistoryItem(node2, string);
                    _data.add(historyItem);
                    String string2 = historyItem.getSql();
                    if (string2 != null && n2++ < 1000 && string2.length() < 10000) {
                        SqlHistory.generateTemplate((String)string2, (Long)historyItem.getTime());
                    }
                }
                ++n3;
            }
        } else {
            file.mkdir();
        }
    }

    public boolean addItemFor(String string, String string2, String string3, long l, float f) {
        HistoryItem historyItem = new HistoryItem();
        historyItem.setConn(string);
        historyItem.setSql(string2);
        historyItem.setType(string3);
        HistoryItem historyItem2 = this.getItemFor(string, string2, string3);
        if (historyItem2 == null) {
            historyItem.setTime(l);
            historyItem.setExeCount(1);
            historyItem.setFileName(HistoryDB.getNewXmlFileName());
            historyItem.setExecTime(f);
            HistoryDB.persistItem(historyItem);
            int n = DBConfig.getInstance().getInt("MAXHISTORYROWS");
            if (_data.size() >= n) {
                _data.remove(_data.size());
            }
            _data.add(0, historyItem);
        } else {
            historyItem2.setTime(l);
            historyItem2.setExeCount(historyItem2.getExeCount() + 1);
            historyItem2.setExecTime(f);
            HistoryDB.persistItem(historyItem2);
        }
        return true;
    }

    private static String getNewXmlFileName() {
        int n = DBConfig.getInstance().getInt("MAXHISTORYROWS");
        if (_data.size() >= n) {
            HistoryItem historyItem = _data.remove(_data.size() - 1);
            historyItem.delete();
        }
        return random.nextLong() + "history.xml";
    }

    public boolean deleteItem(HistoryItem historyItem) {
        _data.remove(historyItem);
        return historyItem.delete();
    }

    public void deleteItems(int[] nArray) {
        ArrayList<HistoryItem> arrayList = new ArrayList<HistoryItem>();
        for (int n : nArray) {
            arrayList.add(_data.get(n));
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            HistoryItem historyItem = (HistoryItem)object.next();
            this.deleteItem(historyItem);
        }
    }

    public boolean deleteItem(int n) {
        return this.deleteItem(_data.get(n));
    }

    public HistoryItem getRowAt(int n) {
        return _data.get(n);
    }

    public int historySize() {
        return _data.size();
    }

    public HistoryItem getItemFor(String string, String string2, String string3) {
        HistoryItem historyItem = null;
        HistoryItem historyItem2 = new HistoryItem();
        historyItem2.setConn(string);
        historyItem2.setSql(string2);
        historyItem2.setType(string3);
        int n = _data.indexOf(historyItem2);
        if (n > -1) {
            historyItem = _data.get(n);
        }
        return historyItem;
    }

    private static void persistItem(HistoryItem historyItem) {
        try {
            historyItem.save();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.severe(fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            LOGGER.severe(iOException.getLocalizedMessage());
        }
    }

    public static boolean migrateOldHistory(RaptorTask<Void> raptorTask) {
        File file = new File(SqlEditorHistory.OLD_HISTORY_FILE_PATH);
        if (!file.exists()) {
            return false;
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            Document document = null;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                document = documentBuilder.parse(file);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LOGGER.log(Level.FINE, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
                document = documentBuilder.parse(new InputSource(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8")));
            }
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//RESULTS/ROW", document, XPathConstants.NODESET);
            final int n = nodeList.getLength();
            if (n >= DBConfig.getInstance().getInt("MAXHISTORYROWS")) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        String string = MessageFormat.format(Messages.getString("HistoryDB.MigrateWarning"), n, DBConfig.getInstance().getInt("MAXHISTORYROWS"));
                        boolean bl = MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)string, (String)Messages.getString("HistoryDB.MigrateWarningHeader"), null);
                        if (bl) {
                            Ide.getSettings().showDialog((Frame)Ide.getMainWindow(), new String[]{"Database", "Worksheet"});
                        }
                    }
                });
            }
            Thread.sleep(1000L);
            int n2 = Math.min(n, DBConfig.getInstance().getInt("MAXHISTORYROWS"));
            for (int i = 0; i < n2; ++i) {
                HistoryItem historyItem = new HistoryItem();
                historyItem.loadOldFormat(nodeList.item(i), HistoryDB.getNewXmlFileName());
                _data.add(historyItem);
                HistoryDB.persistItem(historyItem);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.FINE, exception.getStackTrace()[0].toString(), exception);
            return false;
        }
        return true;
    }
}

