/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlcodeadvisor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.ui.RDockableWindow;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.sqlcodeadvisor.Advice;
import oracle.dbtools.worksheet.sqlcodeadvisor.AdviceInfo;
import oracle.dbtools.worksheet.sqlcodeadvisor.CodeAdvisor;
import oracle.dbtools.worksheet.sqlcodeadvisor.CodeAdvisorCache;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.Layout;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;

public class CodeAdvisorPane
extends RDockableWindow
implements ActiveViewListener,
Observer,
MouseListener {
    static final String VIEW_TYPE = "CodeAdvisor";
    static final ViewId VIEW_ID = new ViewId("CodeAdvisor", "Pane1");
    private CodeAdvisorCache m_currentAdvice;
    private URL m_lastCodeURL;
    private DefaultMutableTreeNode m_root;
    private DefaultTreeModel m_model;
    private JTree m_tree;
    private boolean m_adviceAvailable;
    private static CodeAdvisorPane s_instance;
    private Container m_gui;

    static CodeAdvisorPane getInstance() {
        if (s_instance == null) {
            s_instance = new CodeAdvisorPane();
        }
        return s_instance;
    }

    private CodeAdvisorPane() {
        super(VIEW_ID.getId());
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
    }

    public String getTitleName() {
        return this.getTabName();
    }

    public Icon getTabIcon() {
        return super.getTabIcon();
    }

    public Component getGUI() {
        if (this.m_gui == null) {
            JScrollPane jScrollPane = new JScrollPane();
            this.m_root = new DefaultMutableTreeNode("Worksheet");
            this.m_model = new DefaultTreeModel(this.m_root);
            this.m_tree = new JTree(this.m_model);
            this.m_gui = new JPanel(new BorderLayout());
            this.m_gui.add("Center", jScrollPane);
            jScrollPane.getViewport().add(this.m_tree);
            this.m_tree.addMouseListener(this);
        }
        return this.m_gui;
    }

    public String getTabName() {
        return "Code Advisor";
    }

    public int getDefaultVisibility(Layout layout) {
        return 32;
    }

    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        Context context;
        Node node;
        View view = activeViewEvent.getNewView();
        if (view instanceof Worksheet && (node = (context = view.getContext()).getNode()) != null) {
            this.activateWindow(node.getURL());
        }
    }

    void activateWindow(URL uRL) {
        CodeAdvisor.displayWarning(0, 0, 0, "activateWindow for url=" + uRL + "\n");
        DockStation dockStation = DockStation.getDockStation();
        dockStation.setDockableVisible((Dockable)this, CodeAdvisor.isCodeAdvisorEnabled());
        if (this.m_root == null) {
            return;
        }
        this.m_root.setUserObject(uRL);
        this.m_root.removeAllChildren();
        this.m_model.nodeStructureChanged(this.m_root);
        this.m_adviceAvailable = false;
        if (uRL == null) {
            this.m_lastCodeURL = uRL;
        } else if (uRL != null && (this.m_lastCodeURL == null || uRL != this.m_lastCodeURL)) {
            this.m_lastCodeURL = uRL;
            this.m_currentAdvice = CodeAdvisorCache.s_sqlAtURL.get(uRL);
            CodeAdvisor.displayWarning(0, 0, 0, "currentCodeAdviceCache=" + this.m_currentAdvice + "\n");
            if (this.m_currentAdvice != null && !this.m_currentAdvice.isFlushable()) {
                this.m_currentAdvice.attach(this);
                for (AdviceInfo adviceInfo : this.m_currentAdvice.getAdviceInfos()) {
                    CodeAdvisor.displayWarning(0, 0, 0, "adding AdviceNode=" + adviceInfo.getSql() + "\n");
                    this.addAdviceNodes(adviceInfo);
                    this.m_adviceAvailable = true;
                }
            }
            this.expandRoot();
        }
    }

    private void addAdviceNodes(AdviceInfo adviceInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(adviceInfo);
        this.m_model.insertNodeInto(defaultMutableTreeNode, this.m_root, this.m_root.getChildCount());
        for (Advice advice : adviceInfo.getAdvice()) {
            this.m_model.insertNodeInto(new DefaultMutableTreeNode(advice.getAdvice()), defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        CodeAdvisor.displayWarning(0, 0, 0, "notifyOnWorksheetUpdate for CodeAdviceCache=" + (CodeAdvisorCache)((Object)object) + "\n");
        this.m_root.removeAllChildren();
        this.m_model.nodeStructureChanged(this.m_root);
        if (this.m_currentAdvice != null && !this.m_currentAdvice.isFlushable()) {
            for (AdviceInfo adviceInfo : this.m_currentAdvice.getAdviceInfos()) {
                CodeAdvisor.displayWarning(0, 0, 0, "adding AdviceNode=" + adviceInfo + "\n");
                this.addAdviceNodes(adviceInfo);
            }
        }
        this.expandRoot();
    }

    public boolean isAdviceAvailable() {
        return this.m_adviceAvailable;
    }

    public void setAdviceAvailable(boolean bl) {
        this.m_adviceAvailable = bl;
    }

    private void expandRoot() {
        if (this.m_model != null && this.m_model.getRoot() != null) {
            this.m_tree.expandPath(new TreePath(this.m_model.getRoot()));
        }
    }

    private int getLine(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (object instanceof DefaultMutableTreeNode) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof URL) {
                return 0;
            }
            if (object2 instanceof AdviceInfo) {
                return ((AdviceInfo)object2).getLine();
            }
            if (object2 instanceof String) {
                TreePath treePath2 = treePath.getParentPath();
                return this.getLine(treePath2);
            }
            return -1;
        }
        return -2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() || mouseEvent.getClickCount() == 2) {
            int n = 0;
            TreePath treePath = this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null) {
                n = this.getLine(treePath);
            }
            CodeAdvisor.displayWarning(0, 0, 0, "Mouse clicked on JTree node maps to worksheet line " + n + "\n");
            if (n < 0) return;
        }
        CodeAdvisor.displayWarning(0, 0, 0, "Mouse clicked on JTree node " + this.m_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) + "\n");
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

