/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.sqltuningadvisor;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisor;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningCommon;
import oracle.jdbc.OracleCallableStatement;

public class SqlTuningTask {
    private SqlTuningCommon m_STCommon = null;
    private SqlTuningAdvisor m_STAdvisor = null;

    public SqlTuningTask(SqlTuningAdvisor sqlTuningAdvisor) {
        this.setSqlTuningAdvisor(sqlTuningAdvisor);
        this.setSqlTuningCommon(sqlTuningAdvisor.getSqlTuningCommon());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkOwnerPrivileges() {
        boolean bl;
        block8: {
            String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("privilege_sql"));
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = null;
            bl = false;
            hashMap.clear();
            hashMap.put("OWNER", this.m_STCommon.getOwnerName());
            ResultSet resultSet = null;
            if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                    dBUtil.setRaiseError(false);
                    resultSet = dBUtil.executeQuery(string, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            string2 = resultSet.getString(1);
                            if (!string2.equalsIgnoreCase("ADVISOR")) continue;
                            bl = true;
                            break;
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.m_STCommon.getConnection());
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllTuningTaskNames() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("taskName_sql"));
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                statement = this.m_STCommon.getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    arrayList.add(string2);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllSqlSetNames() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("sqlSetName_sql"));
        Statement statement = null;
        ResultSet resultSet = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                statement = this.m_STCommon.getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    arrayList.add(string2);
                }
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSqlTuningTaskOld() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("createSST_sql"));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQL_TEXT", this.m_STCommon.getSelectedSQLScript());
        hashMap.put("OWNER", this.m_STCommon.getOwnerName());
        hashMap.put("BIND_VARIABLES", this.m_STCommon.getBindVariablesString());
        hashMap.put("SQLTUNINGTASK_NAME", this.m_STCommon.getSQLTuningTaskName());
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(string, hashMap);
                if (resultSet != null) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_STCommon.getConnection());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSqlTuningTask() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("createSST_sql"));
        OracleCallableStatement oracleCallableStatement = null;
        String string2 = "'" + this.m_STCommon.getSelectedSQLScript().trim().replaceAll("'", "''") + "'";
        String string3 = "'" + this.m_STCommon.getOwnerName().trim() + "'";
        String string4 = this.m_STCommon.getBindVariablesString().trim();
        String string5 = "'" + this.m_STCommon.getSQLTuningTaskName().trim() + "'";
        string = string.replace(":SQL_TEXT", string2);
        string = string.replace(":OWNER", string3);
        string = string.replace(":BIND_VARIABLES", string4);
        string = string.replace(":SQLTUNINGTASK_NAME", string5);
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                oracleCallableStatement = (OracleCallableStatement)this.m_STCommon.getConnection().prepareCall(string);
                oracleCallableStatement.execute();
                oracleCallableStatement.close();
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
            }
            finally {
                if (oracleCallableStatement != null) {
                    try {
                        oracleCallableStatement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSQLTuningTask() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("executeSTT_sql"));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLTUNINGTASK_NAME", this.m_STCommon.getSQLTuningTaskName());
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(string, hashMap);
                if (resultSet != null) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_STCommon.getConnection());
        }
        return true;
    }

    public boolean checkForTaskCompletion() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("statusCheck_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLTUNINGTASK_NAME", this.m_STCommon.getSQLTuningTaskName());
        return this.executeSQLStatement(string, hashMap);
    }

    public boolean dropSQLTuningTask() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("dropSTT_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLTUNINGTASK_NAME", this.m_STCommon.getSQLTuningTaskName());
        return this.executeSQLStatement(string, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeSQLStatement(String string, Map<String, String> map) {
        block8: {
            StringBuilder stringBuilder = new StringBuilder();
            ResultSet resultSet = null;
            if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                    dBUtil.setRaiseError(false);
                    resultSet = dBUtil.executeQuery(string, map);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            stringBuilder.append(resultSet.getString(1));
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(this.m_STCommon.getConnection());
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSQLTuningSet() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("createSqlSet_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLSET_NAME", this.m_STCommon.getSQLTuningSetName());
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(string, hashMap);
                if (resultSet != null) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_STCommon.getConnection());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSQLTuningSet() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("loadSqlSet_sql"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        string = string.replaceFirst(":SQLSET_ROWS", this.m_STCommon.getSQLTuningSetRows());
        hashMap.put("SQLSET_NAME", this.m_STCommon.getSQLTuningSetName());
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(string, hashMap);
                if (resultSet != null) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_STCommon.getConnection());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSqlSetTuningTask() {
        String string = this.m_STCommon.getQuery(this.m_STCommon.getConnection(), this.m_STCommon.getQueryKey("createSqlSetTask_sql"));
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.clear();
        hashMap.put("SQLSET_NAME", this.m_STCommon.getSQLTuningSetName());
        hashMap.put("OWNER", this.m_STCommon.getOwnerName());
        hashMap.put("SQLTUNINGTASK_NAME", this.m_STCommon.getSQLTuningTaskName());
        ResultSet resultSet = null;
        if (Connections.getInstance().lock(this.m_STCommon.getConnection())) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)this.m_STCommon.getConnection());
                dBUtil.setRaiseError(false);
                resultSet = dBUtil.executeQuery(string, hashMap);
                if (resultSet != null) {
                    // empty if block
                }
            }
            catch (Throwable throwable) {
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(this.m_STCommon.getConnection());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeMultipleSqlStatments() {
        String[] stringArray = this.m_STCommon.getSelectedSQLScriptsForSqlSets();
        for (int i = 0; i < stringArray.length; ++i) {
            Statement statement = null;
            ResultSet resultSet = null;
            if (!Connections.getInstance().lock(this.m_STCommon.getConnection())) continue;
            try {
                statement = this.m_STCommon.getConnection().createStatement();
                resultSet = statement.executeQuery(stringArray[i]);
                continue;
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
                continue;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, String> getSqlIdForEachSqlStatement() {
        String[] stringArray = this.m_STCommon.getSelectedSQLScriptsForSqlSets();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            Statement statement = null;
            ResultSet resultSet = null;
            String string = "select sql_id from v$sql where sql_text = '" + stringArray[i].replaceAll("'", "''") + "'";
            if (!Connections.getInstance().lock(this.m_STCommon.getConnection())) continue;
            try {
                statement = this.m_STCommon.getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                String string2 = null;
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                }
                hashtable.put(string2, stringArray[i]);
                continue;
            }
            catch (SQLException sQLException) {
                ExceptionHandler.handleException((Throwable)sQLException);
                continue;
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        ExceptionHandler.handleException((Throwable)exception);
                    }
                }
                Connections.getInstance().unlock(this.m_STCommon.getConnection());
            }
        }
        return hashtable;
    }

    public void executeSQLSqlScriptsForSqlId() {
        this.executeMultipleSqlStatments();
        this.m_STCommon.setSqlIdAndSqlScript(this.getSqlIdForEachSqlStatement());
    }

    public SqlTuningCommon getSqlTuningCommon() {
        return this.m_STCommon;
    }

    public void setSqlTuningCommon(SqlTuningCommon sqlTuningCommon) {
        this.m_STCommon = sqlTuningCommon;
    }

    public SqlTuningAdvisor getSqlTuningAdvisor() {
        return this.m_STAdvisor;
    }

    public void setSqlTuningAdvisor(SqlTuningAdvisor sqlTuningAdvisor) {
        this.m_STAdvisor = sqlTuningAdvisor;
    }
}

