/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.scriptrunner.task.consumer;

import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetTaskResultPanel;
import oracle.dbtools.worksheet.commands.scriptrunner.api.IScriptConsumer;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ITabListener;
import oracle.dbtools.worksheet.commands.scriptrunner.task.ScriptRunnerPanel;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class DefaultScriptConsumer
implements IScriptConsumer {
    StringBuffer m_inputBuffer = null;
    ScriptRunnerPanel m_panel = null;
    private int m_count = 0;
    private Logger m_logger = Logger.getLogger(DefaultScriptConsumer.class.getName());
    private long lastDisplayTime = 0L;
    private int millisecondsToWait = 100;

    public DefaultScriptConsumer(String string, WorksheetContext worksheetContext, ITabListener iTabListener) {
        this.m_inputBuffer = new StringBuffer();
        this.m_panel = new ScriptRunnerPanel(string, worksheetContext);
        this.m_panel.addTabListener(iTabListener);
    }

    @Override
    public void restart() {
    }

    @Override
    public void finish() {
        if (this.m_inputBuffer.length() > 0) {
            this.printToUI(this.m_inputBuffer);
            this.m_count = 0;
            this.m_inputBuffer.setLength(0);
        }
    }

    @Override
    public void consumerItermediateResult(String string) {
        boolean bl = string.endsWith("force_print");
        if (bl || this.timeToPrint()) {
            if (!(string = this.trimToForcePrint(string)).trim().equals("") || !bl) {
                this.m_inputBuffer.append(string + "\n");
            }
            this.printToUI(this.m_inputBuffer);
            this.m_count = 0;
            this.m_inputBuffer.setLength(0);
        } else if (!bl) {
            this.m_inputBuffer.append(string + "\n");
            ++this.m_count;
        }
    }

    private boolean timeToPrint() {
        long l = System.currentTimeMillis();
        if (l > this.lastDisplayTime + (long)this.millisecondsToWait) {
            this.lastDisplayTime = l;
            return true;
        }
        return false;
    }

    private String trimToForcePrint(String string) {
        int n = string.indexOf("force_print");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private void printToUI(StringBuffer stringBuffer) {
        this.printAllToUI(stringBuffer);
    }

    private void printAllToUI(StringBuffer stringBuffer) {
        PushTextToEDT pushTextToEDT = new PushTextToEDT(stringBuffer);
        if (SwingUtilities.isEventDispatchThread()) {
            pushTextToEDT.run();
        } else {
            SwingUtilities.invokeLater(pushTextToEDT);
        }
    }

    @Override
    public WorksheetTaskResultPanel getPanel() {
        return this.m_panel;
    }

    private BasicEditorPane getBasicEditorPane() {
        return this.m_panel.getTextPane();
    }

    private BasicDocument getDocument() {
        if (this.getBasicEditorPane() != null) {
            return (BasicDocument)this.getBasicEditorPane().getDocument();
        }
        return null;
    }

    private class PushTextToEDT
    implements Runnable {
        private char[] m_chars = null;
        private int m_stringBufferSize = 0;

        public PushTextToEDT(StringBuffer stringBuffer) {
            this.getChars(stringBuffer);
        }

        private void getChars(StringBuffer stringBuffer) {
            this.m_stringBufferSize = stringBuffer.length();
            this.m_chars = new char[this.m_stringBufferSize];
            stringBuffer.getChars(0, this.m_stringBufferSize, this.m_chars, 0);
        }

        @Override
        public void run() {
            final BasicDocument basicDocument = DefaultScriptConsumer.this.getDocument();
            if (basicDocument != null) {
                basicDocument.getTextBuffer().append(this.m_chars);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DefaultScriptConsumer.this.getBasicEditorPane().setCaretPositionCenter(basicDocument.getLineStartOffset(basicDocument.getLineCount()));
                    }
                });
            }
        }
    }
}

