/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.SerializedData;
import oracle.dbtools.raptor.plsql.structure.AutoCompleter;
import oracle.dbtools.util.Service;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.treetable.JTreeTable;

public class SearchPanel
extends JPanel {
    JTreeTable tbl;
    Map<Long, Integer> matches = new TreeMap<Long, Integer>();
    private int current = -1;
    JTextField input;
    JButton search;
    JLabel entry;
    JButton previous;
    JButton next;

    public String getTerm() {
        return this.input.getText();
    }

    public boolean isMatched(int n, int n2) {
        long l = Service.lPair((int)n2, (int)n);
        Integer n3 = this.matches.get(l);
        return n3 != null;
    }

    public long currentMatch() {
        for (long l : this.matches.keySet()) {
            int n = this.matches.get(l);
            if (n != this.current) continue;
            return l;
        }
        throw new AssertionError((Object)"mismatch");
    }

    public SearchPanel(JTreeTable jTreeTable) {
        this.tbl = jTreeTable;
        this.input = new JTextField(10);
        this.input.getAccessibleContext().setAccessibleName(Messages.getString("AutotracePanel.Input"));
        this.input.setToolTipText(Messages.getString("AutotracePanel.InputTooltip"));
        this.add(this.input);
        this.search = new JButton(OracleIcons.getIcon((String)"search.png"));
        this.search.getAccessibleContext().setAccessibleName(Messages.getString("AutotracePanel.Search"));
        this.search.setToolTipText(Messages.getString("AutotracePanel.SearchTooltip"));
        this.search.setEnabled(false);
        this.search.setBorder(new LineBorder(Color.GRAY));
        this.add(this.search);
        final JButton jButton = new JButton(OracleIcons.getIcon((String)"delete.png"));
        jButton.getAccessibleContext().setAccessibleName(Messages.getString("AutotracePanel.ClearSearch"));
        jButton.setToolTipText(Messages.getString("AutotracePanel.ClearSearchTooltip"));
        jButton.setEnabled(false);
        jButton.setBorder(new LineBorder(Color.GRAY));
        this.add(jButton);
        this.entry = new JLabel();
        this.add(this.entry);
        this.previous = new JButton(OracleIcons.getIcon((String)"previous.png"));
        this.previous.getAccessibleContext().setAccessibleName(Messages.getString("AutotracePanel.Previous"));
        this.previous.setToolTipText(Messages.getString("AutotracePanel.PreviousTooltip"));
        this.previous.setEnabled(false);
        this.previous.setBorder(new LineBorder(Color.GRAY));
        this.add(this.previous);
        this.next = new JButton(OracleIcons.getIcon((String)"next.png"));
        this.next.getAccessibleContext().setAccessibleName(Messages.getString("AutotracePanel.Next"));
        this.next.setToolTipText(Messages.getString("AutotracePanel.NextTooltip"));
        this.next.setEnabled(false);
        this.next.setBorder(new LineBorder(Color.GRAY));
        this.add(this.next);
        this.input.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    SearchPanel.this.doSearch();
                    return;
                }
                SearchPanel.this.previous.setEnabled(false);
                SearchPanel.this.next.setEnabled(false);
                String string = SearchPanel.this.input.getText();
                SearchPanel.this.search.setEnabled(0 < string.length());
                jButton.setEnabled(0 < string.length());
                if (string.length() < 1) {
                    SearchPanel.this.entry.setText("");
                    return;
                }
                SearchPanel.this.entry.setText("");
            }
        });
        this.search.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.doSearch();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.input.setText("");
                SearchPanel.this.search.setEnabled(false);
                jButton.setEnabled(false);
                SearchPanel.this.input.requestFocus();
                SearchPanel.this.doSearch("");
            }
        });
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.current = 0 < SearchPanel.this.current ? --SearchPanel.this.current : SearchPanel.this.matches.size() - 1;
                SearchPanel.this.entry.setText(SearchPanel.this.current + 1 + " of " + SearchPanel.this.matches.size());
                long l = SearchPanel.this.currentMatch();
                int n = Service.lY((long)l);
                int n2 = Service.lX((long)l);
                SearchPanel.this.tbl.scrollToVisible(n, n2);
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.current = SearchPanel.this.current < SearchPanel.this.matches.size() - 1 ? ++SearchPanel.this.current : 0;
                SearchPanel.this.entry.setText(SearchPanel.this.current + 1 + " of " + SearchPanel.this.matches.size());
                long l = SearchPanel.this.currentMatch();
                int n = Service.lY((long)l);
                int n2 = Service.lX((long)l);
                SearchPanel.this.tbl.scrollToVisible(n, n2);
                SearchPanel.this.tbl.setRowSelectionInterval(n, n + 1);
            }
        });
        SerializedData serializedData = SerializedData.getInstance();
        if (serializedData.searchInsight) {
            new AutoCompleter(this.input){

                protected boolean updateListData() {
                    String string = this.textComp.getText();
                    if (string.length() < 1) {
                        return false;
                    }
                    SearchPanel.this.findMatches(string);
                    JTree jTree = SearchPanel.this.tbl.getTree();
                    TreeSet<String> treeSet = new TreeSet<String>();
                    for (long l : SearchPanel.this.matches.keySet()) {
                        int n = Service.lY((long)l);
                        int n2 = Service.lX((long)l);
                        String string2 = SearchPanel.this.tbl.getColumnName(n2);
                        TreePath treePath = jTree.getPathForRow(n);
                        RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
                        String string3 = rowSrcNode.getValue(string2);
                        if (string3 == null || string3.length() >= 100 || !string3.toLowerCase().contains(string.toLowerCase())) continue;
                        treeSet.add(string3);
                    }
                    if (100 < treeSet.size()) {
                        return false;
                    }
                    this.list.setListData(treeSet.toArray(new String[0]));
                    return true;
                }

                protected void acceptedListItem(String string) {
                    if (string == null || "...".equals(string.toString())) {
                        return;
                    }
                    String string2 = this.textComp.getText();
                    int n = string2.length();
                    this.textComp.setText(string.toString());
                    SearchPanel.this.findMatches(string);
                }
            };
        }
    }

    private void doSearch() {
        this.doSearch(this.getTerm());
    }

    private void doSearch(String string) {
        this.findMatches(string);
        this.entry.setText("");
        this.current = 0;
        if (this.matches.size() == 0) {
            if (0 < string.length()) {
                this.entry.setText(Messages.getString("AutotracePanel.ZeroHits"));
            }
            this.previous.setEnabled(false);
            this.next.setEnabled(false);
            this.tbl.getTree().collapseRow(0);
            this.tbl.getTree().expandRow(0);
            return;
        }
        this.previous.setEnabled(true);
        this.next.setEnabled(true);
        this.entry.setText(this.current + 1 + " of " + this.matches.size());
        long l = this.currentMatch();
        int n = Service.lY((long)l);
        int n2 = Service.lX((long)l);
        this.tbl.scrollToVisible(n, n2);
        this.tbl.getTree().collapseRow(0);
        this.tbl.getTree().expandRow(0);
    }

    private synchronized void findMatches(String string) {
        this.matches = new TreeMap<Long, Integer>();
        if (string.length() == 0) {
            return;
        }
        JTree jTree = this.tbl.getTree();
        int n = 0;
        for (int i = 0; i < jTree.getRowCount(); ++i) {
            TreePath treePath = jTree.getPathForRow(i);
            RowSrcNode rowSrcNode = (RowSrcNode)treePath.getLastPathComponent();
            for (int j = 0; j < this.tbl.getColumnCount(); ++j) {
                String string2 = this.tbl.getColumnName(j);
                String string3 = rowSrcNode.getValue(string2);
                if (string3 == null || !string3.toLowerCase().contains(string.toLowerCase())) continue;
                long l = Service.lPair((int)j, (int)i);
                this.matches.put(l, n++);
            }
        }
        this.current = -1;
    }
}

