/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Color;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import oracle.dbtools.raptor.SerializedData;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.BaseRaptorImages;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.commands.autotrace.NumOverlayIcon;
import oracle.dbtools.worksheet.commands.autotrace.RowSrcNode;

class AutotraceTreeNode
extends RowSrcNode {
    String m_id = null;
    String operation = null;
    String objectName = null;
    String qBlockName = null;
    String options = null;
    Map<String, String> extra = new TreeMap<String, String>();
    String accessPredicates = null;
    String filterPredicates = null;
    String projection = null;
    String otherXml = null;
    String partitionStart = null;
    String partitionStop = null;
    String partitionId = null;
    Color color = new Color(0);
    private AutotraceTreeNode orig = null;
    boolean isSpanned = false;
    String predicates = null;
    Icon overlay = null;
    boolean isHint = false;
    DBConfig conf = null;
    static final String LAST_ELAPSED_TIME = "LAST_ELAPSED_TIME";
    static final String CARDINALITY = "CARDINALITY";
    static final String LAST_OUTPUT_ROWS = "LAST_OUTPUT_ROWS";
    int execOrder;
    boolean ignorePredicates;

    @Override
    public AutotraceTreeNode clone(RowSrcNode rowSrcNode) {
        AutotraceTreeNode autotraceTreeNode = new AutotraceTreeNode(this.operation);
        autotraceTreeNode.orig = this;
        autotraceTreeNode.m_id = this.m_id;
        autotraceTreeNode.objectName = this.objectName;
        autotraceTreeNode.qBlockName = this.qBlockName;
        autotraceTreeNode.options = this.options;
        autotraceTreeNode.accessPredicates = this.accessPredicates;
        autotraceTreeNode.filterPredicates = this.filterPredicates;
        autotraceTreeNode.projection = this.projection;
        autotraceTreeNode.partitionStart = this.partitionStart;
        autotraceTreeNode.partitionStop = this.partitionStop;
        autotraceTreeNode.partitionId = this.partitionId;
        autotraceTreeNode.color = this.color;
        autotraceTreeNode.isSpanned = this.isSpanned;
        autotraceTreeNode.predicates = this.predicates;
        autotraceTreeNode.overlay = this.overlay;
        autotraceTreeNode.ignorePredicates = ((AutotraceTreeNode)this.getRoot()).ignorePredicates;
        autotraceTreeNode.cascadeDiff = ((AutotraceTreeNode)this.getRoot()).cascadeDiff;
        autotraceTreeNode.extra.putAll(this.extra);
        for (int i = 0; i < this.getChildCount(); ++i) {
            AutotraceTreeNode autotraceTreeNode2 = (AutotraceTreeNode)this.getChildAt(i);
            AutotraceTreeNode autotraceTreeNode3 = autotraceTreeNode2.clone(rowSrcNode);
            autotraceTreeNode.add(autotraceTreeNode3);
        }
        if (rowSrcNode != null && !this.matchExists(rowSrcNode)) {
            autotraceTreeNode.overlay = RaptorImagesArb.getIcon((String)"EXCLAMATION");
        }
        return autotraceTreeNode;
    }

    public AutotraceTreeNode(String string) {
        try {
            this.conf = DBConfig.getInstance();
        }
        catch (Throwable throwable) {
            this.conf = new DBConfig();
        }
        this.execOrder = -1;
        this.ignorePredicates = false;
        this.operation = string;
    }

    @Override
    public Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        return super.getColor();
    }

    @Override
    public String tooltip() {
        if (this.qBlockName != null) {
            return "id=" + this.m_id + "   " + this.operation + " @" + this.qBlockName;
        }
        if (this.operation.endsWith("Predicates")) {
            return this.predicates;
        }
        if (this.m_id != null) {
            return "id=" + this.m_id + "   " + this.operation;
        }
        return this.operation;
    }

    @Override
    public String operation() {
        return this.operation;
    }

    @Override
    public String toString() {
        Object object = "";
        SerializedData serializedData = SerializedData.getInstance();
        if (this.options != null && (this.isExplainPlan() && (Boolean)serializedData.explainOptions.get("OPTIONS") == false || !this.isExplainPlan() && (Boolean)serializedData.autotraceOptions.get("OPTIONS") == false || this.orig != null)) {
            object = " (" + this.options + ") ";
        }
        String string = "";
        if (this.objectName != null && (this.isExplainPlan() && (Boolean)serializedData.explainOptions.get("OBJECT_NAME") == false || !this.isExplainPlan() && (Boolean)serializedData.autotraceOptions.get("OBJECT_NAME") == false || this.orig != null)) {
            string = this.objectName;
        }
        return this.operation + (String)object + string;
    }

    private boolean isExplainPlan() {
        String string = this.extra.get("LAST_CR_BUFFER_GETS");
        return string == null || "N/A".equals(string);
    }

    @Override
    public String getValue(String string) {
        if ("...".equals(this.operation)) {
            return "...";
        }
        if ("OPERATION".equals(string)) {
            return this.operation;
        }
        if (this.isSpanned) {
            return "";
        }
        if ("OBJECT_NAME".equals(string)) {
            return this.objectName;
        }
        if ("OPTIONS".equals(string)) {
            return this.options;
        }
        if ("PARTITION_START".equals(string)) {
            return this.partitionStart;
        }
        if ("PARTITION_STOP".equals(string)) {
            return this.partitionStop;
        }
        if ("PARTITION_ID".equals(string)) {
            return this.partitionId;
        }
        if ("ACCESS_PREDICATES".equals(string)) {
            return this.accessPredicates;
        }
        if ("FILTER_PREDICATES".equals(string)) {
            return this.filterPredicates;
        }
        if ("PROJECTION".equals(string)) {
            return this.projection;
        }
        if ("OTHER_XML".equals(string)) {
            return this.otherXml;
        }
        if ("EXEC#".equals(string)) {
            return 0 < this.execOrder ? "" + this.execOrder : "";
        }
        if ("OTHER_TAG".equals(string)) {
            return this.parallel_sugarcoat(this.extra.get(string));
        }
        if (this.extra.containsKey(string)) {
            return this.extra.get(string);
        }
        System.out.println("???" + string);
        return "???";
    }

    private String parallel_sugarcoat(String string) {
        if ("PARALLEL_TO_SERIAL".equals(string)) {
            return "P->S";
        }
        if ("PARALLEL_COMBINED_WITH_PARENT".equals(string)) {
            return "PCWP";
        }
        if ("PARALLEL_COMBINED_WITH_CHILD".equals(string)) {
            return "PCWC";
        }
        if ("PARALLEL_TO_PARALLEL".equals(string)) {
            return "P->P";
        }
        if ("SERIAL_TO_PARALLEL".equals(string)) {
            return "S->P";
        }
        return string;
    }

    public static boolean isSpecialColumn(String string) {
        if ("Partition Columns".equals(string)) {
            return true;
        }
        if ("Predicates Branch".equals(string)) {
            return true;
        }
        if ("Predicates Column".equals(string)) {
            return true;
        }
        if ("Projection Branch".equals(string)) {
            return true;
        }
        if ("Projection Column".equals(string)) {
            return true;
        }
        if ("Other XML Branch".equals(string)) {
            return true;
        }
        if ("Other XML Column".equals(string)) {
            return true;
        }
        if ("Execution Order Overlay".equals(string)) {
            return true;
        }
        if ("Execution Order Column".equals(string)) {
            return true;
        }
        return "OBJECT_NAME".equals(string) || "OPTIONS".equals(string) || "OPERATION".equals(string) || "OTHER_XML".equals(string) || "PROJECTION".equals(string);
    }

    @Override
    public Icon getIcon() {
        Icon icon = null;
        icon = "Access Predicates".equals(this.operation) ? WorksheetResources.getIcon("SIGMAKEYS_ICON") : ("Filter Predicates".equals(this.operation) ? WorksheetResources.getIcon("SIGMAFILTER_ICON") : ("NESTED LOOPS".equals(this.operation) || "MERGE JOIN".equals(this.operation) || "HASH JOIN".equals(this.operation) ? WorksheetResources.getIcon("JOIN_ICON") : ("UNION-ALL".equals(this.operation) ? WorksheetResources.getIcon("UNION_ICON") : (this.operation != null && this.operation.contains("TABLE") ? WorksheetResources.getIcon("TABLE_ICON") : ("VIEW".equals(this.operation) ? WorksheetResources.getIcon("VIEW_ICON") : ("OR".equals(this.operation) ? WorksheetResources.getIcon("OR_ICON") : ("AND".equals(this.operation) ? WorksheetResources.getIcon("AND_ICON") : ("Projection".equals(this.operation) ? WorksheetResources.getIcon("PI_ICON") : (this.operation.startsWith("INDEX") ? WorksheetResources.getIcon("INDEX_ICON") : (this.operation.startsWith("SORT") ? BaseRaptorImages.getIcon((String)"SORTASCENDING_ENA") : (this.isSpanned ? WorksheetResources.getIcon("EMPTY_ICON") : WorksheetResources.getIcon("GRAY_ICON"))))))))))));
        int n = -1;
        if (this.showExecOverlay()) {
            n = this.execOrder;
        }
        return new NumOverlayIcon(icon, this.overlay, n);
    }

    protected boolean showExecOverlay() {
        SerializedData serializedData = SerializedData.getInstance();
        if (this.isExplainPlan()) {
            return (Boolean)serializedData.explainOptions.get("Execution Order Overlay");
        }
        return (Boolean)serializedData.autotraceOptions.get("Execution Order Overlay");
    }

    @Override
    public boolean stucturallyTheSame(RowSrcNode rowSrcNode) {
        AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)rowSrcNode;
        return !(!AutotraceTreeNode.equals(this.operation, autotraceTreeNode.operation) || !AutotraceTreeNode.equals(this.objectName, autotraceTreeNode.objectName) || !AutotraceTreeNode.equals(this.options, autotraceTreeNode.options) || !((AutotraceTreeNode)this.getRoot()).ignorePredicates && !AutotraceTreeNode.equals(this.accessPredicates, autotraceTreeNode.accessPredicates) || !((AutotraceTreeNode)this.getRoot()).ignorePredicates && !AutotraceTreeNode.equals(this.filterPredicates, autotraceTreeNode.filterPredicates));
    }

    private static boolean equals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    @Override
    public int depth() {
        if (this.parent == null) {
            return 0;
        }
        return ((AutotraceTreeNode)this.parent).depth() + 1;
    }

    @Override
    public Long individualRunTime() {
        long l = this.lastElapsedTime();
        for (int i = 0; i < this.getChildCount(); ++i) {
            AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)this.getChildAt(i);
            l -= autotraceTreeNode.lastElapsedTime();
        }
        return l;
    }

    private long lastElapsedTime() {
        String string = this.getValue(LAST_ELAPSED_TIME);
        if (string != null && !"".equals(string)) {
            return Long.parseLong(string);
        }
        return 0L;
    }

    @Override
    public Long cardinality() {
        String string = this.getValue(CARDINALITY);
        Long l = null;
        if (string != null && !"".equals(string)) {
            l = Long.parseLong(string);
        }
        return l;
    }

    @Override
    public Long rows() {
        String string = this.getValue(LAST_OUTPUT_ROWS);
        Long l = null;
        if (string != null && !"".equals(string)) {
            l = Long.parseLong(string);
        }
        return l;
    }

    @Override
    public boolean isSpanned() {
        return this.isSpanned;
    }

    boolean isTableAccess() {
        return this.operation != null && (this.operation.startsWith("TABLE ACCESS") || this.operation.startsWith("INDEX") || this.operation.startsWith("FIXED TABLE"));
    }

    boolean isJoinEnd() {
        AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)this.getParent();
        for (int i = 0; i < autotraceTreeNode.getChildCount(); ++i) {
            AutotraceTreeNode autotraceTreeNode2 = (AutotraceTreeNode)autotraceTreeNode.getChildAt(i);
            if (autotraceTreeNode2.isSpanned || autotraceTreeNode2.isTableAccess()) continue;
            return false;
        }
        return true;
    }

    String joinMethodRgtChildAlias() {
        if (this.operation == null) {
            return null;
        }
        if (this.operation.startsWith("NESTED LOOPS") || this.operation.startsWith("HASH JOIN") || this.operation.startsWith("MERGE JOIN")) {
            for (int i = 1; i < this.getChildCount(); ++i) {
                AutotraceTreeNode autotraceTreeNode = (AutotraceTreeNode)this.getChildAt(i);
                if (autotraceTreeNode.isSpanned) continue;
                if (autotraceTreeNode.getValue("OBJECT_ALIAS") != null) {
                    return autotraceTreeNode.getValue("OBJECT_ALIAS");
                }
                if (autotraceTreeNode.objectName != null && !"".equals(autotraceTreeNode.objectName)) continue;
                for (int j = 0; j < autotraceTreeNode.getChildCount(); ++j) {
                    AutotraceTreeNode autotraceTreeNode2 = (AutotraceTreeNode)autotraceTreeNode.getChildAt(j);
                    if (autotraceTreeNode2.isSpanned || autotraceTreeNode2.getValue("OBJECT_ALIAS") == null) continue;
                    return autotraceTreeNode2.getValue("OBJECT_ALIAS");
                }
            }
        }
        return null;
    }

    @Override
    public boolean ignorePredicates() {
        return this.ignorePredicates;
    }

    AutotraceTreeNode findOtherXML() {
        if ("Other XML".equals(this.toString())) {
            return this;
        }
        AutotraceTreeNode autotraceTreeNode = null;
        for (int i = 0; i < this.getChildCount(); ++i) {
            TreeNode treeNode = this.getChildAt(i);
            autotraceTreeNode = ((AutotraceTreeNode)treeNode).findOtherXML();
            if (autotraceTreeNode == null) continue;
            return autotraceTreeNode;
        }
        return null;
    }
}

