/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.sql.Connection;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.util.SqlLocator;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.utils.CursorUI;
import oracle.ide.help.HelpSystem;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

abstract class AnalyzeAction
extends RaptorTask<Void> {
    protected WorksheetContext ctx;
    int cursorPosition = 0;
    int selectionStart = 0;
    int selectionEnd = 0;
    protected Connection conn;
    protected AutotracePanel autoTracePanel = null;

    public AnalyzeAction(String string, String string2, WorksheetContext worksheetContext) {
        super(string, true, IRaptorTaskRunMode.TASKVIEWER);
        this.ctx = worksheetContext;
        this.setPausable(false);
        this.setCancellable(true);
    }

    public void setConnection(Connection connection) {
        this.conn = connection;
    }

    public AutotracePanel getAutoTracePanel() {
        return this.autoTracePanel;
    }

    public void setAutoTracePanel(AutotracePanel autotracePanel) {
        this.autoTracePanel = autotracePanel;
        this.autoTracePanel.setContext(this.ctx);
    }

    public String extractSql(String string) {
        this.cursorPosition = this.ctx.getEditor().getCaretPosition();
        this.selectionStart = this.ctx.getEditor().getSelectionStart();
        this.selectionEnd = this.ctx.getEditor().getSelectionEnd();
        if (this.selectionStart + 10 < this.selectionEnd) {
            try {
                String string2 = this.ctx.getEditor().getText(this.selectionStart, this.selectionEnd - this.selectionStart);
                string2 = SqlLocator.extractStmt((int)-1, (String)string2, (String)string);
                return string2;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        String string3 = this.ctx.getParser().text;
        return SqlLocator.extractStmt((int)this.cursorPosition, (String)string3, (String)string);
    }

    public int[] getSelectionLineColumn() {
        int n = this.ctx.getEditor().getSelectionStart();
        BasicDocument basicDocument = (BasicDocument)this.ctx.getEditor().getDocument();
        LineMap lineMap = basicDocument.getLineMap();
        int n2 = lineMap.getLineFromOffset(n) + 1;
        int n3 = lineMap.getLineStartOffset(n2 - 1);
        int n4 = n - n3 + 1;
        int[] nArray = new int[]{n2, n4};
        return nArray;
    }

    protected boolean init() {
        try {
            this.conn = Connections.getInstance().getConnection(this.ctx.getConnectionName());
        }
        catch (DBException dBException) {
            return false;
        }
        return true;
    }

    protected void showResultPanel() {
        if (this.ctx != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this.autoTracePanel, "f1_explainplan_html");
            this.ctx.getCallback().showResultPanel(this.autoTracePanel);
            this.autoTracePanel.open();
        }
    }

    void resetCursor() {
        BasicEditorPane basicEditorPane = this.ctx.getEditor();
        SwingUtilities.invokeLater(new CursorUI(this.cursorPosition, this.selectionStart != this.selectionEnd, this.selectionStart, this.selectionEnd, basicEditorPane));
    }
}

