/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.commands.autotrace.AutotraceTreeModel;
import oracle.dbtools.worksheet.commands.sqltuningadvisor.SqlTuningAdvisorPanel;

public abstract class WorksheetFeatures {
    public static final Class[] AUTOTRACE_MODEL_REQUIREMENTS = new Class[]{AutotracePanel.class};
    public static final Class[] SQLTUNINGADVISOR_MODEL_REQUIREMENTS = new Class[]{SqlTuningAdvisorPanel.class};
    public static final String ACTION_COMMIT_SUPPORTED = "WorksheetSupportRegistry.ActionCommitSupported";
    public static final String ACTION_ROLLBACK_SUPPORTED = "WorksheetSupportRegistry.ActionRollbackSupported";
    private static final Map<String, WorksheetFeatures> s_registry = new HashMap<String, WorksheetFeatures>();
    private static final WorksheetFeatures DEFAULT_FEATURES;
    private Set<String> m_supportedFeatures = new HashSet<String>();

    public static void registerFeatures(String string, WorksheetFeatures worksheetFeatures) {
        s_registry.put(string, worksheetFeatures);
    }

    public static WorksheetFeatures getFeatures(String string) {
        if (string == null) {
            return DEFAULT_FEATURES;
        }
        WorksheetFeatures worksheetFeatures = s_registry.get(string);
        if (worksheetFeatures == null) {
            worksheetFeatures = DEFAULT_FEATURES;
            s_registry.put(string, worksheetFeatures);
        }
        return worksheetFeatures;
    }

    public WorksheetFeatures(Collection<String> collection) {
        this.m_supportedFeatures.addAll(collection);
    }

    public WorksheetFeatures() {
    }

    public boolean isFeatureSupported(String string) {
        return this.m_supportedFeatures.contains(string);
    }

    public abstract Constructor<? extends AutotraceTreeModel> getAutotraceModelConstructor();

    static {
        String[] stringArray = new String[]{ACTION_COMMIT_SUPPORTED, ACTION_ROLLBACK_SUPPORTED};
        WorksheetFeatures.registerFeatures("oracle.jdbc.OracleDriver", new WorksheetFeatures(Arrays.asList(stringArray)){
            private Constructor<? extends AutotraceTreeModel> m_autotraceCtor;

            @Override
            public Constructor<? extends AutotraceTreeModel> getAutotraceModelConstructor() {
                if (this.m_autotraceCtor == null) {
                    try {
                        this.m_autotraceCtor = AutotraceTreeModel.class.getDeclaredConstructor(AUTOTRACE_MODEL_REQUIREMENTS);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(WorksheetFeatures.class.getName()).severe(exception.getLocalizedMessage());
                    }
                }
                return this.m_autotraceCtor;
            }
        });
        DEFAULT_FEATURES = new WorksheetFeatures(){

            @Override
            public Constructor<? extends AutotraceTreeModel> getAutotraceModelConstructor() {
                return null;
            }
        };
    }
}

