/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sybase12;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserDefinedDataType;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.metadata.persistence.PrepareClobHelper;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.sybase12.Sybase12Messages;

public abstract class Sybase12AbstractCapturer {
    protected boolean m_online = true;
    protected boolean Flag15 = false;
    protected Connection m_sourceConnection = null;
    protected MigrationStorer m_storer = null;
    public static final String MY_LANGUAGE_ID = "STSQL";
    public static int OfflineDbId;
    private static HashSet<Long> m_hSetDb;
    private static HashMap<Long, Long> m_connToMinSchema;
    public static final String DDL_NOT_ACCESSIBLE;

    public void setStorer(MigrationStorer migrationStorer) {
        this.m_storer = migrationStorer;
    }

    public MigrationStorer getStorer() {
        return this.m_storer;
    }

    public Connection getRepositoryConnection() {
        return this.m_sourceConnection;
    }

    public void setRepositoryConnection(Connection connection) {
        this.m_sourceConnection = connection;
    }

    protected abstract String getCAPTURE_CATALOGS_QUERY();

    protected abstract String getCAPTURE_SCHEMAS_QUERY();

    protected abstract String getCAPTURE_TABLES_QUERY();

    protected abstract String getCAPTURE_STORED_PROGRAMS_INNER_QUERY();

    protected abstract String getCAPTURE_STORED_PROGRAMS_OUTER_QUERY();

    protected abstract String getCAPTURE_VIEW_INNER_QUERY();

    protected abstract String getCAPTURE_VIEW_OUTER_QUERY();

    protected abstract String getCAPTURE_TRIGGER_INNER_QUERY();

    protected abstract String getCAPTURE_TRIGGER_OUTER_QUERY();

    protected abstract String getCAPTURE_PRIMARY_AND_FOREIGN_KEY_QUERY();

    protected abstract String getCAPTURE_CONSTRAINTS_QUERY();

    protected abstract String getUSER_DEFINED_TYPES_QUERY();

    protected abstract String getCAPTURE_COLUMNSDESCRIPTION_QUERY();

    protected abstract String getCAPTURE_COLUMNDEFAULT_QUERY();

    protected abstract String getCAPTURE_COLUMN_USER_TYPE();

    protected abstract String getCAPTURE_INDEXESDESCRIPTION_QUERY();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureObjects(String string, CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws PersistenceException, CaptureException {
        try {
            int n = 0;
            if (string.equals("MD_CATALOGS")) {
                this.captureCatalogs(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_SCHEMAS")) {
                this.captureSchemas(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_USERS")) {
                this.captureUsers(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_TABLES")) {
                this.captureTables(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_COLUMNS")) {
                this.captureColumns(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_INDEXES")) {
                this.captureIndexes(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_INDEX_DETAILS")) {
                ++n;
                return;
            }
            if (string.equals("MD_CONSTRAINTS")) {
                this.captureConstraints(captureContext);
                return;
            }
            if (string.equals("MD_CONSTRAINT_DETAILS")) {
                ++n;
                return;
            }
            if (string.equals("MD_VIEWS")) {
                this.captureViews(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_STORED_PROGRAMS")) {
                this.captureStoredPrograms(captureContext, migrationObjectFilter);
                return;
            }
            if (string.equals("MD_TRIGGERS")) {
                this.captureTriggers(captureContext, migrationObjectFilter);
                return;
            }
            if (!string.equals("MD_GROUPS")) return;
        }
        catch (SQLException sQLException) {
            throw new CaptureException((Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureCatalogs(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        Object var3_3 = null;
        String string = this.getCAPTURE_CATALOGS_QUERY();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.getRepositoryConnection().prepareStatement(string);
            if (!this.m_online) {
                preparedStatement.setInt(1, OfflineDbId);
            }
            try {
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next() && !captureContext.shouldCancel()) {
                    if (migrationObjectFilter == null || migrationObjectFilter.getFilterType() == 1) {
                        // empty if block
                    }
                    this.ProcessCatalogRow(resultSet, this.getStorer(), captureContext);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (var3_3 != null) {
                    var3_3.close();
                }
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureSchemas(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getCAPTURE_SCHEMAS_QUERY());
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_SCHEMAS");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string = resultSet.getString(1)) || resultSet.getString(1).equalsIgnoreCase("information_schema") || resultSet.getString(1).equalsIgnoreCase("mysql")) continue;
                QueryCapture.processSchemaRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    protected void captureUsers(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        MdSchema mdSchema = (MdSchema)captureContext.getContextVariable("SCHEMAOBJ");
        Long l = ((DBObjectId)captureContext.getContextVariable("CONNECTIONID")).getId();
        Long l2 = m_connToMinSchema.get(l);
        Long l3 = mdSchema.getKey().getId();
        if (l2 == null || l2 > l3) {
            m_connToMinSchema.put(l, l3);
        }
        MdUser mdUser = new MdUser(mdSchema.getKey(), mdSchema.getName());
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_USER"), mdSchema.getName());
        captureContext.getAudience().fireListeners(captureEvent);
        mdUser = (MdUser)this.getStorer().storeObject((PersistableObject)mdUser);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureConstraints(CaptureContext captureContext) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getCAPTURE_CONSTRAINTS_QUERY());
        String string = (String)captureContext.getContextVariable("TABLE");
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string2 = resultSet.getString(1);
                string2 = string2.trim();
                String string3 = resultSet.getString(2);
                if (this.findMatch(string3 = string3.trim(), " CHECK ", true) && this.findMatch(string3, "CONSTRAINT ", true)) {
                    this.processCheckConstraint(captureContext, string2, string3);
                    continue;
                }
                if (this.findMatch(string3, "PRIMARY KEY ", true)) {
                    this.processPrimaryKeyConstraint(captureContext, string2, string3);
                    continue;
                }
                if (this.findMatch(string3, "UNIQUE ", true)) {
                    this.processUniqueKeyConstraint(captureContext, string2, string3);
                    continue;
                }
                if (!this.findMatch(string3, " FOREIGN KEY ", true)) continue;
                this.processForeignKeyConstraint(captureContext, string2, string3, string);
            }
        }
        catch (SQLException sQLException) {
            if (closeableResultSet == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_CONSTRAINTS", string);
            } else {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.11") + string);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    private boolean processForeignKeyConstraint(CaptureContext captureContext, String string, String string2, String string3) {
        String[] stringArray = string2.split(" ");
        String string4 = stringArray[0].trim();
        if (!string4.equals(string3)) {
            return false;
        }
        try {
            MdConstraintDetail mdConstraintDetail;
            String string5;
            String[] stringArray2 = string2.split("REFERENCES");
            String string6 = stringArray2[1].substring(0, stringArray2[1].indexOf(40));
            string6 = string6.trim();
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("SCHEMAID");
            DBObjectId dBObjectId2 = persistenceUtility.getIdForTable(dBObjectId, string6);
            if (dBObjectId2 == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.40") + " " + string);
                return false;
            }
            MdConstraint mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String string7 = "FOREIGN KEY";
            mdConstraint.setConstraintType(string7);
            mdConstraint.setName(string);
            mdConstraint.setReftableId(dBObjectId2);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
            String string8 = stringArray2[0].substring(stringArray2[0].indexOf(40) + 1, stringArray2[0].indexOf(41));
            String[] stringArray3 = this.splitColumns(string8);
            int n = 0;
            while (n < stringArray3.length) {
                string5 = stringArray3[n].trim();
                mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(++n));
                mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string5));
                CaptureEvent captureEvent2 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent2);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent2.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent2);
            }
            string5 = stringArray2[1].substring(stringArray2[1].indexOf(40) + 1, stringArray2[1].indexOf(41));
            mdConstraintDetail = this.splitColumns(string5);
            int n2 = 0;
            while (n2 < ((String[])mdConstraintDetail).length) {
                String string9 = mdConstraintDetail[n2].trim();
                MdConstraintDetail mdConstraintDetail2 = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(++n2));
                mdConstraintDetail2.setColumnId(persistenceUtility.getIdForColumn(dBObjectId2, string9));
                mdConstraintDetail2.setRefFlag("Y");
                CaptureEvent captureEvent3 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent3);
                mdConstraintDetail2 = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail2);
                captureEvent3.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent3);
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
        return true;
    }

    private void processUniqueKeyConstraint(CaptureContext captureContext, String string, String string2) {
        try {
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            MdConstraint mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String string3 = "UNIQUE";
            mdConstraint.setConstraintType(string3);
            mdConstraint.setName(string);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
            this.markForUniqueConstraintClustered(dBObjectId, string2, mdConstraint, captureContext);
            mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
            String string4 = string2.substring(string2.indexOf(40) + 1, string2.indexOf(41));
            String[] stringArray = this.splitColumns(string4);
            int n = 0;
            while (n < stringArray.length && !captureContext.shouldCancel()) {
                String string5 = stringArray[n].trim();
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(++n));
                mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string5));
                CaptureEvent captureEvent2 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent2);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent2.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent2);
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    private void processCheckConstraint(CaptureContext captureContext, String string, String string2) {
        try {
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            MdConstraint mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String string3 = "CHECK";
            mdConstraint.setConstraintType(string3);
            mdConstraint.setName(string);
            String string4 = string2.substring(string2.indexOf(40) + 1, string2.length() - 1);
            mdConstraint.setConstraintText(string4);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    public void processPrimaryKeyConstraint(CaptureContext captureContext, String string, String string2) {
        try {
            PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
            MdConstraint mdConstraint = new MdConstraint((DBObjectId)captureContext.getContextVariable("TABLEID"), MY_LANGUAGE_ID);
            String string3 = "PK";
            mdConstraint.setConstraintType(string3);
            mdConstraint.setName(string);
            CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINTS"), mdConstraint.getName());
            captureContext.getAudience().fireListeners(captureEvent);
            DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
            this.markForUniqueConstraintClustered(dBObjectId, string2, mdConstraint, captureContext);
            mdConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)mdConstraint);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
            String string4 = string2.substring(string2.indexOf(40) + 1, string2.indexOf(41));
            String[] stringArray = this.splitColumns(string4);
            int n = 0;
            while (n < stringArray.length && !captureContext.shouldCancel()) {
                String string5 = stringArray[n].trim();
                MdConstraintDetail mdConstraintDetail = new MdConstraintDetail(mdConstraint.getKey(), Integer.valueOf(++n));
                mdConstraintDetail.setColumnId(persistenceUtility.getIdForColumn(mdConstraint.getTableId(), string5));
                CaptureEvent captureEvent2 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CONSTRAINT_DETAILS"), mdConstraint.getName());
                captureContext.getAudience().fireListeners(captureEvent2);
                mdConstraintDetail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)mdConstraintDetail);
                captureEvent2.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent2);
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureStoredPrograms(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getCAPTURE_STORED_PROGRAMS_OUTER_QUERY());
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_STORED_PROGRAMS");
        String string = (String)captureContext.getContextVariable("SCHEMA");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string2;
                String string3;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string3 = resultSet.getString(1))) continue;
                int n = resultSet.getInt(3);
                PrepareClobHelper prepareClobHelper = new PrepareClobHelper();
                MdStoredProgram mdStoredProgram = new MdStoredProgram((DBObjectId)captureContext.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                String string4 = this.getCAPTURE_STORED_PROGRAMS_INNER_QUERY();
                PreparedStatement preparedStatement = null;
                ResultSet resultSet2 = null;
                try {
                    preparedStatement = this.getRepositoryConnection().prepareStatement(string4);
                    preparedStatement.setInt(1, n);
                    resultSet2 = preparedStatement.executeQuery();
                    while (resultSet2.next()) {
                        string2 = null;
                        try {
                            string2 = resultSet2.getString(2);
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                        prepareClobHelper.append(string2);
                    }
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close((Statement)preparedStatement, resultSet2);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet2);
                string2 = resultSet.getString(2);
                String string5 = resultSet.getString(1);
                ClobHelper clobHelper = prepareClobHelper.getClobHelper();
                if (clobHelper == null || clobHelper.getLength() == 0L) {
                    prepareClobHelper = new PrepareClobHelper();
                    prepareClobHelper.append(DDL_NOT_ACCESSIBLE);
                    clobHelper = prepareClobHelper.getClobHelper();
                }
                mdStoredProgram.setName(string5);
                mdStoredProgram.setNativeSql(clobHelper);
                String string6 = string2;
                if (string2.trim().equals("P")) {
                    string6 = "PROCEDURE";
                    string2 = "PROCEDURE";
                } else if (string2.equals("SF")) {
                    string6 = "FUNCTION";
                    string2 = "FUNCTION";
                } else if (string2.equals("FN")) {
                    string6 = "SCALAR FUNCTION";
                    string2 = "FUNCTION";
                } else if (string2.equals("TF")) {
                    string6 = "TABLE FUNCTION";
                    string2 = "FUNCTION";
                } else if (string2.equals("IF")) {
                    string6 = "INLINED T. FUNCTION";
                    string2 = "FUNCTION";
                } else {
                    string2 = "PROCEDURE";
                }
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                mdStoredProgram.addProperty("TYPE", string6, dBObjectId);
                mdStoredProgram.setProgramtype(string2);
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_STORED_PROGRAMS"), string5);
                captureContext.getAudience().fireListeners(captureEvent);
                mdStoredProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)mdStoredProgram);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                if (prepareClobHelper == null) continue;
                prepareClobHelper.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.24") + string);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureViews(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getCAPTURE_VIEW_OUTER_QUERY());
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_VIEWS");
        String string = (String)captureContext.getContextVariable("SCHEMA");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string2;
                String string3;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string3 = resultSet.getString(1))) continue;
                int n = resultSet.getInt(2);
                PrepareClobHelper prepareClobHelper = new PrepareClobHelper();
                MdView mdView = new MdView((DBObjectId)captureContext.getContextVariable("SCHEMAID"), MY_LANGUAGE_ID);
                String string4 = this.getCAPTURE_VIEW_INNER_QUERY();
                PreparedStatement preparedStatement = null;
                ResultSet resultSet2 = null;
                try {
                    preparedStatement = this.getRepositoryConnection().prepareStatement(string4);
                    preparedStatement.setInt(1, n);
                    resultSet2 = preparedStatement.executeQuery();
                    while (resultSet2.next()) {
                        string2 = null;
                        try {
                            string2 = resultSet2.getString(1);
                        }
                        catch (Exception exception) {
                            string2 = "";
                        }
                        prepareClobHelper.append(string2);
                    }
                }
                catch (Throwable throwable) {
                    CloseableResultSet.close((Statement)preparedStatement, resultSet2);
                    throw throwable;
                }
                CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet2);
                string2 = resultSet.getString(1);
                ClobHelper clobHelper = prepareClobHelper.getClobHelper();
                if (clobHelper == null || clobHelper.getLength() == 0L) {
                    prepareClobHelper = new PrepareClobHelper();
                    prepareClobHelper.append(DDL_NOT_ACCESSIBLE);
                    clobHelper = prepareClobHelper.getClobHelper();
                }
                mdView.setViewName(string2);
                mdView.setNativeSql(clobHelper);
                DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_VIEWS"), string2);
                captureContext.getAudience().fireListeners(captureEvent);
                mdView = (MdView)this.getStorer().storeObject((PersistableObject)mdView);
                captureEvent.setEventId(4);
                captureContext.getAudience().fireListeners(captureEvent);
                if (prepareClobHelper == null) continue;
                prepareClobHelper.close();
            }
        }
        catch (IOException iOException) {
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.27") + string);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTriggers(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        Object var3_3 = null;
        String string = this.getCAPTURE_TRIGGER_OUTER_QUERY();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            DBObjectId dBObjectId;
            String string2;
            preparedStatement = this.getRepositoryConnection().prepareStatement(string);
            String string3 = (String)captureContext.getContextVariable("SCHEMA");
            String string4 = (String)captureContext.getContextVariable("PER_CONTEXT");
            String string5 = null;
            if (string4.equals("MD_TABLES")) {
                string2 = "T";
                dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
                string5 = (String)captureContext.getContextVariable("TABLE");
            } else {
                string2 = "V";
                dBObjectId = (DBObjectId)captureContext.getContextVariable("VIEWID");
                string5 = (String)captureContext.getContextVariable("VIEW");
            }
            preparedStatement.setString(1, string3);
            preparedStatement.setString(2, string5);
            try {
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next() && !captureContext.shouldCancel()) {
                    String string6;
                    String string7 = resultSet.getString(1);
                    int n = resultSet.getInt(2);
                    PrepareClobHelper prepareClobHelper = new PrepareClobHelper();
                    MdTrigger mdTrigger = new MdTrigger(dBObjectId, string2, MY_LANGUAGE_ID);
                    String string8 = this.getCAPTURE_TRIGGER_INNER_QUERY();
                    PreparedStatement preparedStatement2 = null;
                    ResultSet resultSet2 = null;
                    try {
                        preparedStatement2 = this.getRepositoryConnection().prepareStatement(string8);
                        preparedStatement2.setInt(1, n);
                        resultSet2 = preparedStatement2.executeQuery();
                        while (resultSet2.next()) {
                            string6 = null;
                            try {
                                string6 = resultSet2.getString(1);
                            }
                            catch (Exception exception) {
                                string6 = "";
                            }
                            prepareClobHelper.append(string6);
                        }
                    }
                    catch (Throwable throwable) {
                        CloseableResultSet.close((Statement)preparedStatement2, resultSet2);
                        throw throwable;
                    }
                    CloseableResultSet.close((Statement)preparedStatement2, (ResultSet)resultSet2);
                    string6 = prepareClobHelper.getClobHelper();
                    if (string6 == null || string6.getLength() == 0L) {
                        prepareClobHelper = new PrepareClobHelper();
                        prepareClobHelper.append(DDL_NOT_ACCESSIBLE);
                        string6 = prepareClobHelper.getClobHelper();
                    }
                    mdTrigger.setTriggerName(string7);
                    mdTrigger.setNativeSql((ClobHelper)string6);
                    DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
                    CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_TRIGGERS"), string7);
                    captureContext.getAudience().fireListeners(captureEvent);
                    mdTrigger = (MdTrigger)this.getStorer().storeObject((PersistableObject)mdTrigger);
                    captureEvent.setEventId(4);
                    captureContext.getAudience().fireListeners(captureEvent);
                    if (prepareClobHelper == null) continue;
                    prepareClobHelper.close();
                }
            }
            catch (IOException iOException) {
            }
            catch (SQLException sQLException) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.30") + string2);
            }
            finally {
                if (var3_3 != null) {
                    var3_3.close();
                }
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close((Statement)preparedStatement, resultSet);
            throw throwable;
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    protected void processFilter(MigrationObjectFilter migrationObjectFilter, StringBuffer stringBuffer, HashSet<String> hashSet, String string) {
        if (migrationObjectFilter != null && !migrationObjectFilter.getObjectType().equals(string)) {
            throw new IllegalArgumentException(Sybase12Messages.getString("Sybase12AbstractCapturer.31") + migrationObjectFilter.getObjectType());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 2) {
            stringBuffer = stringBuffer.append(" ").append(migrationObjectFilter.getWhereClause());
        }
        if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1) {
            for (String string2 : migrationObjectFilter.getObjectNames()) {
                hashSet.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTables(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        HashSet<String> hashSet = new HashSet<String>();
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getCAPTURE_TABLES_QUERY());
        this.processFilter(migrationObjectFilter, stringBuffer, hashSet, "MD_TABLES");
        String string = (String)captureContext.getContextVariable("SCHEMA");
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                String string2;
                if (migrationObjectFilter != null && migrationObjectFilter.getFilterType() == 1 && !hashSet.contains(string2 = resultSet.getString(1))) continue;
                this.captureUDT(captureContext);
                QueryCapture.processTableRow((ResultSet)resultSet, (MigrationStorer)this.getStorer(), (CaptureContext)captureContext);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.34") + string);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureUDT(CaptureContext captureContext) {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CATALOGID");
        if (m_hSetDb.add(dBObjectId.getId())) {
            CloseableResultSet closeableResultSet = null;
            String string = this.getUSER_DEFINED_TYPES_QUERY();
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                try {
                    closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
                    ResultSet resultSet = closeableResultSet.getResultSet();
                    while (resultSet.next() && !captureContext.shouldCancel()) {
                        String string2 = resultSet.getString(1);
                        String string3 = this.convertFromN(resultSet.getString(2).trim(), captureContext);
                        Integer n = resultSet.getInt(3);
                        if (resultSet.wasNull()) {
                            n = null;
                        }
                        Integer n2 = resultSet.getInt(4);
                        if (resultSet.wasNull()) {
                            n2 = null;
                        }
                        Integer n3 = resultSet.getInt(5);
                        if (resultSet.wasNull()) {
                            n3 = null;
                        }
                        if (n == null || n == 0 && !this.m_online) {
                            n = n3;
                        }
                        String string4 = string3.toLowerCase();
                        Integer n4 = null;
                        Integer n5 = null;
                        if (string4.equals("numeric") || string4.equals("decimal")) {
                            n4 = n;
                            n5 = n2;
                        } else if (string4.equals("float")) {
                            n4 = n;
                        } else if (string4.equals("char") || string4.equals("varchar") || string4.equals("binary") || string4.equals("varbinary")) {
                            n4 = n3;
                        } else if ((string4.equals("nchar") || string4.equals("nvarchar")) && n3 != null) {
                            n4 = n3;
                        }
                        Object object = string3;
                        if (n4 != null) {
                            object = n5 != null ? string3 + "(" + n4.toString() + "," + n5.toString() + ")" : string3 + "(" + n4.toString() + ")";
                        }
                        ClobHelper clobHelper = new ClobHelper((String)object);
                        Long l = ((DBObjectId)captureContext.getContextVariable("CONNECTIONID")).getId();
                        Long l2 = m_connToMinSchema.get(l);
                        if (l2 == null) continue;
                        MdUserDefinedDataType mdUserDefinedDataType = new MdUserDefinedDataType(new DBObjectId(l2.longValue()), string2, (String)object, clobHelper);
                        mdUserDefinedDataType = (MdUserDefinedDataType)this.getStorer().storeObject((PersistableObject)mdUserDefinedDataType);
                    }
                }
                catch (PersistenceException persistenceException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                }
                finally {
                    if (closeableResultSet != null) {
                        closeableResultSet.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureColumns(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        String string = (String)captureContext.getContextVariable("TABLE");
        CloseableResultSet closeableResultSet = null;
        StringBuffer stringBuffer = new StringBuffer(this.getCAPTURE_COLUMNSDESCRIPTION_QUERY());
        int n = 0;
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next()) {
                this.ProcessColumnRow(resultSet, this.getStorer(), captureContext, ++n);
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.36") + string);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureIndexes(CaptureContext captureContext, MigrationObjectFilter migrationObjectFilter) throws SQLException, PersistenceException {
        CloseableResultSet closeableResultSet = null;
        String string = (String)captureContext.getContextVariable("TABLE");
        StringBuffer stringBuffer = new StringBuffer(this.getCAPTURE_INDEXESDESCRIPTION_QUERY());
        try {
            closeableResultSet = QueryCapture.issueSQL((String)stringBuffer.toString(), (Connection)this.m_sourceConnection, (CaptureContext)captureContext);
            ResultSet resultSet = closeableResultSet.getResultSet();
            while (resultSet.next() && !captureContext.shouldCancel()) {
                if (migrationObjectFilter == null || migrationObjectFilter.getFilterType() == 1) {
                    // empty if block
                }
                String string2 = null;
                String string3 = null;
                String string4 = null;
                if (this.Flag15 && this.m_online) {
                    string2 = resultSet.getString(1).trim();
                    string3 = resultSet.getString(2).trim();
                    string4 = resultSet.getString(3).trim();
                } else {
                    string2 = resultSet.getString(1).trim();
                    string4 = resultSet.getString(2).trim();
                    string3 = resultSet.getString(3).trim();
                }
                try {
                    this.ProcessIndexRow(string2, string4, string3, this.getStorer(), captureContext);
                }
                catch (Exception exception) {
                    Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_INDEXES", string);
                }
            }
        }
        catch (Exception exception) {
            if (closeableResultSet == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_INDEXES", string);
            } else {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.EXCEPTION", Sybase12Messages.getString("Sybase12AbstractCapturer.39") + string);
            }
        }
        finally {
            if (closeableResultSet != null) {
                closeableResultSet.close();
            }
        }
    }

    private void ProcessColumnRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext, int n) throws PersistenceException, SQLException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        String string = resultSet.getString(1);
        String string2 = resultSet.getString(2);
        int n2 = resultSet.getInt(3);
        int n3 = resultSet.getInt(4);
        int n4 = resultSet.getInt(5);
        int n5 = resultSet.getInt(6);
        int n6 = resultSet.getInt(7);
        int n7 = resultSet.getInt(8);
        int n8 = resultSet.getInt(9);
        Object object = null;
        object = (n5 & 0x80) == 128 ? new MdIdentityColumn(dBObjectId, string, Integer.valueOf(n), 1L, dBObjectId2) : new MdColumn(dBObjectId, string, Integer.valueOf(n));
        CaptureAudience captureAudience = captureContext.getAudience();
        object.setColumnType(string2);
        n3 = resultSet.getInt(4);
        if (resultSet.wasNull() && this.m_online || n3 == 0 && !this.m_online) {
            object.setPrecision(Integer.valueOf(n2));
        } else {
            object.setPrecision(Integer.valueOf(n3));
        }
        object.setScale(Integer.valueOf(n4));
        int n9 = n5;
        String string3 = "";
        string3 = (n9 & 8) == 8 ? "Y" : "N";
        object.setNullable(string3);
        if (n6 != 0) {
            this.setColumnDefault((MdColumn)object, n6);
        }
        if (n7 > 100) {
            this.setUserDefinedType((MdColumn)object, n7, n8);
        }
        object.setColumnType(this.convertFromN(object.getColumnType(), captureContext));
        CaptureEvent captureEvent = new CaptureEvent(3, "COLUMN", object.getColumnName());
        captureAudience.fireListeners(captureEvent);
        migrationStorer.storeObject((PersistableObject)object);
        captureEvent.setEventId(4);
        captureAudience.fireListeners(captureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void setColumnDefault(MdColumn mdColumn, int n) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block8: {
            preparedStatement = null;
            resultSet = null;
            try {
                String string;
                preparedStatement = this.getRepositoryConnection().prepareStatement(this.getCAPTURE_COLUMNDEFAULT_QUERY());
                preparedStatement.setInt(1, n);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block8;
                String string2 = resultSet.getString(1);
                if (string2.indexOf("\"") > 0) {
                    string = string2.substring(string2.indexOf("\"") + 1, string2.lastIndexOf("\""));
                } else if (string2.indexOf("'") > 0) {
                    string = string2.substring(string2.indexOf("'") + 1, string2.lastIndexOf("'"));
                } else {
                    String[] stringArray = string2.split(" ");
                    string = stringArray[stringArray.length - 1];
                }
                mdColumn.setDefaultValue(string.trim());
            }
            catch (SQLException sQLException) {
                CloseableResultSet.close((Statement)preparedStatement, resultSet);
                catch (Throwable throwable) {
                    CloseableResultSet.close(preparedStatement, resultSet);
                    throw throwable;
                }
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void setUserDefinedType(MdColumn mdColumn, int n, int n2) {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block4: {
            preparedStatement = null;
            resultSet = null;
            try {
                preparedStatement = this.getRepositoryConnection().prepareStatement(this.getCAPTURE_COLUMN_USER_TYPE());
                preparedStatement.setInt(1, n2);
                resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) break block4;
                mdColumn.setColumnType(resultSet.getString(1));
            }
            catch (SQLException sQLException) {
                CloseableResultSet.close((Statement)preparedStatement, resultSet);
                catch (Throwable throwable) {
                    CloseableResultSet.close(preparedStatement, resultSet);
                    throw throwable;
                }
            }
        }
        CloseableResultSet.close((Statement)preparedStatement, (ResultSet)resultSet);
    }

    private String convertFromN(String string, CaptureContext captureContext) {
        String[][] stringArrayArray;
        String string2 = string;
        for (String[] stringArray : stringArrayArray = new String[][]{{"intn", "int"}, {"floatn", "float"}, {"datetimn", "datetime"}, {"moneyn", "money"}, {"decimaln", "decimal"}, {"numericn", "numeric"}, {"daten", "date"}, {"timen", "time"}, {"uintn", "uint"}}) {
            if (string == null || !string.equalsIgnoreCase(stringArray[0])) continue;
            String string3 = (String)captureContext.getContextVariable("TABLE");
            if (string3 != null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.TYPE_RENAME", new String[]{stringArray[0], stringArray[1], (String)captureContext.getContextVariable("TABLE")});
            }
            string2 = stringArray[1];
            break;
        }
        return string2;
    }

    protected void ProcessCatalogRow(ResultSet resultSet, MigrationStorer migrationStorer, CaptureContext captureContext) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdCatalog mdCatalog = new MdCatalog(dBObjectId);
        String string = resultSet.getString(1);
        mdCatalog.setCatalogName(string);
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_CATALOGS"), string);
        captureContext.getAudience().fireListeners(captureEvent);
        migrationStorer.storeObject((PersistableObject)mdCatalog);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
    }

    protected void ProcessIndexRow(String string, String string2, String string3, MigrationStorer migrationStorer, CaptureContext captureContext) throws SQLException, PersistenceException {
        DBObjectId dBObjectId = (DBObjectId)captureContext.getContextVariable("TABLEID");
        MdIndexe mdIndexe = new MdIndexe(dBObjectId);
        String string4 = string.trim();
        if (this.findMatch(string2, " unique", true)) {
            mdIndexe.setIndexType("UNIQUE");
        } else {
            mdIndexe.setIndexType("NON_UNIQUE");
        }
        mdIndexe.setIndexName(string4);
        CaptureEvent captureEvent = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEXES"), string4);
        captureContext.getAudience().fireListeners(captureEvent);
        this.markForIndexClustered(dBObjectId, string2, mdIndexe, captureContext);
        mdIndexe = (MdIndexe)migrationStorer.storeObject((PersistableObject)mdIndexe);
        captureEvent.setEventId(4);
        captureContext.getAudience().fireListeners(captureEvent);
        String string5 = string3;
        string5 = string5.replaceAll("\\r\\n\\t ", "");
        string5 = string5.replaceAll("\\n\\t ", "");
        String[] stringArray = this.splitColumns(string5);
        for (int i = 0; i < stringArray.length; ++i) {
            String string6 = stringArray[i].trim();
            boolean bl = false;
            PersistenceUtility persistenceUtility = migrationStorer.getPersistenceUtility();
            if (string6.toLowerCase().matches("^.*\\s+desc$")) {
                bl = true;
                string6 = string6.substring(0, string6.toLowerCase().lastIndexOf("desc") - 1).trim();
            }
            DBObjectId dBObjectId2 = persistenceUtility.getIdForColumn(mdIndexe.getTableId(), string6);
            MdIndexDetail mdIndexDetail = new MdIndexDetail(mdIndexe.getKey(), dBObjectId2, Integer.valueOf(i + 1));
            if (bl) {
                mdIndexDetail.addProperty(new AdditionalProperty("IS_INDEXDETAIL_DESCENDING", "Y"), (DBObjectId)captureContext.getContextVariable("CONNECTIONID"));
            }
            CaptureEvent captureEvent2 = new CaptureEvent(3, MigrationAddinArb.getString((String)"MD_INDEX_DETAILS"), string4);
            captureContext.getAudience().fireListeners(captureEvent2);
            mdIndexDetail = (MdIndexDetail)migrationStorer.storeObject((PersistableObject)mdIndexDetail);
            captureEvent.setEventId(4);
            captureContext.getAudience().fireListeners(captureEvent);
        }
    }

    private String[] splitColumns(String string) {
        String[] stringArray = null;
        if (string.indexOf("\"") == -1 && string.indexOf(",") == -1) {
            string = string.trim();
            stringArray = string.split("\\s");
        } else {
            stringArray = string.split(",");
        }
        return stringArray;
    }

    protected boolean findMatch(String string, String string2, boolean bl) {
        Pattern pattern = bl ? Pattern.compile(string2) : Pattern.compile(string2, 2);
        Matcher matcher = pattern.matcher(string);
        return matcher.find();
    }

    void markForIndexOrganizedTable(DBObjectId dBObjectId, CaptureContext captureContext) throws PersistenceException {
        DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
        MdTable mdTable = MdTable.getExistingInstance((DBObjectId)dBObjectId);
        String string = mdTable.getProperty("IS_INDEX_ORGANIZED_TABLE");
        if (string == null) {
            mdTable.addProperty("IS_INDEX_ORGANIZED_TABLE", "Y", dBObjectId2);
            this.getStorer().storeObject((PersistableObject)mdTable);
        }
    }

    void markForIndexClustered(DBObjectId dBObjectId, String string, MdIndexe mdIndexe, CaptureContext captureContext) throws PersistenceException {
        if (this.findMatch(string, "clustered", false) && !this.findMatch(string, "nonclustered", false)) {
            this.markForIndexOrganizedTable(dBObjectId, captureContext);
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            String string2 = mdIndexe.getProperty("Y");
            if (string2 == null) {
                mdIndexe.addProperty("IS_CLUSTERED_INDEX", "Y", dBObjectId2);
            }
        }
    }

    void markForUniqueConstraintClustered(DBObjectId dBObjectId, String string, MdConstraint mdConstraint, CaptureContext captureContext) throws PersistenceException {
        if (this.findMatch(string, "clustered", false) && !this.findMatch(string, "nonclustered", false)) {
            this.markForIndexOrganizedTable(dBObjectId, captureContext);
            DBObjectId dBObjectId2 = (DBObjectId)captureContext.getContextVariable("CONNECTIONID");
            String string2 = mdConstraint.getProperty("IS_CLUSTERED_INDEX");
            if (string2 == null) {
                mdConstraint.addProperty("IS_CLUSTERED_INDEX", "Y", dBObjectId2);
            }
        }
    }

    static {
        m_hSetDb = new HashSet();
        m_connToMinSchema = new HashMap();
        DDL_NOT_ACCESSIBLE = Sybase12Messages.getString("Sybase12AbstractCapturer.1");
    }
}

