package org.jdesktop.animation.timing.triggers;

import javax.swing.ButtonModel;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.AbstractButton;
import org.jdesktop.animation.timing.TimingController;

public class ButtonStateTrigger extends Trigger
{

	private class ButtonStateListener extends TriggerListener implements ChangeListener
	{
		boolean armed;
		boolean rollover;
		ButtonStateEvent event;
		
		protected ButtonStateListener(final TimingController timer, final Trigger.TriggerAction action, final ButtonStateEvent event, final ButtonModel model) {
			super(timer, action);
			this.event = event;
			this.armed = model.isArmed();
			this.rollover = model.isRollover();
		}
		
		public void stateChanged(final ChangeEvent ae) {
			final ButtonModel model = (ButtonModel)ae.getSource();
			final boolean armedChange = this.armed != model.isArmed();
			final boolean rolloverChange = this.rollover != model.isRollover();
			if (armedChange) {
				if ((this.event == ButtonStateEvent.ARMED && model.isArmed()) || (this.event == ButtonStateEvent.DISARMED && !model.isArmed())) {
					this.pullTrigger();
				}
				this.armed = model.isArmed();
			}
			if (rolloverChange) {
				if ((this.event == ButtonStateEvent.ROLLOVER && model.isRollover()) || (this.event == ButtonStateEvent.ROLLOFF && !model.isRollover())) {
					this.pullTrigger();
				}
				this.rollover = model.isRollover();
			}
		}
	}

    public ButtonStateTrigger(final TimingController timer, final AbstractButton source, final Trigger.TriggerAction action, final ButtonStateEvent event) {
        this.setupListener(timer, source, action, (TriggerEvent)event);
    }
    
    public ButtonStateTrigger(final TimingController startTimer, final AbstractButton source, final ButtonStateEvent event, final TimingController stopTimer) {
        super(startTimer, source, (TriggerEvent)event, stopTimer);
    }
    
    @Override
    protected void setupListener(final TimingController timer, final Object source, final Trigger.TriggerAction action, final TriggerEvent event) {
        try {
            final ButtonModel model = ((AbstractButton)source).getModel();
            final ButtonStateTrigger.ButtonStateListener listener = new ButtonStateTrigger.ButtonStateListener(timer, action, (ButtonStateEvent)event, model);
            this.setupListener(model, (EventListener)listener, "addChangeListener", ChangeListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating change listener for object " + source + ": " + e);
        }
    }
}