package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;

class KeyValuesInt extends KeyValues<Integer>
{
    public KeyValuesInt(final int... values) {
        super(values);
        for (final int value : values) {
            this.values.add(value);
        }
    }
    
    @Override
    public Class<?> getType() {
        return Integer.TYPE;
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int i0, final int i1, final float fraction) {
        int value;
        if (i0 == i1) {
            value = (int)this.values.get(i0);
        }
        else {
            final int v0 = (int)this.values.get(i0);
            final int v2 = (int)this.values.get(i1);
            value = (int)(v0 + (v2 - v0) * fraction + 0.5f);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVInt.setValue:" + e);
        }
    }
    
    @Override
    public void setValue(final Object object, final Method method, final int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVInt.setValue:" + e);
        }
    }
}