"proc": 
[body) subprg_body &
[spec) subprg_spec &
spec^ = body &
([f) 'PROCEDURE' | [f) 'FUNCTION') &
f^ = spec &
[id) identifier & 
f+1=id 
;

/*
The cursor points either to procedure invocation, 
or is insight procedure body that user wants to inline
*/

-- Procedure name to display "no calls" message box
-- if no invocations is found
"proc@offset":
["proc".body <= :offset  & :offset < "proc".body) &
[ aux ) create_plsql  &  -- will aggregate (find the narrowest node) upon this auxiliary attribute
[aux <= "proc".body)  &  -- dummy dyadic predicate
[aux <= "proc".id)    &  -- need id
[aux <= "proc".f)        
;

-- Procedure invocation pointed by a cursor. 
-- (Might be empty)
"called proc": [stmt <= :offset  & :offset < stmt)  &
[stmt) stmt &
(call^ = stmt | call^^ = stmt) &
[call <= [stmt &  -- actually == (TODO: add == to arbori grammar) 
                  -- otherwise will catch unwanted block stmt, e.g. "declare begin proc; end;"
[call) name_wo_function_call &
?call = ?"proc".id &
aux = "proc".id    &
["proc".body <= "proc".body)  &  -- need body
["proc".f <= "proc".f)    
;

"proc def": "called proc" | [body spec id f aux];

"ambiguous proc": "proc def" | "proc@offset";

"the aux": /\aux("ambiguous proc"|[aux]);
"procedure": "the aux" & "ambiguous proc";
--"procedure": /\aux("ambiguous proc");


-- all calls of the procedure 
"all calls":   
[stmt) stmt &
(call^ = stmt | call^^ = stmt) &
[call <= [stmt &  
[call) name_wo_function_call &
?call = ?"procedure".id &
["procedure".body <= "procedure".body)  &  -- need body
["procedure".f <= "procedure".f)    
;


"all calls+fml":
    "all calls".id+1=fml_part &
    [fml_part) fml_part &
    "all calls".call+1=paren_expr_list &
    [paren_expr_list) paren_expr_list 
;
  

"prm decl":
  "all calls+fml".fml_part <= prm_spec &
  [prm_spec) prm_spec
;

"prm val":
  "all calls+fml".paren_expr_list <= arg &
  [arg) arg
;

