/*
 * Copyright (c) 2014, 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.javafx.embed.swing;

import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.dnd.InvalidDnDOperationException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.embed.swing.SwingNode;

/**
 * A utility class to connect DnD mechanism of Swing and FX.
 * It allows Swing content to use the FX machinery for performing DnD.
 */
final public class FXDnD {
    private static SwingNode node;
    public static boolean fxAppThreadIsDispatchThread;
    private SwingNode getNode() { return node; }
    private static FXDnDInterop fxdndiop;

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>() {
            public Object run() {
                fxAppThreadIsDispatchThread =
                        "true".equals(System.getProperty("javafx.embed.singleThread"));
                return null;
            }
        });

    InteropFactory instance = null;
    try {
        instance = InteropFactory.getInstance();
    } catch (Exception e) {
            throw new ExceptionInInitializerError(e);
    }
        fxdndiop = instance.createFXDnDImpl();
    }

    public FXDnD(SwingNode node) {
        this.node = node;
    fxdndiop.setNode(node);
    }

    public Object createDragSourceContext(DragGestureEvent dge)
            throws InvalidDnDOperationException {
        return fxdndiop.createDragSourceContext(dge);
    }

    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(
            Class<T> abstractRecognizerClass,
            DragSource ds, Component c, int srcActions,
            DragGestureListener dgl)
    {
        return fxdndiop.createDragGestureRecognizer(ds, c, srcActions, dgl);
    }

    public void addDropTarget(DropTarget dt) {
    fxdndiop.addDropTarget(dt, node);
    }

    public void removeDropTarget(DropTarget dt) {
        fxdndiop.removeDropTarget(dt, node);
    }
}
