/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.javafx.embed.swing.oldimpl;

import com.sun.javafx.embed.swing.JFXPanelInterop;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import javafx.embed.swing.JFXPanel;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class JFXPanelInteropO extends JFXPanelInterop {
    public void postEvent(JFXPanel panel, AWTEvent e) {
        AppContext context = SunToolkit.targetToAppContext(panel);
        if (context != null) {
            SunToolkit.postEvent(context, e);
        }
    }

    public boolean isUngrabEvent(AWTEvent event) {
        return event instanceof sun.awt.UngrabEvent;
    }

    public long getMask() {
        return SunToolkit.GRAB_EVENT_MASK | AWTEvent.MOUSE_EVENT_MASK;
    }

    public void grab(Toolkit toolkit, Window w) {
        if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).grab(w);
        }
    }

    public void ungrab(Toolkit toolkit, Window w) {
        if (toolkit instanceof SunToolkit) {
            ((SunToolkit)toolkit).ungrab(w);
        }
    }
}
