<?xml version="1.0"?>
<!--
NAME
    kusseqd.xsl
DESCRIPTION
    Convert SEQUENCE document (SXML) to creation DDL.

MODIFIED        MM/DD/YY
    sdavidso    11/02/05 - fix inconsistent stylesheet format 
    lbarton    08/10/05 - lbarton_mddiff
    htseng     03/23/05 - Initial version
 -->
<xsl:stylesheet version="1.0" xmlns:sxml="http://xmlns.oracle.com/ku" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Top level imports -->
 <xsl:import href="kuscommd.xsl"/>
 <!-- Top-level parameters -->
 <!-- Parameters for DDL generation -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <!-- *******************************************************************
Template: SEQUENCE  - top-level template for tables.
  This template puts out
   - CREATE SEQUENCE name
******************************************************************** -->
 <xsl:template match="sxml:SEQUENCE">
  <xsl:text> CREATE SEQUENCE </xsl:text>
  <xsl:call-template name="SchemaName">
   <xsl:with-param name="ParentNode" select="."/>
  </xsl:call-template>
  <xsl:if test="sxml:MINVALUE">
   <xsl:text> MINVALUE </xsl:text>
   <xsl:value-of select="sxml:MINVALUE"/>
  </xsl:if>
  <xsl:if test="sxml:MAXVALUE">
   <xsl:text> MAXVALUE </xsl:text>
   <xsl:value-of select="sxml:MAXVALUE"/>
  </xsl:if>
  <xsl:if test="sxml:INCREMENT">
   <xsl:text> INCREMENT BY </xsl:text>
   <xsl:value-of select="sxml:INCREMENT"/>
  </xsl:if>
  <xsl:if test="sxml:START_WITH">
   <xsl:text> START WITH </xsl:text>
   <xsl:value-of select="sxml:START_WITH"/>
  </xsl:if>
  <xsl:if test="sxml:CACHE">
   <xsl:choose>
    <xsl:when test="sxml:CACHE=0">
     <xsl:text> NOCACHE</xsl:text>
    </xsl:when>
    <xsl:otherwise>
     <xsl:text> CACHE </xsl:text>
     <xsl:value-of select="sxml:CACHE"/>
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:choose>
   <xsl:when test="sxml:ORDER">
    <xsl:text> ORDER</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> NOORDER</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:choose>
   <xsl:when test="sxml:CYCLE">
    <xsl:text> CYCLE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> NOCYCLE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
   <!-- Terminate the SQL statement -->
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
