<?xml version="1.0"?>
<!-- 
NAME
    kurescos.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_resocost_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayn      11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	05/30/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:template match="RESOCOST_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">RESOURCE_COST</xsl:with-param>
  </xsl:call-template>
  <xsl:text> ALTER RESOURCE COST </xsl:text>
  <xsl:apply-templates select="COST_LIST"/>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="COST_LIST">
  <xsl:for-each select="COST_LIST_ITEM">
   <xsl:if test="RESOURCE_TYPE=0 and (RESOURCE_ID=2 or RESOURCE_ID=4
                    or RESOURCE_ID=7 or RESOURCE_ID=8)">
    <xsl:value-of select="RESOURCE_NAME"/>
    <xsl:text> </xsl:text>
    <xsl:value-of select="UNIT_COST"/>
    <xsl:text> </xsl:text>
    <xsl:if test="$PRETTY=1 and not(position()=last())">
     <xsl:text>&#xa; </xsl:text>
    </xsl:if>
   </xsl:if>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
