<?xml version="1.0"?>
<!-- 
NAME
    kufgapolicy.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_fga_policy_t UDTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

NOTE:
        Syntax for dbms_fga.add_policy

        dbms_fga.add_policy(
                object_schema,
                object_name,
                policy_name,
                audit_condition,
                audit_column,
                handler_schema
	        handler_module,
                enable(true/false),
                statement_type,
                audit_trail,
                audit_column_opts,
                policy_owner)

MODIFIED        MM/DD/YY
    ssonawan    10/22/08 - lrg 3649713: use powner only for EXPORT case
    ssonawan    09/10/08 - bug 5921164: use powner input parameter
    lbarton     11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng      04/14/05 - fix bug4304516 -
			   correct handler_schema and handler_module 
    rvissapr    09/10/03 - bug 3095609 - add all_columns 
    nmanappa    09/03/03 - Adding audit trail to add_policy 
    rvissapr    09/24/02 - 
    rvissapr    09/18/02 - FGA dML exp
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    dgagne      08/22/01 - Merged dgagne_add_xsl_stylesheets
    dgagne      05/09/01 - Created
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="SQLTERMINATOR">0</xsl:param>
 <xsl:param name="EXPORT">0</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="FGA_POLICY_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_FGA.ADD_POLICY</xsl:with-param>
   <xsl:with-param name="ObjectType">FGA_POLICY</xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text>BEGIN DBMS_FGA.ADD_POLICY('</xsl:text>
  <xsl:value-of select="BASE_OBJ/OWNER_NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="BASE_OBJ/NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="NAME"/>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="PTXT"/>
  <xsl:text>','</xsl:text>
  <!-- list of relevant cols, ok to have empty str:
       will have something like '' (empty list) or '"COL1","COL2"'
  -->
  <xsl:for-each select="PCOL/PCOL_ITEM">
   <xsl:text>"</xsl:text>
   <xsl:value-of select="AUDIT_COLUMN"/>
   <xsl:text>"</xsl:text>
   <xsl:if test="not(position()=last())">
    <xsl:text>,</xsl:text>
   </xsl:if>
  </xsl:for-each>
  <xsl:text>','</xsl:text>
  <xsl:value-of select="PFSCHEMA"/>
  <xsl:text>','</xsl:text>
  <xsl:if test="PPNAME">
   <xsl:value-of select="PPNAME"/>
   <xsl:text>.</xsl:text>
  </xsl:if>
  <xsl:value-of select="PFNAME"/>
  <xsl:choose>
   <xsl:when test="ENABLE_FLAG = 1">
    <xsl:text>',TRUE</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>',FALSE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>,'</xsl:text>
  <!--
      The stmt_type uses 4 bits, values 8, 4, 2, and 1.  These represent
      DELETE, UPDATE, INSERT AND SELECT.  A comma is needed between any that
      are present.  Only the 4 low bits are returned in stmt_type.
   -->
  <!-- If bit 8 is set, then add 'DELETE' -->
  <xsl:if test="STMT_TYPE >= 8">
   <xsl:text>DELETE</xsl:text>
  </xsl:if>
  <!-- If bit 4 is set, first check to see if bit 8 was set. If bit 8 was also
       set, then 'DELETE' is already there, add in a comma first
  -->
  <xsl:if test="(STMT_TYPE mod 8)>=4">
   <!-- need to add in UPDATE? -->
   <xsl:if test="STMT_TYPE >=8">
    <!-- need comma? -->
    <xsl:text>,</xsl:text>
   </xsl:if>
   <xsl:text>UPDATE</xsl:text>
  </xsl:if>
  <!-- If bit 2 is set, first check to see if bit 8 or 4 was set. If either
       bit 8 or 4 was set, then a keyword is there with no trailing comma, add
       in a comma first.
  -->
  <xsl:if test="(STMT_TYPE mod 4)>=2">
   <!-- need to add in INSERT? -->
   <xsl:if test="STMT_TYPE >=4">
    <!-- bit 8 or bit 4 set -->
    <xsl:text>,</xsl:text>
   </xsl:if>
   <xsl:text>INSERT</xsl:text>
  </xsl:if>
  <!-- If bit 1 is set, first check to see if bit 8, 4, or 2 was set. If either
       bit 8, 4, or 2 was set, then a keyword is there with no trailing comma,
       add in a comma first.
  -->
  <xsl:if test="(STMT_TYPE mod 2)=1">
   <!-- need to add in SELECT? -->
   <xsl:if test="STMT_TYPE >=2">
    <!-- bit 8 or bit 4 set -->
    <xsl:text>,</xsl:text>
   </xsl:if>
   <xsl:text>SELECT</xsl:text>
  </xsl:if>
  <xsl:text>',</xsl:text>
  <!-- bit 7 set to 1 indicates DB (AUDIT_TRAIL having value 64)
       and set to 0 indicates DB_EXTENDED
   -->
  <xsl:choose>
   <xsl:when test="AUDIT_TRAIL = 0">
    <xsl:text>DBMS_FGA.DB_EXTENDED</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>DBMS_FGA.DB</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>,</xsl:text>
  <xsl:choose>
   <xsl:when test="PCOL_OPT = 128">
    <xsl:text>DBMS_FGA.ALL_COLUMNS</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>DBMS_FGA.ANY_COLUMNS</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <!-- For export case use the policy owner -->
  <xsl:choose>
   <xsl:when test="$EXPORT=1">
    <xsl:text>,'</xsl:text>
    <xsl:value-of select="POWNER"/>
    <xsl:text>'</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text>,NULL</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:text>)</xsl:text>
  <xsl:text>; END;</xsl:text>
  <!-- Terminate inner SQL statement -->
  <xsl:call-template name="DoTerminator">
   <xsl:with-param name="Text"/>
  </xsl:call-template>
 </xsl:template>
</xsl:stylesheet>
