<?xml version="1.0"?>
<!-- 
NAME
    kudefrol.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_defrole_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    tbhukya     03/13/09 - Bug 8307871
    lbarton	11/02/05 - Bug 4715313: reformat files for use with XMLSpy 
    htseng	08/02/02 - add grantee parse param
    htseng	07/26/02 - add more parse params
    htseng	09/19/01 - Merged htseng_add_xsl_stylesheets
    htseng	05/24/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="DEFROLE_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">ALTER</xsl:with-param>
   <xsl:with-param name="ObjectType">DEFAULT_ROLE</xsl:with-param>
   <xsl:with-param name="Grantee" select="USER_NAME"/>
  </xsl:call-template>
  <xsl:text> ALTER USER </xsl:text>
  <xsl:call-template name="QuoteObject">
   <xsl:with-param name="Object" select="USER_NAME"/>
  </xsl:call-template>
  <xsl:choose>
   <xsl:when test="DEFROLE= 0">
    <xsl:text> DEFAULT ROLE NONE</xsl:text>
   </xsl:when>
   <xsl:when test="DEFROLE= 1">
    <xsl:text> DEFAULT ROLE ALL</xsl:text>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> DEFAULT ROLE </xsl:text>
    <xsl:if test="DEFROLE=3">
     <xsl:text> ALL EXCEPT </xsl:text>
    </xsl:if>
    <xsl:apply-templates select="ROLE_LIST"/>
   </xsl:otherwise>
  </xsl:choose>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
 <xsl:template match="ROLE_LIST">
  <xsl:choose>
   <xsl:when test="ROLE_LIST_ITEM">
    <xsl:for-each select="ROLE_LIST_ITEM">
     <xsl:call-template name="QuoteObject">
      <xsl:with-param name="Object" select="ROLE"/>
     </xsl:call-template>
     <xsl:if test="not(position()=last())">
      <xsl:text>, </xsl:text>
     </xsl:if>
    </xsl:for-each>
   </xsl:when>
   <xsl:otherwise>
    <xsl:text> NONE</xsl:text>
   </xsl:otherwise>
  </xsl:choose>
 </xsl:template>
</xsl:stylesheet>
