<?xml version="1.0" ?>
<!-- 
NAME
    knredef1.xsl - Online Redefinition Transformation script #1

DESCRIPTION
    XSLT stylesheet used for cloning the dependent objects on one table
    to another table. This stylesheet transforms the DDL of the indexes,
    triggers, constraints and object grants by replacing the old schema 
    object and the base table with the corresponding new schema object 
    and base table information. Also for referential constraints, the
    transform disables the constraints. The transformation also marks 
    the constraint to be one with non-system generated names.

NOTES
    Do NOT modify this file under any circumstance. If you wish to use this
    stylesheet with an external XML/XSL parser, first make a copy then reverse
    the comments on any xsl:import statements appearing below.

MODIFIED	MM/DD/YY
    wesmith   05/17/06 - map dependent trigger owner/name
    wesmith   04/17/06 - support cloning of MV logs
    xan       12/17/04 - preserve system-generated bit for supplemental logs
    xan       05/06/04 - add table stats, index stats and notnull cons
    masubram  10/15/02 - merge of masubram_online_redef_clone
    masubram  10/11/02 - Created.
 -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- specify the parameters used in this script -->
 <xsl:param name="SCHEMA_OBJ_OWNER_OLD" select="''"/>
 <xsl:param name="SCHEMA_OBJ_OWNER_NEW" select="''"/>
 <xsl:param name="SCHEMA_OBJ_NAME_OLD" select="''"/>
 <xsl:param name="SCHEMA_OBJ_NAME_NEW" select="''"/>
 <xsl:param name="BASE_OBJ_OWNER_OLD" select="''"/>
 <xsl:param name="BASE_OBJ_OWNER_NEW" select="''"/>
 <xsl:param name="BASE_OBJ_NAME_OLD" select="''"/>
 <xsl:param name="BASE_OBJ_NAME_NEW" select="''"/>
 <xsl:param name="DEP_TRIG_OWNER_OLD" select="''"/>
 <xsl:param name="DEP_TRIG_OWNER_NEW" select="''"/>
 <xsl:param name="DEP_TRIG_NAME_OLD" select="''"/>
 <xsl:param name="DEP_TRIG_NAME_NEW" select="''"/>

<!-- copy everything from the input file -->
<xsl:template match="@*|node()">
 <xsl:copy>
  <xsl:apply-templates select="@*|node()"/>
 </xsl:copy>
</xsl:template>

<!-- replace the trigger owner if we have a match -->
<xsl:template match="TRIGGER_T/SCHEMA_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_OWNER_OLD and ../NAME=$SCHEMA_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$SCHEMA_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the trigger name if we have a match -->
<xsl:template match="TRIGGER_T/SCHEMA_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the ref constraint owner if we have a match -->
<xsl:template match="REF_CONSTRAINT_T/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_OWNER_OLD and ../NAME=$SCHEMA_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$SCHEMA_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the ref constraint name if we have a match -->
<xsl:template match="REF_CONSTRAINT_T/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the ref constraint name if we have a match -->
<xsl:template match="REF_CONSTRAINT_T/CON2/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the constraint owner if we have a match -->
<xsl:template match="CONSTRAINT_T/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_OWNER_OLD and ../NAME=$SCHEMA_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$SCHEMA_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the constraint name if we have a match -->
<xsl:template match="CONSTRAINT_T/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the constraint name if we have a match -->
<xsl:template match="CONSTRAINT_T/CON1/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the not-null constraint name if we have a match -->
<xsl:template match="CONSTRAINT_T/CON0/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the index owner if we have a match -->
<xsl:template match="INDEX_T/SCHEMA_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_OWNER_OLD and ../NAME=$SCHEMA_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$SCHEMA_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the index name if we have a match -->
<xsl:template match="INDEX_T/SCHEMA_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the trigger base table owner if we have a match -->
<xsl:template match="TRIGGER_T/BASE_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the trigger base table name if we have match -->
<xsl:template match="TRIGGER_T/BASE_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the trigger's dependent trigger owner if we have match -->
<xsl:template match="TRIGGER_T/TRIGDEPS/TRIGDEPS_ITEM/P_TRGOWNER">
 <xsl:choose>
   <xsl:when test=".=$DEP_TRIG_OWNER_OLD and ../P_TRGNAME=$DEP_TRIG_NAME_OLD">
<P_TRGOWNER>
<xsl:value-of select="$DEP_TRIG_OWNER_NEW"/>
</P_TRGOWNER>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the trigger's dependent trigger name if we have match -->
<xsl:template match="TRIGGER_T/TRIGDEPS/TRIGDEPS_ITEM/P_TRGNAME">
 <xsl:choose>
   <xsl:when test=".=$DEP_TRIG_NAME_OLD and ../P_TRGOWNER=$DEP_TRIG_OWNER_OLD">
<P_TRGNAME>
<xsl:value-of select="$DEP_TRIG_NAME_NEW"/>
</P_TRGNAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the ref_constraint base table owner if we have a match -->
<xsl:template match="REF_CONSTRAINT_T/BASE_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the ref constraint base table name if we have a match -->
<xsl:template match="REF_CONSTRAINT_T/BASE_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the ref_constraint parent table owner if we have a match -->
<xsl:template match="REF_CONSTRAINT_T/CON2/SCHEMA_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the ref constraint parent table name if we have a match -->
<xsl:template match="REF_CONSTRAINT_T/CON2/SCHEMA_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the constraint base table owner if we have a match -->
<xsl:template match="CONSTRAINT_T/BASE_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the constraint base table name if we have match -->
<xsl:template match="CONSTRAINT_T/BASE_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the index base table owner if we have a match -->
<xsl:template match="INDEX_T/BASE_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the index base table name if we have match -->
<xsl:template match="INDEX_T/BASE_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>


<!-- replace the object grant base table owner if we have a match -->
<xsl:template match="OBJGRANT_T/BASE_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the object grant base table name if we have match -->
<xsl:template match="OBJGRANT_T/BASE_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>


<!-- disable the transformed ref constraint -->
<xsl:template match="REF_CONSTRAINT_T/CON2/ENABLED">
 <xsl:choose>
   <xsl:when test=".=1">
<ENABLED>0</ENABLED>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- remove the system generated/validated bits (8 & 4) -->
<xsl:template match="REF_CONSTRAINT_T/CON2/FLAGS">
 <xsl:choose>
   <xsl:when test="((floor((. - (. mod 4)) div 4)) mod 4) > 0">
<FLAGS>
<xsl:value-of select="(. - (((floor((. - (. mod 4)) div 4)) mod 4) * 4))"/>
</FLAGS>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- remove the system generated/validated bits (8 & 4) except for PK, UNIQUE,
     FOREIGN KEY and ALL COLUMN LOGGING supplemental logs. -->
<xsl:template match="CONSTRAINT_T/CON1/FLAGS">
 <xsl:choose>
   <xsl:when test="((floor((. - (. mod 4)) div 4)) mod 4) > 0 and 
                   (number(../CONTYPE) != 14 and 
                   number(../CONTYPE) != 15 and 
                   number(../CONTYPE) != 16 and 
                   number(../CONTYPE) != 17 )">
<FLAGS>
<xsl:value-of select="(. - (((floor((. - (. mod 4)) div 4)) mod 4) * 4))"/>
</FLAGS>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- remove the system generated/validated bits (8 & 4) -->
<xsl:template match="CONSTRAINT_T/CON0/FLAGS">
 <xsl:choose>
   <xsl:when test="((floor((. - (. mod 4)) div 4)) mod 4) > 0">
<FLAGS>
<xsl:value-of select="(. - (((floor((. - (. mod 4)) div 4)) mod 4) * 4))"/>
</FLAGS>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the base object owner of table statistics if we have a match -->
<xsl:template match="T_STAT_T/BASE_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the base table name of table statistics if we have a match -->
<xsl:template match="T_STAT_T/BASE_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the table name of table statistics if we have a match -->
<xsl:template match="T_STAT_T/TAB_INFO/TABNAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../../BASE_OBJ/OWNER_NAME=$BASE_OBJ_OWNER_OLD and ../../BASE_OBJ/NAME=$BASE_OBJ_NAME_OLD">
<TABNAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</TABNAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the nested table name of table statistics if we have a match -->
<xsl:template match="T_STAT_T/NESTED_TAB_NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../BASE_OBJ/OWNER_NAME=$BASE_OBJ_OWNER_OLD and ../BASE_OBJ/NAME=$BASE_OBJ_NAME_OLD">
<NESTED_TAB_NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NESTED_TAB_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>


<!-- replace the base table owner of index statistics if we have a match -->
<xsl:template match="I_STAT_T/BASE_TAB_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../NAME=$BASE_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the base table name of index statistics if we have a match -->
<xsl:template match="I_STAT_T/BASE_TAB_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../OWNER_NAME=$BASE_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the index owner of index statistics if we have a match -->
<xsl:template match="I_STAT_T/BASE_IND_OBJ/OWNER_NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_OWNER_OLD and ../NAME=$SCHEMA_OBJ_NAME_OLD">
<OWNER_NAME>
<xsl:value-of select="$SCHEMA_OBJ_OWNER_NEW"/>
</OWNER_NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the index name of index statistics if we have a match -->
<xsl:template match="I_STAT_T/BASE_IND_OBJ/NAME">
 <xsl:choose>
   <xsl:when test=".=$SCHEMA_OBJ_NAME_OLD and ../OWNER_NAME=$SCHEMA_OBJ_OWNER_OLD">
<NAME>
<xsl:value-of select="$SCHEMA_OBJ_NAME_NEW"/>
</NAME>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- remove the CNST_COL_LIST block of index statistics if we have a match -->
<xsl:template match="I_STAT_T/CNST_COL_LIST">
<CNST_COL_LIST/>
</xsl:template>

<!-- replace the MV log base table owner if we have a match -->
<xsl:template match="M_VIEW_LOG_T/MVIEWLOG/MOWNER">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_OWNER_OLD and ../MASTER=$BASE_OBJ_NAME_OLD">
<MOWNER>
<xsl:value-of select="$BASE_OBJ_OWNER_NEW"/>
</MOWNER>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<!-- replace the MV log base table name if we have match -->
<xsl:template match="M_VIEW_LOG_T/MVIEWLOG/MASTER">
 <xsl:choose>
   <xsl:when test=".=$BASE_OBJ_NAME_OLD and ../MOWNER=$BASE_OBJ_OWNER_OLD">
<MASTER>
<xsl:value-of select="$BASE_OBJ_NAME_NEW"/>
</MASTER>
   </xsl:when>
    <xsl:otherwise>
      <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
     </xsl:otherwise>
 </xsl:choose>
</xsl:template>

</xsl:stylesheet>
