Rem
Rem Copyright (c) 2011, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      sybase_tsql.sql - Sybase TSQL translator
Rem
Rem    DESCRIPTION
Rem      This script contains the SYBASE_TSQL_TRANSLATOR package
Rem
Rem    INSTALLATION
Rem      > loadjava -user migration_repo/*** -genmissing -definer -resolver '((* MIGRATION_REPO)(* PUBLIC)(* -))' babelfish_sybase-?.?.?.?.jar
Rem      > sqlplus migration_repo/***
Rem      SQL> @sybase_tsql.sql
Rem      SQL> grant execute on sybase_tsql_translator to <target-user>;
Rem      > sqlplus system/***
Rem      SQL> exec dbms_java.grant_permission('MIGRATION_REPO', 'SYS:java.lang.RuntimePermission', 'getClassLoader', '')
Rem     
Rem    NOTES
Rem      None 
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpang       11/28/11 - Update for migration repository integration
Rem    rpang       11/10/11 - Updated
Rem    rpang       06/30/11 - Created
Rem

create or replace package sybase_tsql_translator as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob);

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2);

end;
/

create or replace package body sybase_tsql_translator as

  procedure translate_sql(sql_text              in  clob,
                          translated_text       out clob) as
  language java
  name 'oracle.dbtools.babelfish.sybase.SybaseTSQLTranslator.translateSQL(oracle.sql.CLOB,oracle.sql.CLOB[])';

  procedure translate_error(error_code          in  binary_integer,
                            translated_code     out binary_integer,
                            translated_sqlstate out varchar2) as
  language java
  name 'oracle.dbtools.babelfish.sybase.SybaseTSQLTranslator.translateError(int,int[],java.lang.String[])';

end;
/