/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.plusplus.IBuffer;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.scriptrunner.cmdline.editor.Buffer;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LbCommand;
import oracle.dbtools.util.Logger;

public class QueryUtils {
    public static final String COLLATION_CLAUSE = "COLLATION_CLAUSE";
    static final String SET_BOOL_DDL = "declare \n FUNCTION ifelse (bool_in IN varchar2) \n   RETURN boolean \n IS \n BEGIN \n   IF bool_in = 'OFF' \n   THEN \n     RETURN false; \n  ELSE \n     RETURN true; \n  END IF;\n  END; \n begin \n dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,ifelse(:VALUE)); \n end;\n";
    static final String SET_STRING_DDL = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,:VALUE); end;";
    static QueryXMLSupport s_xml;
    private static Boolean p_scan;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExist(Connection conn, String oName, String oType, String oOwner) {
        String objectExistsQuery = QueryUtils.getXMLQueries().getQuery("objectExistsQuery", conn).getSql();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int count = 0;
            stmt = conn.prepareStatement(objectExistsQuery);
            stmt.setString(1, oName);
            stmt.setString(2, SchemaGenerator.typeNameTransform.getOrDefault(oType, oType));
            stmt.setString(3, oOwner);
            rs = stmt.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
            boolean bl = 0 < count;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized QueryXMLSupport getXMLQueries() {
        if (null == s_xml) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(LbCommand.class.getClassLoader(), "oracle/dbtools/raptor/scriptrunner/commands/liquibase/cmQueries.xml"));
        }
        return s_xml;
    }

    public static String getSchedulerObjectType(String name, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OBJECT_NAME", name);
        return dbUtil.executeReturnOneCol("select object_type from all_objects where object_name = :OBJECT_NAME and rownum = 1", binds);
    }

    public static String getUser(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        HashMap binds = new HashMap();
        return dbUtil.executeReturnOneCol("select user from dual", binds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXmlFromActionsLog(Connection conn, AbstractOracleStatement statement, Database database) throws SQLException, IOException {
        try {
            DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
            HashMap<String, String> binds = new HashMap<String, String>();
            binds.put("OWNER", LbUtils.getLiquibaseSchema(database));
            String exists = dbUtil.executeReturnOneCol("select count(*) from all_tables where table_name = " + database.getDatabaseChangeLogTableName() + "_actionsand OWNER = :OWNER", binds);
            if ("0".equals(exists)) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        String actionLogSxmlQuery = QueryUtils.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql().replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        stmt = conn.prepareStatement(actionLogSxmlQuery);
        stmt.setString(1, statement.getId());
        stmt.setString(2, statement.getAuthor());
        stmt.setString(3, statement.getFile());
        rs = stmt.executeQuery();
        while (rs.next()) {
            Clob sxml = rs.getClob(1);
            if (null == sxml) {
                String string = null;
                return string;
            }
            sb.append(LiquibaseStringUtils.clobToString(sxml));
        }
        String string = sb.toString();
        return string;
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != stmt) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String runSqlReturnResult(String sql, Connection conn, boolean scan) throws DatabaseException {
        return QueryUtils.runSqlReturnResult(sql, conn, scan, null);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public static String runSqlReturnResult(String sql, Connection conn, boolean scan, AbstractOracleStatement stmt) throws DatabaseException {
        try {
            useSqlcl = LbUtils.getParameter("ENGINE") != null && LbUtils.getParameter("ENGINE").equalsIgnoreCase("SQLCL") != false;
        }
        catch (IOException e) {
            useSqlcl = false;
        }
        BaS = new ByteArrayOutputStream();
        if (sql == null || sql.isEmpty()) {
            return "No SQL to execute";
        }
        try {
            var6_7 = BaS;
            try {
                block40: {
                    block42: {
                        block41: {
                            block39: {
                                block38: {
                                    BoS = new BufferedOutputStream(BaS);
                                    try {
                                        encoding = ScriptRunnerContext.getOutputEncoding();
                                        runner = new ScriptExecutor(sql, conn);
                                        sscan = "ON".equals(LbUtils.getParameter("SCAN"));
                                        rctx = QueryUtils.getScriptRunnerContext(useSqlcl ? (QueryUtils.p_scan == null ? sscan : QueryUtils.p_scan) : scan);
                                        rctx.setBaseConnection(conn);
                                        rctx.setCurrentConnection(conn);
                                        if (sql.endsWith("/")) {
                                            rctx.putProperty("script.runner.isslashstatement", (Object)"true");
                                        }
                                        runner.setScriptRunnerContext(rctx);
                                        runner.setOut(BoS);
                                        runner.run();
                                        if (useSqlcl) {
                                            QueryUtils.p_scan = rctx.getScanOn();
                                        }
                                        BoS.flush();
                                        error = (Boolean)rctx.getProperty("sqldev.error");
                                        errorType = (String)rctx.getProperty("sqldev.last.err.type");
                                        errorCode = (Integer)rctx.getProperty("sqldev.last.err.sqlcode");
                                        if (!error.booleanValue()) ** GOTO lbl65
                                        if (955 == errorCode) {
                                            throw new DatabaseException("Name is already used by an existing object\n");
                                        }
                                        if (2275 != errorCode) break block38;
                                        var15_22 = "Such a referential constraint already exists in the table\n";
                                    }
                                    catch (Throwable var8_13) {
                                        try {
                                            BoS.close();
                                        }
                                        catch (Throwable var9_16) {
                                            var8_13.addSuppressed(var9_16);
                                        }
                                        throw var8_13;
                                    }
                                    BoS.close();
                                    return var15_22;
                                }
                                if (2443 != errorCode) break block39;
                                var15_23 = "Alter table drop constraint, constraint not found\n";
                                BoS.close();
                                return var15_23;
                            }
                            if (2429 == errorCode) {
                                throw new DatabaseException("Attempted to drop an index that is being used as the enforcement mechanism for unique or primary key.\n");
                            }
                            if (942 == errorCode) {
                                throw new DatabaseException("The specified table or view did not exist\n");
                            }
                            if (4080 == errorCode) {
                                throw new DatabaseException("The TRIGGER name is invalid\n");
                            }
                            if (!BaS.toString().isEmpty()) {
                                throw new DatabaseException(BaS.toString().trim());
                            }
                            throw new DatabaseException((String)runner.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode"));
lbl65:
                            // 1 sources

                            if (errorType != null) {
                                if (("PACKAGE".equals(errorType) || "TYPE".equals(errorType) || "TYPE BODY".equals(errorType)) && BaS.toString().contains("PLS-00201:")) {
                                    throw new DatabaseException("You tried to reference either an undeclared variable, exception, procedure, or other\nitem, or an item to which no privilege was granted or an item to which privilege was\ngranted only through a role.\n");
                                }
                                if ("TYPE".equals(errorType) && BaS.toString().contains("PLS-00905:")) {
                                    throw new DatabaseException("An invalid package specification or stored subprogram was referenced. A package\nspecification or stored subprogram is invalid if its source code or any database object\nit references has been DROPped, REPLACEd, or ALTERed since it was last compiled.\n");
                                }
                            }
                            if (BaS.toString().trim().equals("Substitution cancelled")) {
                                throw new DatabaseException((Throwable)new SQLException("Substitution cancelled. Issue SET SCAN OFF and load changelog again.\n"));
                            }
                            result = BaS.toString(encoding);
                            if (!result.isEmpty()) break block40;
                            if (!sql.equals("-- object is the same nothing to do")) break block41;
                            var16_25 = sql;
                            BoS.close();
                            return var16_25;
                        }
                        if (!LbUtils.isDebug()) break block42;
                        var16_26 = "Executed :" + sql + System.lineSeparator() + "Returned no results!!" + System.lineSeparator();
                        BoS.close();
                        return var16_26;
                    }
                    var16_27 = "";
                    BoS.close();
                    return var16_27;
                }
                var16_28 = result;
                BoS.close();
                return var16_28;
            }
            finally {
                if (var6_7 != null) {
                    var6_7.close();
                }
            }
        }
        catch (IOException e) {
            LbUtils.log(QueryUtils.class, e);
            throw new DatabaseException(LbUtils.getRoot(e).getMessage());
        }
        catch (LiquibaseException e) {
            throw new DatabaseException(LbUtils.getRoot(e).getMessage());
        }
    }

    private static ScriptRunnerContext getScriptRunnerContext(boolean scan) {
        boolean sqlblank;
        ScriptRunnerContext orig = LbUtils.getContext();
        ScriptRunnerContext ctx = orig.clone();
        ctx.consumerRuning(true);
        ctx.setCurrentConnection(orig.getBaseConnection());
        ctx.putProperty("script.runner.appinfo.arraylist", new ArrayList());
        ctx.putProperty("output_stream_wrapper", (Object)new WrapListenBufferOutputStream((OutputStream)new BufferedOutputStream(System.out)));
        ctx.setSQLPlusBuffer((IBuffer)new Buffer());
        ctx.putProperty("script.runner.using.systemout", (Object)true);
        ctx.setScanOn(scan);
        ctx.setSubstitutionOn(scan);
        ctx.setSqlError(4);
        ctx.putProperty("sqlplus.error.logging", (Object)true);
        ctx.putProperty("script.runner.exit_int_whenever", (Object)2);
        ctx.putProperty("script.runner.exit_int_whenever.wassqlcode", (Object)true);
        ctx.setTopLevel(false);
        try {
            sqlblank = LbUtils.getParameter("SQLBLANKLINES").equalsIgnoreCase("on");
        }
        catch (IOException e) {
            sqlblank = true;
        }
        if (sqlblank) {
            ctx.putProperty("SQLBLANKLINES", (Object)"on");
        } else {
            ctx.putProperty("SQLBLANKLINES", (Object)"off");
        }
        return ctx;
    }

    public static void setDDLParameter(Connection conn, String key, String value) throws SQLException {
        HashMap<String, String> binds = new HashMap<String, String>();
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String sql = COLLATION_CLAUSE.equals(key) ? SET_STRING_DDL : SET_BOOL_DDL;
        binds.put("OPTION", key);
        binds.put("VALUE", value);
        dbUtil.execute(sql, binds);
        Logger.info(QueryUtils.class, (String)sql);
        Logger.info(QueryUtils.class, (String)LbUtils.mapToString(binds));
        SQLException e = dbUtil.getLastException();
        if (null != e) {
            Logger.warn(QueryUtils.class, (Throwable)e);
            throw e;
        }
    }

    public static int updateTable(String sql, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        return dbUtil.executeUpdate(sql, new HashMap());
    }

    static {
        p_scan = null;
    }
}

