/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;
import lombok.Generated;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.configuration.SqlclConfig;
import oracle.dbtools.raptor.liquibase.configuration.SqlclConfigWrapper;
import oracle.dbtools.raptor.liquibase.core.ActiveCommand;
import oracle.dbtools.raptor.liquibase.exception.BadConnectionException;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LbCommand;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.util.Logger;

public class LbUtils {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private static final String NL = System.lineSeparator();
    private static final String FILENAME = "liquibase-parms.prop";
    private static final String USERNAME = "(\"?)%USER_NAME%(\"?)";
    private static final Map<String, String> parameterDescriptions = new HashMap<String, String>();
    private static final Object lock = new Object();
    private static final Map<String, String> defaultParameters = new HashMap<String, String>();
    private static Map<String, String> parameters = new HashMap<String, String>();
    private static String collation = "unknown";
    private static ScriptRunnerContext pctx;

    private LbUtils() {
    }

    public static void checkConnection(Connection conn) throws BadConnectionException {
        try {
            if (null == conn || !conn.isValid(2)) {
                throw new BadConnectionException("Connection Failed validation make sure you are still connected.");
            }
        }
        catch (SQLException ignored) {
            throw new BadConnectionException("Connection Failed validation make sure you are still connected.");
        }
    }

    public static void addError(String file, Exception error) {
        LbUtils.getConfig().addError(file, error);
    }

    public static SqlclConfig getConfig() {
        return (SqlclConfig)SqlclConfigWrapper.SQLCL_CONFIG.getCurrentValue();
    }

    public static String getBanner() {
        Object myVersion = LiquibaseUtil.getBuildVersionInfo();
        String buildTimeString = LiquibaseUtil.getBuildTime();
        StringBuilder banner = new StringBuilder();
        banner.append(String.format(coreBundle.getString("starting.liquibase.at.timestamp"), LocalDateTime.now()));
        if (StringUtil.isNotEmpty((String)myVersion) && StringUtil.isNotEmpty((String)buildTimeString)) {
            myVersion = (String)myVersion + " #" + LiquibaseUtil.getBuildNumber();
            banner.append(String.format(coreBundle.getString("liquibase.version.builddate"), myVersion, buildTimeString));
        }
        return banner.toString();
    }

    public static String getSqlClVersion() {
        return Messages.getString("SQLclVersion.VERSION");
    }

    public static String getVersion() {
        String myVersion = LiquibaseUtil.getBuildVersionInfo() + " #" + LiquibaseUtil.getBuildNumber();
        String buildTimeString = LiquibaseUtil.getBuildTime();
        return "Liquibase version:   " + String.format(" %s built at %s", myVersion, buildTimeString) + "\nExtension Version:   " + Messages.getString("SQLclVersion.VERSION") + "/24.1.37-" + LbUtils.getBuildTime(LbCommand.class) + "\n";
    }

    public static String getBuildTime(Class<?> cl) {
        try {
            String rn = cl.getName().replace('.', '/') + ".class";
            JarURLConnection j = (JarURLConnection)Objects.requireNonNull(cl.getClassLoader().getResource(rn)).openConnection();
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime date = ZonedDateTime.ofInstant(Instant.ofEpochSecond(j.getJarFile().getEntry("META-INF/MANIFEST.MF").getTime()), zoneId);
            SimpleDateFormat df2 = new SimpleDateFormat("HHmmss");
            return df2.format(date);
        }
        catch (Exception e) {
            return "0101";
        }
    }

    public static void setCollation() {
        DBUtil util = DBUtil.getInstance((Connection)LbUtils.getLbConnection().getUnderlyingConnection());
        if (null != collation) {
            collation = util.executeReturnOneCol("select default_collation from user_users");
        }
        if ("USING_NLS_COMP".equals(collation)) {
            collation = null;
            return;
        }
        util.execute("alter session set default_collation=USING_NLS_COMP");
    }

    public static String getCWD() {
        String ret;
        try {
            ret = Paths.get(FileUtils.getCWD((ScriptRunnerContext)LbUtils.getContext()), new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (Exception Ignored) {
            ret = Paths.get(FileUtils.getCWD((ScriptRunnerContext)LbUtils.getContext()), new String[0]).toAbsolutePath().toString();
        }
        if (ret.endsWith(File.separator)) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret.replace("\\", "/");
    }

    public static ActiveCommand getCommand() {
        return LbUtils.getConfig().getCommand();
    }

    public static void setCommand(ActiveCommand command) {
        LbUtils.getConfig().setCommand(command);
    }

    public static void clearCollation() {
        if (null != collation) {
            DBUtil util = DBUtil.getInstance((Connection)LbUtils.getLbConnection().getUnderlyingConnection());
            util.execute("alter session set default_collation = " + collation);
        }
    }

    public static Exception getRoot(Throwable throwable) {
        if (throwable != null) {
            Throwable rootCause;
            for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
            }
            return (Exception)rootCause;
        }
        return new RuntimeException("No Exception provided unable to determine Root error.");
    }

    public static String mapToString(Map<?, ?> map) {
        return Joiner.on((String)",").withKeyValueSeparator("=").join(map);
    }

    public static String getLiquibaseSchema(Database database) throws LiquibaseException {
        ActiveCommand ac = LbUtils.getCommand();
        try {
            if (ac == null) {
                return LbUtils.getConfig().getContext().getCurrentConnection().getSchema();
            }
        }
        catch (SQLException e) {
            try {
                return LbUtils.getConfig().getContext().getBaseConnection().getSchema();
            }
            catch (SQLException ex) {
                throw new LiquibaseException((Throwable)ex);
            }
        }
        boolean output = LbUtils.getCommand().isFlagSet(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA);
        String def_schema = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME);
        String lb_schema = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME);
        if (output) {
            if (null == lb_schema || lb_schema.isEmpty()) {
                if (null == def_schema || def_schema.isEmpty()) {
                    String usr = database.getConnection().getConnectionUserName();
                    if (usr.contains("\"")) {
                        usr = usr.replace("\"", "");
                    }
                    return usr;
                }
                return def_schema;
            }
            return lb_schema.replace("\"", "");
        }
        if (null != lb_schema && !lb_schema.isEmpty()) {
            return lb_schema.replace("\"", "");
        }
        String usr = database.getConnection().getConnectionUserName();
        if (usr.contains("\"")) {
            usr = usr.replace("\"", "");
        }
        return usr;
    }

    public static String replaceLiquibaseSchema(String sql) {
        String schema;
        try {
            schema = LbUtils.getLiquibaseSchema(LbUtils.getCommand().getDb());
        }
        catch (LiquibaseException e) {
            try {
                schema = LbUtils.getConfig().getContext().getCurrentConnection().getSchema();
            }
            catch (SQLException ex) {
                schema = "UNKNOWN";
            }
        }
        String ret = sql;
        ret = ret.replaceAll(USERNAME, "$1" + schema + "$2");
        return ret;
    }

    public static String replaceUserSchema(String sql, String ObjectOwner) {
        String ret = sql;
        if (ObjectOwner == null) {
            ObjectOwner = LbUtils.getLbConnection().getConnectionUserName();
        }
        if (!LbUtils.getCommand().isFlagSet(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA)) {
            ret = ret.replaceAll("(\"?%USER_NAME%\"?\\.?)", "");
        } else if (LbUtils.getCommand().isFlagSet(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA)) {
            String schema = ObjectOwner;
            if (null != LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME)) {
                schema = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME);
            }
            ret = schema != null ? ret.replaceAll(USERNAME, "$1" + schema + "$2") : ret.replaceAll("(\"?%USER_NAME%\"?\\.?)", "");
        }
        return ret;
    }

    public static String replaceUserSchemaGrants(String sql, String ObjectOwner) {
        String ret = sql;
        String schema = ObjectOwner;
        if (null != LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME)) {
            schema = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME);
        }
        ret = ret.replaceAll(USERNAME, "$1" + schema + "$2");
        return ret;
    }

    public static String getUserSchema(String originalOwner, String currentUser) {
        String defaultUser = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME);
        boolean ouds = (Boolean)LbUtils.getCommand().getParsedCommand().getOptionValue((Id)LBOptions.Options.OUTPUT_DEFAULT_SCHEMA);
        if (!ouds) {
            return currentUser;
        }
        if (null != defaultUser && !defaultUser.isEmpty()) {
            return defaultUser;
        }
        return originalOwner;
    }

    public static JdbcConnection getLbConnection() {
        return LbUtils.getConfig().getCommand().getActiveConn();
    }

    public static void log(Class<?> clazz, String msg) {
        Logger.info(clazz, (String)msg);
        LbUtils.reportIfDebug(msg);
    }

    private static void reportIfDebug(String msg) {
        if (LbUtils.isDebug()) {
            LbUtils.getContext().write("DEBUG: " + msg);
        }
    }

    public static boolean isDebug() {
        return LbUtils.getCommand().isFlagSet(LBOptions.Options.DEBUG);
    }

    public static ScriptRunnerContext getContext() {
        if (LbUtils.getConfig() != null) {
            return LbUtils.getConfig().getContext();
        }
        return new ScriptRunnerContext();
    }

    public static void setContext(ScriptRunnerContext context) {
        LbUtils.getConfig().setContext(context);
    }

    public static void resetErrors() {
        LbUtils.getConfig().resetErrorList();
    }

    public static String writeErrorLog() {
        try {
            if (!LbUtils.getConfig().getAllErrors().isEmpty()) {
                return LbFileUtils.writeErrorLog(LbUtils.getErrors());
            }
        }
        catch (IOException e) {
            LbUtils.report(Messages.getString("LB_LOGFILE_ERROR"));
            LbUtils.log(LbUtils.class, e);
        }
        return null;
    }

    private static String getErrors() {
        if (LbUtils.getConfig().getAllErrors().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        int fC = 1;
        sb.append(NL).append("######## ERROR SUMMARY ##################").append(NL);
        sb.append("Run date:    ").append(LocalDateTime.now().format(formatter)).append(NL);
        sb.append("Error cnt:").append(LbUtils.getErrCount()).append(NL).append(NL);
        LinkedList<String> files = new LinkedList<String>(LbUtils.getConfig().getAllErrors().keySet());
        Collections.reverse(files);
        sb.append("----------------------------").append(NL);
        for (String file : files) {
            sb.append("File #").append(fC).append(":  ").append(file).append(NL);
            ++fC;
            Exception err = LbUtils.getConfig().getAllErrors().get(file);
            sb.append("Error :").append(NL).append(Throwables.getStackTraceAsString((Throwable)LbUtils.getRoot(err))).append(NL);
        }
        sb.append("----------------------------").append(NL);
        return sb.toString();
    }

    public static void report(String msg) {
        if (pctx != null) {
            pctx.consumerRuning(true);
            pctx.writeln(msg);
            try {
                pctx.getOutputStream().flush();
            }
            catch (IOException ignored) {
                LbUtils.log(LbUtils.class, "Unable to flush output stream");
            }
        }
        if (LbUtils.getContext() != null && LbUtils.getContext().getOutputStream() != null) {
            LbUtils.getContext().consumerRuning(true);
            LbUtils.getContext().writeln(msg);
            try {
                LbUtils.getContext().getOutputStream().flush();
            }
            catch (IOException ignored) {
                LbUtils.log(LbUtils.class, "Unable to flush output stream");
            }
        } else {
            Logger.severe(LbUtils.class, (String)"Report called and context is not set!!");
            System.err.println("WARNING: writting to STDOUT as no context is set.");
            System.err.println(msg);
        }
    }

    public static void log(Class<?> clazz, Exception e) {
        Logger.severe(clazz, (String)Throwables.getStackTraceAsString((Throwable)LbUtils.getRoot(e)));
        LbUtils.reportIfDebug(Throwables.getStackTraceAsString((Throwable)LbUtils.getRoot(e)));
    }

    public static void setParameter(String name, String value) throws IOException {
        LbUtils.loadParameters();
        parameters.put(name.toUpperCase(), value);
        LbUtils.saveParameters();
    }

    public static String getParameter(String name) throws IOException {
        LbUtils.loadParameters();
        return parameters.get(name.toUpperCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadParameters() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Path propertiesFile = Paths.get(FileUtils.getUserHome(), FILENAME);
        if (propertiesFile.toFile().exists()) {
            Object object = lock;
            synchronized (object) {
                try (FileInputStream fileInput = new FileInputStream(propertiesFile.toFile());){
                    TypeReference<HashMap<String, String>> mapType = new TypeReference<HashMap<String, String>>(){};
                    Map userParameters = (Map)mapper.readValue((InputStream)fileInput, (TypeReference)mapType);
                    LbUtils.defaultParameters(userParameters);
                }
                catch (IOException io) {
                    LbUtils.saveParameters();
                }
            }
        }
        HashMap<String, String> userParameters = new HashMap<String, String>();
        LbUtils.defaultParameters(userParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveParameters() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String userHomeDir = FileUtils.getUserHome();
        if (userHomeDir != null) {
            File dir = new File(userHomeDir);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new IOException("Failed to create directory: " + userHomeDir);
            }
        } else {
            throw new IOException("User home directory could not be determined.");
        }
        Path propertiesFile = Paths.get(userHomeDir, FILENAME);
        Object object = lock;
        synchronized (object) {
            try (FileOutputStream fileOutput = new FileOutputStream(propertiesFile.toFile(), false);){
                mapper.writeValue((OutputStream)fileOutput, parameters);
            }
            catch (IOException io) {
                LbUtils.getContext().writeln("Unable to save liquibase set parameters to disk.\n" + io.getMessage());
            }
        }
    }

    private static void defaultParameters(Map<String, String> user_parms) throws IOException {
        parameters.put("ENGINE", user_parms.getOrDefault("ENGINE", "JDBC"));
        parameters.put("SCAN", user_parms.getOrDefault("SCAN", "OFF"));
        parameters.put("SQLBLANKLINES", user_parms.getOrDefault("SQLBLANKLINES", "ON"));
        parameters.put("SKIP_ROLLBACK", user_parms.getOrDefault("SKIP_ROLLBACK", "OFF"));
        parameters.put("SAVE_CAPTURE", user_parms.getOrDefault("SAVE_CAPTURE", "OFF"));
        parameters.put("SHORTEN_SPLIT", user_parms.getOrDefault("SHORTEN_SPLIT", "OFF"));
        parameters.put("FILE_ENCODING", user_parms.getOrDefault("FILE_ENCODING", "UTF-8"));
    }

    public static void resetParameters() throws IOException {
        parameters = new HashMap<String, String>();
        LbUtils.defaultParameters(new HashMap<String, String>());
    }

    public static String pad(int howMany) {
        return " ".repeat(Math.max(0, howMany));
    }

    public static void showParameters() throws IOException {
        LbUtils.loadParameters();
        LbUtils.getContext().writeln("Liquibase stored parameters");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            LbUtils.getContext().writeln(entry.getKey() + LbUtils.pad(30 - entry.getKey().length()) + entry.getValue());
        }
    }

    public static int getErrCount() {
        return LbUtils.getConfig().getErrorCount();
    }

    @Generated
    public static Map<String, String> getParameters() {
        return parameters;
    }

    @Generated
    public static ScriptRunnerContext getPctx() {
        return pctx;
    }

    @Generated
    public static void setPctx(ScriptRunnerContext pctx) {
        LbUtils.pctx = pctx;
    }

    static {
        parameters.put("ENGINE", "JDBC");
        parameters.put("SCAN", "OFF");
        parameters.put("SQLBLANKLINES", "ON");
        parameters.put("SKIP_ROLLBACK", "OFF");
        parameters.put("SAVE_CAPTURE", "OFF");
        parameters.put("SHORTEN_SPLIT", "OFF");
        parameters.put("FILE_ENCODING", "UTF-8");
        parameterDescriptions.put("ENGINE_DESC", "\tChoose if you want to use the standard JDBC engine or the SQLCL engine to execute all sql.");
        parameterDescriptions.put("SCAN_DESC", "\tDo you want to turn SCAN off of or on by default when running a changeset");
        parameterDescriptions.put("SQLBLANKLINES_DESC", "\tDo you want to turn SQLBLANKLINES off of or on by default when runnign a changeset");
        parameterDescriptions.put("SKIP_ROLLBACK_DESC", "\tWhen executing changesets do you want sqlcl to try to automatically rollback a changeset if it fails.");
        parameterDescriptions.put("SAVE_CAPTURE_DESC", "\tFor debuging purposes only, do you want the major processesing states of generate_schema to boi logged to the database.\nThis should only be turned on by developer request.");
        parameterDescriptions.put("SHORTEN_SPLIT_DESC", "\tWhen executing liquibase generateschema using the -split command do you want the object type removed from the file name.\nUsing this table/foo_table.xml would become table/foo.xml, If you are running against and existing liquibase environment and you enable this all filenames would change.\nThis means that you either rerun all the changelogs or use one of the liquibase methods to inform liquibase of the name change.");
        parameterDescriptions.put("FILE_ENCODING_DESC", "Identify the default charset to use for all liquibase actions in sqlcl");
    }
}

