/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.core.JavaLogService;
import liquibase.resource.ResourceAccessor;
import lombok.Generated;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.Messages;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import org.apache.commons.io.FileUtils;

public class LbFileUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final String ILLEGAL_CHARACTERS = "[/\\\\?%*:|\"<>.]";
    private static File log;
    private static FileHandler fileHandler;

    private LbFileUtils() {
    }

    public static String getSourceResourceParent(AbstractOracleStatement statement) throws LiquibaseException {
        return Paths.get(LbFileUtils.getSourceResource(statement), new String[0]).getParent().toString();
    }

    public static String getSourceResource(AbstractOracleStatement statement) throws LiquibaseException {
        Path ret = Paths.get(LbFileUtils.getPath(statement), new String[0]);
        if (ret.getParent() == null && ret.toString().startsWith("/")) {
            return ret.getFileName().toString().substring(1);
        }
        return ret.toString();
    }

    private static void addFile(String file, ArrayList<String> recs) {
        if (!recs.contains(file)) {
            recs.add(file);
        }
    }

    public static String getPath(AbstractOracleStatement statement) throws LiquibaseException {
        ArrayList<String> tested = new ArrayList<String>();
        ArrayList found = new ArrayList();
        ResourceAccessor ra = Scope.getCurrentScope().getResourceAccessor();
        List searchPaths = ra.describeLocations();
        String cwd = LbFileUtils.getCwdString();
        String file = LbFileUtils.getFileString(statement);
        String changeLog = LbFileUtils.getChangeLogString(statement);
        String sourceRef = LbFileUtils.getSourceRefString();
        List<String> sps = LbFileUtils.getSearchPathList();
        String singleSearchPath = sps != null && !sps.isEmpty() ? sps.get(0) : "";
        Path filePath = Paths.get(cwd, statement.isRelative() ? sourceRef : "", singleSearchPath, statement.isRelative() ? changeLog : "", file);
        LbFileUtils.addFile(filePath.toString(), tested);
        if (filePath.toFile().exists()) {
            return filePath.toString();
        }
        filePath = Paths.get(cwd, sourceRef, file);
        LbFileUtils.addFile(filePath.toString(), tested);
        if (filePath.toFile().exists()) {
            return filePath.toString();
        }
        filePath = Paths.get(cwd, file);
        LbFileUtils.addFile(filePath.toString(), tested);
        if (filePath.toFile().exists()) {
            return filePath.toString();
        }
        if (sps != null) {
            for (String path : sps) {
                filePath = Paths.get(path, file);
                LbFileUtils.addFile(filePath.toString(), tested);
                if (!filePath.toFile().exists()) continue;
                return filePath.toString();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Unable to locate file ").append(file).append("\n\tSearched Paths:");
        for (String loc : tested) {
            sb.append("\n\t").append(loc);
        }
        throw new LiquibaseException(sb.toString());
    }

    public static String getFileString(ScriptRunnerContext ctx, String fileName) throws IOException {
        return LbFileUtils.getFile(ctx, fileName).toString();
    }

    public static File getFile(ScriptRunnerContext ctx, String fileName) throws IOException {
        Path fpath;
        Path filePath = fpath = Paths.get(fileName, new String[0]);
        int parts = fpath.getNameCount();
        if (1 == parts) {
            boolean result;
            String[] pcs = fileName.split("\\.");
            pcs[0] = LbFileUtils.removeIllegalCharacters(pcs[0], true);
            String front = 1 < pcs.length ? pcs[0] : fileName;
            Path out = fileName.contains(LbUtils.getCWD()) ? fpath : Paths.get(LbUtils.getCWD(), fileName);
            if (!LbUtils.getCommand().isFlagSet(LBOptions.Options.OVERWRITE_FILES)) {
                int i = 1;
                Object oldfront = front;
                String newfront = (String)oldfront + "_" + i;
                String newFileName = fileName;
                while (Files.exists(out, new LinkOption[0])) {
                    newFileName = newFileName.replace((CharSequence)oldfront, newfront);
                    out = Paths.get(LbUtils.getCWD(), newFileName);
                    oldfront = newfront;
                    newfront = front + "_" + ++i;
                }
            }
            if (null != out.toFile().getParentFile() && out.toFile().getParentFile().isDirectory() && !out.toFile().getParentFile().exists()) {
                Files.createDirectories(out.toFile().toPath().getParent(), new FileAttribute[0]);
            }
            if (result = out.toFile().createNewFile()) {
                return out.toFile();
            }
        }
        if (!LbUtils.getCommand().isFlagSet(LBOptions.Options.OVERWRITE_FILES)) {
            String front = fpath.getName(0).toString();
            int i = 1;
            while (Files.exists(Paths.get(LbUtils.getCWD(), filePath.toString()), new LinkOption[0])) {
                String newFront = front + "_" + i;
                ++i;
                filePath = Paths.get(fpath.toString().replaceFirst(front, newFront), new String[0]);
            }
        }
        if (!filePath.toString().contains(LbUtils.getCWD())) {
            filePath = Paths.get(LbUtils.getCWD(), filePath.toString());
        }
        if (null != filePath.toFile().getParentFile()) {
            Files.createDirectories(filePath.toFile().toPath().getParent(), new FileAttribute[0]);
        }
        if (!filePath.toFile().createNewFile()) {
            if (LbUtils.getCommand().isFlagSet(LBOptions.Options.OVERWRITE_FILES) && filePath.toFile().delete() && filePath.toFile().createNewFile()) {
                return filePath.toFile();
            }
            throw new IOException("Unable to create file " + filePath);
        }
        return filePath.toFile();
    }

    private static String sanitizeFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("File name cannot be null");
        }
        return fileName.replaceAll(ILLEGAL_CHARACTERS, "_");
    }

    public static String removeIllegalCharacters(String name, boolean singleSpaces) {
        String safe = name.trim();
        if ((safe = LbFileUtils.sanitizeFileName(safe)).endsWith("_")) {
            safe = safe.substring(0, safe.length() - 1);
        }
        safe = safe.replaceAll("\\s+", "_");
        if (singleSpaces) {
            safe = safe.replaceAll("_{2,}", "_");
        }
        return safe;
    }

    public static Path getPath(ScriptRunnerContext ctx, String fileName) throws IOException {
        return Paths.get(LbFileUtils.getFile(ctx, fileName).toString(), new String[0]);
    }

    public static void setCwd(String path, ScriptRunnerContext ctx) {
        Path newPath;
        String osName = "os.name";
        String windoz = "Windows";
        String cdPath = path.trim();
        if ((cdPath.startsWith("'") && cdPath.endsWith("'") || cdPath.startsWith("\"") && cdPath.endsWith("\"")) && 2 < cdPath.length()) {
            cdPath = cdPath.substring(1, cdPath.length() - 1);
        }
        if (System.getProperty(osName).startsWith(windoz) && cdPath.startsWith("/") && 3 < cdPath.length() && ":".equals(cdPath.substring(2, 3))) {
            cdPath = cdPath.substring(1);
        }
        if (System.getProperty(osName).startsWith(windoz)) {
            cdPath = cdPath.replace("/", "\\");
        }
        if (!System.getProperty(osName).startsWith(windoz) && cdPath.startsWith("~")) {
            cdPath = cdPath.replaceFirst("~", System.getProperty("user.home"));
        }
        Path currentDir = Paths.get((String)ctx.getMap().get(ScriptRunnerContext.SqlplusVariable._PWD.toString()), new String[0]);
        ctx.putProperty("script.runner.previous_dir", (Object)currentDir);
        try {
            newPath = currentDir.resolve(cdPath);
        }
        catch (Exception e) {
            ctx.write(MessageFormat.format(Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
            return;
        }
        try {
            newPath = newPath.toRealPath(new LinkOption[0]);
        }
        catch (IOException ignored) {
            return;
        }
        File f = newPath.toFile();
        if (f.isDirectory()) {
            String cPath;
            try {
                cPath = f.getCanonicalPath();
            }
            catch (IOException ignored) {
                return;
            }
            ctx.putProperty("script.runner.cd_command", (Object)cPath);
            ctx.getMap().put(ScriptRunnerContext.SqlplusVariable._PWD.toString(), cPath);
        } else {
            ctx.write(MessageFormat.format(Messages.getString((String)"CDNOTFOUND"), cdPath) + "\n");
        }
    }

    public static String writeErrorLog(String data) throws IOException {
        File file = LbFileUtils.getLogFile(true);
        if (!file.exists()) {
            throw new IOException("Unable to create log file.");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            writer.write(data);
            String string = Paths.get(file.toString(), new String[0]).getFileName().toString();
            return string;
        }
    }

    public static File getLogFile(boolean errorLog) throws IOException {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (errorLog) {
            File log = Paths.get(LbUtils.getCWD(), "sqlcl-lb-error" + timestamp.getTime() + ".log").toFile();
            boolean newFile = log.createNewFile();
            if (newFile) {
                return log;
            }
            throw new IOException("unable to create log file");
        }
        File log = Paths.get(LbUtils.getCWD(), "sqlcl-lb-" + timestamp.getTime() + ".log").toFile();
        boolean newFile = log.createNewFile();
        if (newFile) {
            LbFileUtils.log = log;
            return log;
        }
        throw new IOException("unable to create log file");
    }

    public static String writeFile(ScriptRunnerContext ctx, String fileName, String data) throws LiquibaseException, IOException, SQLException {
        File file = LbFileUtils.getFile(LbUtils.getContext(), fileName);
        BufferedWriter writer = LbFileUtils.getWriter(file);
        if (writer == null) {
            throw new IOException("Unable to create and write to file " + fileName);
        }
        writer.write(data);
        writer.close();
        String oType = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.OBJECT_TYPE);
        String oName = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.OBJECT_NAME);
        if (LbUtils.getCommand().isFlagSet(LBOptions.Options.SQL) && !"controller.xml".equals(fileName)) {
            String sql = "COMMENT".equals(oType) ? (LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGE_TYPE).equals("SQL") ? data.substring(data.indexOf("COMMENT")) : data.substring(data.indexOf("<![CDATA[") + 9, data.indexOf("]]>"))) : DbmsMetaUtils.getDDLFromDb(LbUtils.getLbConnection().getUnderlyingConnection(), oType, oName);
            if (sql == null) {
                throw new LiquibaseException("Unable to generate DDL for object type: " + oType + "  named: " + oName);
            }
            BufferedWriter sqlwriter = LbUtils.getCommand().isFlagSet(LBOptions.Options.SQL) && LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGE_TYPE).equals("SQL") ? LbFileUtils.getWriter(Paths.get(file.toString().replace(".sql", "_sql.sql"), new String[0]).toFile()) : LbFileUtils.getWriter(Paths.get(file.toString().replace(".xml", ".sql"), new String[0]).toFile());
            if (sqlwriter == null) {
                throw new LiquibaseException("Unable to generate DDL for object type: " + oType + "  named: " + oName);
            }
            sql = LbUtils.replaceUserSchema(sql, LbUtils.getLbConnection().getConnectionUserName());
            sqlwriter.write(sql);
            sqlwriter.close();
        }
        return Paths.get(file.toString(), new String[0]).getFileName().toString();
    }

    public static BufferedWriter getWriter(File file) {
        try {
            Path path = Paths.get(file.toString(), new String[0]);
            return new BufferedWriter(new FileWriter(path.toString()));
        }
        catch (Exception e) {
            LbUtils.report("unable to get file path for :" + file.toString());
            oracle.dbtools.util.Logger.warn(LbFileUtils.class, (Throwable)e);
            return null;
        }
    }

    public static void writeInputStreamToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file, false);){
            int read;
            byte[] bytes = new byte[8192];
            while (-1 != (read = inputStream.read(bytes))) {
                outputStream.write(bytes, 0, read);
            }
        }
    }

    public static void configureLogging(Level level, File logFile) throws IOException {
        log = logFile;
        JavaLogService logService = (JavaLogService)Scope.getCurrentScope().get((Enum)Scope.Attr.logService, LogService.class);
        Logger liquibaseLogger = Logger.getLogger("liquibase");
        logService.setParent(liquibaseLogger);
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %4$s [%2$s] %5$s%6$s%n");
        Logger rootLogger = Logger.getLogger("");
        Level cliLogLevel = level;
        if (null != log) {
            if (null == fileHandler) {
                fileHandler = new FileHandler(log.toString(), true);
                fileHandler.setFormatter(new SimpleFormatter());
                rootLogger.addHandler(fileHandler);
            }
            fileHandler.setLevel(level);
            cliLogLevel = Level.OFF;
        }
        ArrayList<String> channels = new ArrayList<String>(Arrays.asList("", "liquibase"));
        for (String channel : channels) {
            String s = channel;
            if ("all".equalsIgnoreCase(s)) {
                s = "";
            }
            Logger.getLogger(s).setLevel(level);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            if (!(handler instanceof ConsoleHandler)) continue;
            handler.setLevel(cliLogLevel);
        }
    }

    public static void cleanup() {
        if (null != fileHandler) {
            fileHandler.flush();
            fileHandler.close();
        }
        if (LbUtils.getCommand() != null) {
            LbUtils.getCommand().close();
            LbUtils.setCommand(null);
            fileHandler = null;
            LbUtils.resetErrors();
        }
    }

    public static boolean isAncestorOf(Path parent, Path child) {
        Path absoluteParent = parent.toAbsolutePath().normalize();
        Path absoluteChild = child.toAbsolutePath().normalize();
        if (absoluteParent.getNameCount() >= absoluteChild.getNameCount()) {
            return false;
        }
        Path immediateParent = absoluteChild.getParent();
        if (null == immediateParent) {
            return false;
        }
        return LbFileUtils.isSameFileAs(absoluteParent, immediateParent) || LbFileUtils.isAncestorOf(absoluteParent, immediateParent);
    }

    public static String getSchema(String objectOwner, String schemaOwner) {
        String schema = LbUtils.getCommand().isFlagSet(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA) ? (null != LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME) ? (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME) : objectOwner) : schemaOwner;
        return schema;
    }

    public static boolean isSameFileAs(Path path, Path path2) {
        try {
            return Files.isSameFile(path, path2);
        }
        catch (IOException ioe) {
            return path.toAbsolutePath().normalize().equals(path2.toAbsolutePath().normalize());
        }
    }

    public static int matchInFile(String regex, String fileStr) throws IOException {
        File file = Paths.get(fileStr, new String[0]).toFile();
        return LbFileUtils.matchInFile(regex, file);
    }

    public static int matchInFile(String regex, File file) throws IOException {
        Pattern pattern = Pattern.compile(regex);
        String str = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        Matcher matcher = pattern.matcher(str);
        int matches = 0;
        while (matcher.find()) {
            ++matches;
        }
        return matches;
    }

    public static int matchInFile(String regex, Path file) throws IOException {
        return LbFileUtils.matchInFile(regex, file.toFile());
    }

    public static String writeApexInstallFile(String fileName, String data) throws IOException, LiquibaseException {
        File file;
        BufferedWriter writer;
        String tempfile = null;
        if (null != LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR) && !LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR).toString().isEmpty()) {
            Path path = Paths.get((String)LbUtils.getCommand().getOptionValue((Id)ApexOptions.Symbol.DIR), fileName);
            tempfile = path.normalize().toString();
        }
        if (null == tempfile || tempfile.isEmpty()) {
            tempfile = fileName;
        }
        if (null == (writer = LbFileUtils.getWriter(file = LbFileUtils.getFile(LbUtils.getContext(), tempfile)))) {
            throw new LiquibaseException("Unable to write Apex install file.");
        }
        writer.write(data);
        writer.close();
        return Paths.get(file.toString(), new String[0]).getFileName().toString();
    }

    private static String getChangeLogString(AbstractOracleStatement statement) {
        Path clPath;
        String clString = statement.getFile();
        if (clString != null && !clString.isEmpty() && (clPath = Paths.get(clString, new String[0])).getParent() != null) {
            String cwd = LbUtils.getCWD();
            String clog = clPath.getParent().toString();
            if (clog.startsWith(cwd) && ((clog = clog.replace(cwd, "")).startsWith("\\") || clog.startsWith("/"))) {
                clog = clog.substring(1);
            }
            return clog;
        }
        return "";
    }

    public static String getSourceRefString() {
        String ret = "";
        String callerStr = LbUtils.getContext().getSourceRef();
        if (callerStr != null && !callerStr.isEmpty()) {
            Path callerPath;
            if (callerStr.startsWith("file:")) {
                callerStr = callerStr.replace("file:", "");
            }
            if ((callerPath = Paths.get(callerStr.replace("\\", "/"), new String[0])).getParent() != null) {
                String cwd;
                String cp = callerPath.getParent().toString();
                ret = cp.startsWith(cwd = LbUtils.getCWD()) ? callerPath.getParent().toString().replace(cwd, "") : (cwd.startsWith(cp) ? "" : cp);
                return ret;
            }
        }
        return "";
    }

    private static String getFileString(AbstractOracleStatement statement) {
        return statement.getSource();
    }

    private static String getCwdString() {
        return LbUtils.getCWD().replace("\\", "/");
    }

    private static List<String> getSearchPathList() {
        return (List)LbUtils.getCommand().getParsedCommand().getOptionValue((Id)LBOptions.Options.SEARCH_PATH);
    }

    @Generated
    public static File getLog() {
        return log;
    }

    @Generated
    public static void setLog(File log) {
        LbFileUtils.log = log;
    }
}

