/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.snapshot.jvm;

import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import oracle.dbtools.raptor.liquibase.snapshot.jvm.AbstractSnapshotGenerator;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclTable;

public class OrclTableSnapshotGenerator
extends AbstractSnapshotGenerator {
    public OrclTableSnapshotGenerator() {
        super(OrclTable.class, new Class[]{Schema.class});
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            Database database = snapshot.getDatabase();
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            List tables = exec.queryForList((SqlStatement)new RawSqlStatement(this.getTablesSQL(schema)));
            if (null != tables) {
                for (Map table : tables) {
                    schema.addDatabaseObject((DatabaseObject)this.mapToTable(table, (Schema)foundObject));
                }
            }
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        if (null != this.checkObject(example, snapshot)) {
            return this.checkObject(example, snapshot);
        }
        Database database = snapshot.getDatabase();
        Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List tables = exec.queryForList((SqlStatement)new RawSqlStatement(this.getTablesSQL(example.getSchema())));
        DatabaseObject sequenceRow = this.getTables(example, tables);
        return sequenceRow;
    }

    private DatabaseObject getTables(DatabaseObject example, List<? extends Map<String, ?>> tables) {
        for (Map<String, ?> tableRow : tables) {
            String name = (String)tableRow.get("TABLE_NAME");
            if (!name.equals(example.getName())) continue;
            return this.mapToTable(tableRow, example.getSchema());
        }
        return null;
    }

    private OrclTable mapToTable(Map<String, ?> tableRow, Schema schema) {
        OrclTable table = new OrclTable();
        table.setName((String)tableRow.get("TABLE_NAME"));
        String source = (String)tableRow.get("SOURCE");
        source = source.replaceAll("\"" + schema + "\"[.]", "");
        source = source.replaceAll(schema + "[.]", "");
        table.setSource(source);
        table.setSxml((String)tableRow.get("SXML"));
        table.setSchema(schema);
        table.setAttribute("liquibase-complete", true);
        return table;
    }

    protected String getTablesSQL(Schema schema) {
        return "SELECT TABLE_NAME, dbms_metadata.get_ddl('TABLE',TABLE_NAME,OWNER) SOURCE,  dbms_metadata.get_SXML('TABLE',TABLE_NAME,OWNER) SXML FROM ALL_TABLES WHERE OWNER = '" + schema.getName() + "'";
    }
}

