/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.snapshot.jvm;

import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import oracle.dbtools.raptor.liquibase.snapshot.jvm.AbstractSnapshotGenerator;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclProcedure;

public class OrclProcedureSnapshotGenerator
extends AbstractSnapshotGenerator {
    public OrclProcedureSnapshotGenerator() {
        super(OrclProcedure.class, new Class[]{Schema.class});
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            Database database = snapshot.getDatabase();
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            List procedures = exec.queryForList((SqlStatement)new RawSqlStatement(this.getProceduresSQL(schema)));
            if (null != procedures) {
                for (Map procedure : procedures) {
                    schema.addDatabaseObject((DatabaseObject)this.mapToProcedure(procedure, (Schema)foundObject));
                }
            }
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        if (null != this.checkObject(example, snapshot)) {
            return this.checkObject(example, snapshot);
        }
        Database database = snapshot.getDatabase();
        Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List procedures = exec.queryForList((SqlStatement)new RawSqlStatement(this.getProceduresSQL(example.getSchema())));
        DatabaseObject sequenceRow = this.getProcedures(example, procedures);
        return sequenceRow;
    }

    private DatabaseObject getProcedures(DatabaseObject example, List<? extends Map<String, ?>> procedures) {
        for (Map<String, ?> procedureRow : procedures) {
            String name = (String)procedureRow.get("PROCEDURE_NAME");
            if (!name.equals(example.getName())) continue;
            return this.mapToProcedure(procedureRow, example.getSchema());
        }
        return null;
    }

    private OrclProcedure mapToProcedure(Map<String, ?> procedureRow, Schema schema) {
        OrclProcedure procedure = new OrclProcedure();
        procedure.setName((String)procedureRow.get("PROCEDURE"));
        procedure.setSource((String)procedureRow.get("SOURCE"));
        procedure.setSchema(schema);
        procedure.setAttribute("liquibase-complete", true);
        return procedure;
    }

    protected String getProceduresSQL(Schema schema) {
        return " SELECT object_name PROCEDURE, dbms_metadata.get_ddl('PROCEDURE',OBJECT_NAME,OWNER) SOURCE FROM ALL_PROCEDURES WHERE OWNER = '" + schema.getName() + "' AND OBJECT_TYPE = 'PROCEDURE'";
    }
}

