/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.snapshot.jvm;

import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import oracle.dbtools.raptor.liquibase.snapshot.jvm.AbstractSnapshotGenerator;
import oracle.dbtools.raptor.liquibase.structure.orcl.OrclFunction;

public class OrclFunctionSnapshotGenerator
extends AbstractSnapshotGenerator {
    public OrclFunctionSnapshotGenerator() {
        super(OrclFunction.class, new Class[]{Schema.class});
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            Database database = snapshot.getDatabase();
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            List functions = exec.queryForList((SqlStatement)new RawSqlStatement(this.getFunctionsSQL(schema)));
            if (null != functions) {
                for (Map function : functions) {
                    schema.addDatabaseObject((DatabaseObject)this.mapTofunction(function, (Schema)foundObject));
                }
            }
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        if (null != this.checkObject(example, snapshot)) {
            return this.checkObject(example, snapshot);
        }
        Database database = snapshot.getDatabase();
        Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List functions = exec.queryForList((SqlStatement)new RawSqlStatement(this.getFunctionsSQL(example.getSchema())));
        return this.getFunctions(example, functions);
    }

    private DatabaseObject getFunctions(DatabaseObject example, List<? extends Map<String, ?>> functions) {
        for (Map<String, ?> functionRow : functions) {
            String name = (String)functionRow.get("FUNCTION");
            if (!name.equals(example.getName())) continue;
            return this.mapTofunction(functionRow, example.getSchema());
        }
        return null;
    }

    private OrclFunction mapTofunction(Map<String, ?> functionRow, Schema schema) {
        OrclFunction function = new OrclFunction();
        function.setName((String)functionRow.get("FUNCTION"));
        function.setSource((String)functionRow.get("SOURCE"));
        function.setSchema(schema);
        function.setAttribute("liquibase-complete", true);
        return function;
    }

    protected String getFunctionsSQL(Schema schema) {
        return "SELECT object_name FUNCTION, dbms_metadata.get_ddl('FUNCTION',OBJECT_NAME,OWNER) SOURCE FROM ALL_PROCEDURES WHERE OWNER = '" + schema.getName() + "' AND OBJECT_TYPE = 'FUNCTION'";
    }
}

