/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator.changeSets.core;

import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import liquibase.exception.DatabaseException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.generator.changeSets.core.AbstractChangeSet;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;

public class YamlChangeSet
extends AbstractChangeSet {
    String rawchange = "databaseChangeLog:\n-  changeSet:\n    id:  %ID%\n    author:  %AUTHOR%\n    %FAILONERROR%    %CONTEXTS%    %LABELS%    %RUNONCHANGE%    %RUNALWAYS%    %RUNINTRANSACTION%    changes:\n    -  %CHANGE_TYPE%:\n        objectName:\"%OBJECT_NAME%\"\n        objectType=\"%OBJECT_TYPE%\"\n        ownerName=\"%OWNER_NAME%\"\n        %SOURCE_TYPE%        %REPLACEXISTS%        source: %SOURCE%\n";

    @Override
    public String getChange() throws NoSuchAlgorithmException {
        String schema = this.getData().getSCHEMA();
        this.rawchange = LiquibaseStringUtils.replaceVal("%ID%", this.getSha1fromString(this.getData().getDDL()), this.rawchange);
        this.rawchange = LiquibaseStringUtils.replaceVal("%AUTHOR%", "(" + schema + ")-Generated", this.rawchange);
        this.rawchange = LiquibaseStringUtils.replaceVal("%OBJECT_NAME%", this.getData().getONAME().replaceAll("\"", ""), this.rawchange);
        this.rawchange = LiquibaseStringUtils.replaceVal("%OBJECT_TYPE%", this.getData().getOTYPE(), this.rawchange);
        if (null != schema) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%OWNER_NAME%", schema, this.rawchange);
        }
        this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE%", this.getData().getDDL().replaceAll("\\]\\]\\>", "]]]]><![CDATA[>"), this.rawchange);
        if (DbmsMetaUtils.isSxmlType(this.getData().getOTYPE().toUpperCase())) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "createSxmlObject", this.rawchange);
        } else if ("COMMENT".equalsIgnoreCase(this.getData().getOTYPE())) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "createOracleComment", this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", this.rawchange);
        } else if ("SCRIPT".equalsIgnoreCase(this.getData().getOTYPE()) && "ORDS".equals(this.getData().getONAME())) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runOrdsScript", this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", this.rawchange);
        } else if ("SCRIPT".equalsIgnoreCase(this.getData().getOTYPE()) && "APEX".equals(this.getData().getONAME())) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runApexScript", this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", this.rawchange);
        } else if ("SCRIPT".equalsIgnoreCase(this.getData().getOTYPE())) {
            this.rawchange = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", "runOracleScript", this.rawchange);
            this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "sourceType=\"STRING\"", this.rawchange);
        } else {
            this.rawchange = LiquibaseStringUtils.replaceVal("%CHANGE_TYPE%", SchemaGenerator.ddlChangeTypes.get(this.getData().getOTYPE().toUpperCase()), this.rawchange);
        }
        this.rawchange = LiquibaseStringUtils.replaceVal("%SOURCE_TYPE%", "", this.rawchange);
        if ("TRIGGER".equals(this.getData().getOTYPE())) {
            this.rawchange = this.rawchange.replaceAll("END;\\nALTER TRIGGER", "END;\n/\nALTER TRIGGER");
        }
        this.rawchange = this.getData().isFAIL() ? LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"true\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"false\"", this.rawchange);
        this.rawchange = this.getData().isREPLACE() ? LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"true\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%REPLACEXISTS%", "replaceIfExists=\"false\"", this.rawchange);
        this.rawchange = null != this.getData().getCONTEXT() && !this.getData().getCONTEXT().isEmpty() ? LiquibaseStringUtils.replaceVal("%CONTEXTS%", "context=\"" + this.getData().getCONTEXT() + "\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%CONTEXTS%", null, this.rawchange);
        this.rawchange = null != this.getData().getLABEL() && !this.getData().getLABEL().isEmpty() ? LiquibaseStringUtils.replaceVal("%LABELS%", "labels=\"" + this.getData().getLABEL() + "\"", this.rawchange) : LiquibaseStringUtils.replaceVal("%LABELS%", null, this.rawchange);
        Object runOptions = this.getData().isRUNONCHANGE() ? "runOnChange=\"true\" " : "runOnChange=\"false\" ";
        runOptions = this.getData().isRUNALWAYS() ? (String)runOptions + "runAlways=\"true\" " : (String)runOptions + "runAlways=\"false\" ";
        if (this.getData().isDISABLETRANS()) {
            runOptions = (String)runOptions + "runInTransaction=\"true\" ";
        }
        this.rawchange = LiquibaseStringUtils.replaceVal("%RUNOPTIONS%", (String)runOptions, this.rawchange);
        this.rawchange = this.rawchange.replaceAll("(\"?)" + Pattern.quote(schema) + "(\"?)(\\.\"?" + Pattern.quote(this.getData().getONAME()) + "\"?)", "$1%USER_NAME%$2$3");
        return this.rawchange;
    }
}

