/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.generator;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import lombok.Generated;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.raptor.liquibase.exception.GenericLbException;
import oracle.dbtools.raptor.liquibase.exception.ObjectNotFoundException;
import oracle.dbtools.raptor.liquibase.generator.ChangeSetFactory;
import oracle.dbtools.raptor.liquibase.generator.SchemaGeneratorUtils;
import oracle.dbtools.raptor.liquibase.util.ApexUtils;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.liquibase.util.StopWatch;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.util.Logger;

public class SchemaGenerator {
    public static final String REF_CONSTRAINT = "REF_CONSTRAINT";
    public static final String CONSTRAINT = "CONSTRAINT";
    public static final String DIMENSION = "DIMENSION";
    public static final String FUNCTION = "FUNCTION";
    public static final String PROCEDURE = "PROCEDURE";
    public static final String PACKAGE_SPEC = "PACKAGE_SPEC";
    public static final String PACKAGE_BODY = "PACKAGE_BODY";
    public static final String TYPE_SPEC = "TYPE_SPEC";
    public static final String TYPE_BODY = "TYPE_BODY";
    public static final String PUBLIC_SYNONYM = "PUBLIC_SYNONYM";
    public static final String SYNONYM = "SYNONYM";
    public static final String OBJECT_GRANT = "OBJECT_GRANT";
    public static final String DB_LINK = "DB_LINK";
    public static final String TRIGGER = "TRIGGER";
    public static final String JOB = "JOB";
    public static final String DIRECTORY = "DIRECTORY";
    public static final String COMMENT = "COMMENT";
    public static final String ROLE_GRANT = "ROLE_GRANT";
    public static final String SYSTEM_GRANT = "SYSTEM_GRANT";
    public static final String MATERIALIZED_VIEW_LOG = "MATERIALIZED_VIEW_LOG";
    public static final String MATERIALIZED_VIEW = "MATERIALIZED_VIEW";
    public static final String SEQUENCE = "SEQUENCE";
    public static final String CLUSTER = "CLUSTER";
    public static final String TABLE = "TABLE";
    public static final String VIEW = "VIEW";
    public static final String INDEX = "INDEX";
    public static final Map<String, String> typeNameTransform = ImmutableMap.copyOf((Map)new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(SchemaGenerator.PACKAGE_SPEC, "PACKAGE");
            this.put(SchemaGenerator.PACKAGE_BODY, "PACKAGE BODY");
            this.put(SchemaGenerator.TYPE_SPEC, "TYPE");
            this.put(SchemaGenerator.TYPE_BODY, "TYPE BODY");
            this.put(SchemaGenerator.MATERIALIZED_VIEW_LOG, "MATERIALIZED VIEW LOG");
            this.put(SchemaGenerator.MATERIALIZED_VIEW, "MATERIALIZED VIEW");
            this.put(SchemaGenerator.DB_LINK, "DATABASE LINK");
            this.put(SchemaGenerator.PUBLIC_SYNONYM, "PUBLIC SYNONYM");
        }
    });
    public static final List<String> ddlTypes = ImmutableList.copyOf((Collection)new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(SchemaGenerator.CONSTRAINT);
            this.add(SchemaGenerator.REF_CONSTRAINT);
            this.add(SchemaGenerator.DIMENSION);
            this.add(SchemaGenerator.FUNCTION);
            this.add(SchemaGenerator.PROCEDURE);
            this.add(SchemaGenerator.PACKAGE_SPEC);
            this.add(SchemaGenerator.PACKAGE_BODY);
            this.add(SchemaGenerator.TYPE_SPEC);
            this.add(SchemaGenerator.TYPE_BODY);
            this.add(SchemaGenerator.PUBLIC_SYNONYM);
            this.add(SchemaGenerator.SYNONYM);
            this.add(SchemaGenerator.OBJECT_GRANT);
            this.add(SchemaGenerator.DB_LINK);
            this.add(SchemaGenerator.TRIGGER);
            this.add(SchemaGenerator.JOB);
            this.add(SchemaGenerator.DIRECTORY);
            this.add(SchemaGenerator.COMMENT);
        }
    });
    public static final String CREATEORACLEGRANT = "createOracleGrant";
    public static final Map<String, String> ddlChangeTypes = ImmutableMap.copyOf((Map)new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(SchemaGenerator.CONSTRAINT, "createOracleConstraint");
            this.put(SchemaGenerator.REF_CONSTRAINT, "createOracleRefConstraint");
            this.put(SchemaGenerator.DIMENSION, "createOracleDimension");
            this.put(SchemaGenerator.FUNCTION, "createOracleFunction");
            this.put(SchemaGenerator.PROCEDURE, "createOracleProcedure");
            this.put(SchemaGenerator.PACKAGE_SPEC, "createOraclePackageSpec");
            this.put(SchemaGenerator.PACKAGE_BODY, "createOraclePackageBody");
            this.put(SchemaGenerator.TYPE_SPEC, "createOracleTypeSpec");
            this.put(SchemaGenerator.TYPE_BODY, "createOracleTypeBody");
            this.put(SchemaGenerator.PUBLIC_SYNONYM, "createOraclePublicSynonym");
            this.put(SchemaGenerator.SYNONYM, "createOracleSynonym");
            this.put(SchemaGenerator.OBJECT_GRANT, SchemaGenerator.CREATEORACLEGRANT);
            this.put(SchemaGenerator.ROLE_GRANT, SchemaGenerator.CREATEORACLEGRANT);
            this.put(SchemaGenerator.SYSTEM_GRANT, SchemaGenerator.CREATEORACLEGRANT);
            this.put(SchemaGenerator.DB_LINK, "createOracleDbLink");
            this.put(SchemaGenerator.TRIGGER, "createOracleTrigger");
            this.put(SchemaGenerator.JOB, "createOracleJob");
            this.put(SchemaGenerator.DIRECTORY, "createOracleDirectory");
            this.put(SchemaGenerator.COMMENT, "createOracleComment");
        }
    });
    public static final String CONTROLLERFOOTER = "</databaseChangeLog> \n";
    protected static Map<String, Integer> orderedTypesLong = Collections.unmodifiableMap(new LinkedHashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(SchemaGenerator.TYPE_SPEC, 10);
            this.put(SchemaGenerator.TYPE_BODY, 13);
            this.put(SchemaGenerator.SEQUENCE, 15);
            this.put(SchemaGenerator.DIRECTORY, 17);
            this.put(SchemaGenerator.CLUSTER, 19);
            this.put(SchemaGenerator.TABLE, 21);
            this.put(SchemaGenerator.MATERIALIZED_VIEW_LOG, 23);
            this.put(SchemaGenerator.MATERIALIZED_VIEW, 25);
            this.put(SchemaGenerator.VIEW, 27);
            this.put(SchemaGenerator.REF_CONSTRAINT, 29);
            this.put(SchemaGenerator.DIMENSION, 31);
            this.put(SchemaGenerator.PACKAGE_SPEC, 33);
            this.put(SchemaGenerator.FUNCTION, 35);
            this.put(SchemaGenerator.PROCEDURE, 37);
            this.put(SchemaGenerator.DB_LINK, 39);
            this.put(SchemaGenerator.SYNONYM, 41);
            this.put(SchemaGenerator.INDEX, 42);
            this.put(SchemaGenerator.TRIGGER, 45);
            this.put(SchemaGenerator.PACKAGE_BODY, 47);
            this.put(SchemaGenerator.JOB, 49);
            this.put(SchemaGenerator.PUBLIC_SYNONYM, 51);
            this.put(SchemaGenerator.OBJECT_GRANT, 53);
        }
    });
    private final Connection conn = LbUtils.getLbConnection().getUnderlyingConnection();
    private String SQLCL_SAVE_CAPTURE;
    private boolean capture;

    public SchemaGenerator() {
        try {
            this.SQLCL_SAVE_CAPTURE = LbUtils.getParameter("SAVE_CAPTURE");
        }
        catch (IOException e) {
            this.SQLCL_SAVE_CAPTURE = "OFF";
        }
    }

    public static void writeMasterLog(Path path) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), StandardCharsets.UTF_8);){
            writer.write(SchemaGenerator.getMasterLog());
        }
    }

    public static String getMasterLog() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<databaseChangeLog\n  xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\"\n  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n  xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog\n                      http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n  <include file=\"{filename.xml}\"/> \n</databaseChangeLog> \n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> doSchemaExport(boolean createFiles) throws IOException, LiquibaseException, ObjectNotFoundException, SQLException, NoSuchAlgorithmException, GenericLbException {
        StringBuilder sb;
        SchemaGeneratorUtils.createCaptureObjects();
        if ("ON".equals(this.SQLCL_SAVE_CAPTURE)) {
            this.capture = true;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        boolean pubSyns = LbUtils.getCommand().isFlagSet(LBOptions.Options.SYNONYMS);
        boolean grants = LbUtils.getCommand().isFlagSet(LBOptions.Options.GRANTS);
        if (createFiles) {
            sb = null;
            ScriptRunnerContext ctx = LbUtils.getContext();
            if (ctx != null) {
                ctx.write("\n" + Messages.getString("LB_FLAGS") + "\n");
                ctx.write(Messages.getString("LB_GRANTS") + "\t\t" + grants + "\n");
                ctx.write(Messages.getString("LB_SYNS") + "\t\t" + pubSyns + "\n\n");
            }
        } else {
            sb = new StringBuilder();
            sb.append("\n").append(Messages.getString("LB_FLAGS")).append("\n");
            sb.append(Messages.getString("LB_GRANTS")).append("\t\t").append(grants).append("\n");
            sb.append(Messages.getString("LB_SYNS")).append("\t\t").append(pubSyns).append("\n");
        }
        boolean split = LbUtils.getCommand().isFlagSet((Id)ApexOptions.Symbol.SPLIT);
        try {
            this.loadCaptureTable(sb);
            if (this.capture) {
                SchemaGeneratorUtils.cloneCaptureTable(LbUtils.getLbConnection().getUnderlyingConnection(), "exp_load");
            }
            if (((Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.PERFORM_DETAIL_PARSE)).booleanValue()) {
                this.processCaptureTable(sb);
                if (this.capture) {
                    SchemaGeneratorUtils.cloneCaptureTable(LbUtils.getLbConnection().getUnderlyingConnection(), "exp_process");
                }
            }
            this.sortCaptureTable(sb);
            if (this.capture) {
                SchemaGeneratorUtils.cloneCaptureTable(LbUtils.getLbConnection().getUnderlyingConnection(), "exp_sort");
            }
            StopWatch stopWatch = new StopWatch("Method writeChangeLogs", sb);
            LinkedList<String> includes = new LinkedList<String>();
            String writeFiles = QueryUtils.getXMLQueries().getQuery("writeCaptureTable", LbUtils.getLbConnection().getUnderlyingConnection()).getSql();
            try (PreparedStatement pstatement = LbUtils.getLbConnection().getUnderlyingConnection().prepareStatement(writeFiles);){
                ResultSet rs = pstatement.executeQuery();
                while (rs.next()) {
                    String oName = rs.getString(1);
                    LbUtils.getCommand().setOptionValue(LBOptions.Options.OBJECT_NAME, oName.toUpperCase());
                    String oType = rs.getString(2);
                    LbUtils.getCommand().setOptionValue(LBOptions.Options.OBJECT_TYPE, oType.toUpperCase());
                    boolean shorten = LbUtils.getParameter("SHORTEN_SPLIT").equalsIgnoreCase("ON");
                    String fname = (oName + (String)(shorten ? "" : "_" + oType) + "." + LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGE_TYPE)).toLowerCase();
                    Object filename = split ? oType.toLowerCase() + File.separator + fname : fname;
                    LbUtils.getCommand().setOptionValue(LBOptions.Options.FILENAME, filename);
                    LbUtils.getCommand().setOptionValue(LBOptions.Options.DDL, LiquibaseStringUtils.clobToString(rs.getClob(4)));
                    String changelog = this.getChangeLog();
                    if (createFiles) {
                        LbFileUtils.writeFile(LbUtils.getContext(), (String)filename, changelog);
                    }
                    ret.put((String)filename, changelog);
                    includes.add((String)filename);
                }
            }
            String controller = this.genLbController(includes);
            if (createFiles) {
                String fileName = LbFileUtils.writeFile(LbUtils.getContext(), "controller.xml", controller);
                LbUtils.getCommand().setOptionValue(LBOptions.Options.CHANGELOG_FILE, fileName);
            }
            ret.put("controller.xml", controller);
            stopWatch.end(sb);
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
        finally {
            SchemaGeneratorUtils.dropCaptureObjects();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCaptureTable(StringBuilder sb) throws SQLException {
        ScriptRunnerContext ctx = LbUtils.getContext();
        boolean pubSyns = LbUtils.getCommand().isFlagSet(LBOptions.Options.SYNONYMS);
        String filter = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.FILTER);
        StopWatch stopWatch = new StopWatch("Method loadCaptureTable", sb);
        String callLoadCapture = QueryUtils.getXMLQueries().getQuery("callLoadCapture", LbUtils.getLbConnection().getUnderlyingConnection()).getSql();
        try (CallableStatement statement = LbUtils.getLbConnection().getUnderlyingConnection().prepareCall(callLoadCapture);){
            Map<String, Integer> orderedTypes = orderedTypesLong;
            statement.registerOutParameter(1, 12);
            for (Map.Entry<String, Integer> entry : orderedTypes.entrySet()) {
                String key = entry.getKey();
                if (PUBLIC_SYNONYM.equals(key) && !pubSyns || OBJECT_GRANT.equals(key) || SYSTEM_GRANT.equals(key) || ROLE_GRANT.equals(key)) continue;
                Integer rank = entry.getValue();
                statement.setInt(2, (int)rank);
                statement.setString(3, key);
                if (null != ctx.getParameterInstance().getParameters("ddl.parms")) {
                    statement.setString(4, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("BODY"));
                    statement.setString(5, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("CONSTRAINTS"));
                    statement.setString(6, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("CONSTRAINTS_AS_ALTER"));
                    statement.setString(7, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("FORCE"));
                    statement.setString(8, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("INHERIT"));
                    statement.setString(9, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("INSERT"));
                    statement.setString(10, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("PARTITIONING"));
                    statement.setString(11, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("PRETTY"));
                    statement.setString(12, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("REF_CONSTRAINTS"));
                    statement.setString(13, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("SEGMENT_ATTRIBUTES"));
                    statement.setString(14, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("SIZE_BYTE_KEYWORD"));
                    statement.setString(15, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("SPECIFICATION"));
                    statement.setString(16, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("SQLTERMINATOR"));
                    statement.setString(17, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("STORAGE"));
                    statement.setString(18, (String)LbUtils.getContext().getParameterInstance().getParameters("ddl.parms").get("TABLESPACE"));
                    statement.setString(19, (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.DATABASE_CHANGELOG_TABLE_NAME));
                    if (null != filter) {
                        statement.setString(20, filter.replace("\"", ""));
                    } else {
                        statement.setString(20, null);
                    }
                }
                statement.executeUpdate();
                String retValue = statement.getString(1);
                if (null != retValue) {
                    throw new SQLException(retValue);
                }
                stopWatch.split("Type - " + key, sb);
            }
        }
        finally {
            stopWatch.end(sb);
        }
    }

    private void processCaptureTable(StringBuilder sb) throws SQLException, IOException {
        StopWatch stopWatch = new StopWatch("Method processCaptureTable", sb);
        String queryCaptureTable = QueryUtils.getXMLQueries().getQuery("queryCaptureTable", this.conn).getSql();
        try (PreparedStatement pstatement = this.conn.prepareStatement(queryCaptureTable);){
            ResultSet rs = pstatement.executeQuery();
            while (rs.next()) {
                ExportRec expRec = new ExportRec(rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getClob(4), rs.getString(5), rs.getString(6), rs.getString(7));
                ExportRec expRec2 = this.loadDeps(expRec);
                expRec2.updateBySeq();
            }
            stopWatch.end(sb);
        }
    }

    private void sortCaptureTable(StringBuilder sb) throws SQLException {
        StopWatch stopWatch = new StopWatch("Method sortCaptureTable", sb);
        String query = QueryUtils.getXMLQueries().getQuery("callSortCapture", this.conn).getSql();
        try (CallableStatement statement = this.conn.prepareCall(query);){
            statement.execute();
            stopWatch.end(sb);
        }
        catch (SQLException e) {
            try {
                this.conn.commit();
            }
            catch (SQLException e1) {
                Logger.warn(SchemaGenerator.class, (Throwable)e1);
                throw e1;
            }
            Logger.warn(SchemaGenerator.class, (Throwable)e);
            throw e;
        }
    }

    public String getChangeLog(String cType) throws ObjectNotFoundException, DatabaseException, SQLException, NoSuchAlgorithmException, GenericLbException {
        ChangeSetFactory factory = new ChangeSetFactory();
        if (cType == null || cType.isEmpty()) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.XML.toString()).getChange();
        }
        if (cType.equals("SQL")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.SQL.toString()).getChange();
        }
        if (cType.equals("YAML")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.YAML.toString()).getChange();
        }
        if (cType.equals("JSON")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.JSON.toString()).getChange();
        }
        if (cType.equals("XML")) {
            return factory.getChangeGenerator(ChangeSetFactory.TYPE.XML.toString()).getChange();
        }
        throw new UnsupportedOperationException("\nERROR: " + cType + " is not a supported change format please adjsut your CHANGE_TYPE.");
    }

    public String getChangeLog() throws ObjectNotFoundException, DatabaseException, NoSuchAlgorithmException, SQLException, GenericLbException {
        String cType = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.CHANGE_TYPE);
        return this.getChangeLog(cType);
    }

    public String genLbController(List<String> files) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.genControllerHeader());
        for (String file : files) {
            sb.append(this.genControllerInclude(file));
        }
        sb.append(CONTROLLERFOOTER);
        return sb.toString();
    }

    private ExportRec loadDeps(ExportRec expRec) throws SQLException, IOException {
        String ddl;
        try {
            ddl = expRec.getDDL();
        }
        catch (Exception e) {
            Logger.warn(SchemaGenerator.class, (Throwable)e);
            throw e;
        }
        SqlRecognizer recognizer = new SqlRecognizer(ddl);
        List names = recognizer.getObjectNames();
        List deps = recognizer.getReferencedTypes();
        LinkedList<String> cleandep = new LinkedList<String>();
        if (null != names && !names.isEmpty()) {
            expRec.setObjName(((String)names.get(0)).replace("\"", ""));
        }
        for (String dep : deps) {
            String replace = dep.toUpperCase().replace("\"", "");
            cleandep.add(replace);
        }
        String depList = Joiner.on((String)",").join(cleandep);
        String finalList = depList.length() > 4000 ? depList.substring(0, 4000).substring(0, depList.lastIndexOf(",")) : depList;
        expRec.setDeps(finalList);
        return expRec;
    }

    private String genControllerHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + ApexUtils.commentParamSettings("ddl.parms", ApexUtils.Position.TOP) + "\n" + ApexUtils.commentParamSettings(null, ApexUtils.Position.BOTTOM) + "\n<databaseChangeLog \n        xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n        xmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n        http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n";
    }

    private String genControllerInclude(String filename) {
        String cleanFileName = filename;
        if (filename.contains(LbUtils.getCWD())) {
            cleanFileName = filename.replace(LbUtils.getCWD(), "");
        }
        cleanFileName = cleanFileName.replace("\\", "/");
        String include = "  <include file=\"%FILE%\"/> \n";
        return LiquibaseStringUtils.replaceVal("%FILE%", cleanFileName, "  <include file=\"%FILE%\"/> \n");
    }

    public String getOrdsModuleChangeLog() throws SQLException {
        String module = (String)LbUtils.getCommand().getOptionValue(LBOptions.Options.MODULE_NAME);
        boolean enable = (Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.EXCLUDE_ENABLE_SCHEMA);
        boolean privs = (Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.EXCLUDE_PRIVS);
        String ordsQuery = "begin ? := ords_metadata.ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;";
        try (CallableStatement stmt = this.conn.prepareCall("begin ? := ords_metadata.ords_export.export_module(P_MODULE_NAME => ?, P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end, P_INCLUDE_PRIVS => case when ?=0 then true else false end); end;");){
            stmt.registerOutParameter(1, 2005);
            stmt.setString(2, module);
            stmt.setInt(3, enable ? 0 : 1);
            stmt.setInt(4, privs ? 0 : 1);
            try {
                stmt.execute();
                Clob script = stmt.getClob(1);
                LbUtils.getCommand().setOptionValue(LBOptions.Options.OBJECT_NAME, "ORDS");
                LbUtils.getCommand().setOptionValue(LBOptions.Options.OBJECT_TYPE, "SCRIPT");
                LbUtils.getCommand().setOptionValue(LBOptions.Options.DDL, LiquibaseStringUtils.clobToString(script));
                String string = this.getChangeLog();
                return string;
            }
            catch (Exception e1) {
                String string;
                block9: {
                    Logger.warn(SchemaGenerator.class, (Throwable)e1);
                    LbUtils.report(e1.getLocalizedMessage());
                    string = null;
                    if (stmt == null) break block9;
                    stmt.close();
                }
                return string;
            }
        }
    }

    public String getOrdsSchemaChangeLog() throws SQLException, IOException, DatabaseException, NoSuchAlgorithmException, ObjectNotFoundException, GenericLbException {
        boolean enable = (Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.EXCLUDE_ENABLE_SCHEMA);
        boolean privs = (Boolean)LbUtils.getCommand().getOptionValue(LBOptions.Options.EXCLUDE_PRIVS);
        String ordsQuery = "begin ? := ords_metadata.ords_export.export_schema(P_INCLUDE_ENABLE_SCHEMA => case when ?=0 then true else false end , P_INCLUDE_PRIVS => case when ?=0 then true else false end); end; ";
        CallableStatement stmt = this.conn.prepareCall(ordsQuery);
        try {
            stmt.registerOutParameter(1, 2005);
            stmt.setInt(2, enable ? 0 : 1);
            stmt.setInt(3, privs ? 0 : 1);
            try {
                stmt.execute();
            }
            catch (Exception e) {
                LbUtils.report("No Ords Metadata found please verify your information. " + e.getLocalizedMessage());
                String string = null;
                if (stmt != null) {
                    stmt.close();
                }
                return string;
            }
            Clob script = stmt.getClob(1);
            LbUtils.getCommand().setOptionValue(LBOptions.Options.OBJECT_NAME, "ORDS");
            LbUtils.getCommand().setOptionValue(LBOptions.Options.OBJECT_TYPE, "SCRIPT");
            LbUtils.getCommand().setOptionValue(LBOptions.Options.DDL, LiquibaseStringUtils.clobToString(script));
            String string = this.getChangeLog();
            return string;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    public class ExportRec {
        int rank;
        String oType;
        int seq;
        Clob source;
        String oName;
        String fName;
        String deps;

        public ExportRec(int rank, String oType, int seq, Clob source, String oName, String fName, String deps) {
            this.rank = rank;
            this.oType = oType;
            this.seq = seq;
            this.source = source;
            this.oName = oName;
            this.fName = fName;
            this.deps = deps;
        }

        public void setSource(String source) throws SQLException {
            Clob sourceClob = SchemaGenerator.this.conn.createClob();
            sourceClob.setString(1L, source);
            this.source = sourceClob;
        }

        public void setObjName(String oName) {
            this.oName = oName;
        }

        public String getDDL() throws SQLException, IOException {
            if (ddlChangeTypes.containsKey(this.oType)) {
                return LiquibaseStringUtils.trim(LiquibaseStringUtils.clobToString(this.source)).replace("REFERENCING FOR EACH ROW", "");
            }
            LbUtils.getCommand().setOptionValue(LBOptions.Options.OBJECT_TYPE, this.oType);
            return DbmsMetaUtils.getDdlFromSxml(SchemaGenerator.this.conn, this.source.getSubString(1L, (int)this.source.length()).trim(), this.oType);
        }

        public void updateBySeq() throws SQLException {
            String updateCaptureTable = QueryUtils.getXMLQueries().getQuery("updateCaptureTablebySeq", SchemaGenerator.this.conn).getSql();
            try (PreparedStatement update = SchemaGenerator.this.conn.prepareStatement(updateCaptureTable);){
                update.setClob(1, this.source);
                update.setString(2, this.oName);
                update.setString(3, this.fName);
                update.setString(4, this.deps);
                update.setString(5, this.oType);
                update.setInt(6, this.seq);
                update.executeUpdate();
                SchemaGenerator.this.conn.commit();
            }
            catch (SQLException e) {
                Logger.warn(SchemaGenerator.class, (Throwable)e);
                SchemaGenerator.this.conn.rollback();
                throw e;
            }
        }

        @Generated
        public Clob getSource() {
            return this.source;
        }

        @Generated
        public void setDeps(String deps) {
            this.deps = deps;
        }
    }
}

