/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.executor.jvm;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.changelog.visitor.OracleChangeExecListener;
import oracle.dbtools.raptor.liquibase.exception.InternalSqlException;
import oracle.dbtools.raptor.liquibase.exception.RollbackSqlException;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.CreateInternalSxmlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.DropInternalSxmlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.LogOracleActionStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.LogOracleSyncStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RollbackOraclePlSqlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RollbackOracleSxmlStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunApexScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunInternalScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunOracleScriptStatement;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.RunOrdsScriptStatement;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.util.Logger;

public class SqlClExecutor
extends JdbcExecutor {
    public static final String USER_DIR = "user.dir";
    OracleChangeExecListener listener = new OracleChangeExecListener();

    public String getName() {
        return "jdbc";
    }

    public int getPriority() {
        return super.getPriority() + 5;
    }

    public void execute(SqlStatement sql) throws DatabaseException {
        if (!(sql instanceof AbstractOracleStatement)) {
            super.execute(sql, new ArrayList());
            return;
        }
        this.execute(sql, new ArrayList<SqlVisitor>());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(SqlStatement stmt, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        boolean useSqlcl;
        String SQLCL_SKIP_RB;
        try {
            SQLCL_SKIP_RB = "ON".equals(LbUtils.getParameter("SKIP_ROLLBACK")) ? "YES" : "NO";
        }
        catch (IOException Ignored) {
            SQLCL_SKIP_RB = "NO";
        }
        try {
            useSqlcl = LbUtils.getParameter("engine") != null && LbUtils.getParameter("engine").equalsIgnoreCase("SQLCL");
        }
        catch (IOException e) {
            useSqlcl = false;
        }
        boolean isRaw = stmt instanceof RawSqlStatement;
        boolean isOrcl = stmt instanceof AbstractOracleStatement;
        if (!isOrcl && !isRaw || isRaw && !useSqlcl) {
            if (isRaw) {
                String sql = ((RawSqlStatement)stmt).getSql();
                sql = LbUtils.replaceUserSchema(sql, LbUtils.getLbConnection().getConnectionUserName());
                RawSqlStatement stmt2 = new RawSqlStatement(sql);
                super.execute((SqlStatement)stmt2, sqlVisitors);
            } else {
                super.execute(stmt, sqlVisitors);
            }
            this.flushBuffer();
            return;
        }
        String result = null;
        Logger.info(SqlClExecutor.class, (String)"Executing with the 'SqlCl-jdbc' executor");
        String[] sqls = this.applyVisitors(stmt, sqlVisitors);
        if (null != sqls) {
            for (String sSql : sqls) {
                if (null != sSql && !sSql.isEmpty()) {
                    Logger.info(SqlClExecutor.class, (String)("Executing sql \n" + sSql));
                    try {
                        if (stmt instanceof RawSqlStatement) {
                            sSql = LbUtils.replaceUserSchema(sSql, LbUtils.getLbConnection().getConnectionUserName());
                        }
                        boolean scan = stmt instanceof RunApexScriptStatement || LbUtils.getContext().getScanOn();
                        result = this.runStmt(sSql, scan, stmt);
                        if (!(stmt instanceof LogOracleActionStatement || stmt instanceof LogOracleSyncStatement || stmt instanceof CreateInternalSxmlStatement || stmt instanceof RunInternalScriptStatement || stmt instanceof DropInternalSxmlStatement)) {
                            LbUtils.report(result);
                        }
                        this.flushBuffer();
                        continue;
                    }
                    catch (LiquibaseException e) {
                        String fileName = stmt instanceof RawSqlStatement ? "FormattedSql" : ((AbstractOracleStatement)stmt).getFile();
                        String message = e.getLocalizedMessage();
                        LbUtils.addError(Objects.requireNonNullElse(fileName, LbUtils.getRoot(e).getClass().toString()), LbUtils.getRoot(e));
                        if ("NO".equals(SQLCL_SKIP_RB) && !(stmt instanceof RawSqlStatement)) {
                            try {
                                LbUtils.report(Messages.format("MIGRATION_FAILED", message));
                                this.rollbackChange((AbstractOracleStatement)stmt);
                            }
                            catch (Exception exception) {}
                        } else if (stmt instanceof RawSqlStatement) {
                            LbUtils.report(Messages.format("MIGRATION_FAILED", message));
                            LbUtils.report("\nNo Rollback for formatted sql change type\n");
                        } else {
                            LbUtils.report(Messages.format("MIGRATION_FAILED", message));
                            LbUtils.report("\nSkipping rollback due to setting SQLCL_SKIP_RB.\n");
                        }
                        this.database.rollback();
                        AbstractOracleStatement aoStmt = null;
                        if (stmt instanceof AbstractOracleStatement) {
                            aoStmt = (AbstractOracleStatement)stmt;
                            this.listener.runFailed(aoStmt.getChange().getChangeSet(), aoStmt.getChange().getChangeSet().getChangeLog(), LbUtils.getCommand().getDb(), (Exception)((Object)e));
                            LbUtils.getCommand().getDb().commit();
                            AbstractOracleChange change = (AbstractOracleChange)aoStmt.getChange();
                            if (change != null && change.getChangeSet() != null && change.getChangeSet().getFailOnError() != null && Boolean.TRUE.equals(change.getChangeSet().getFailOnError())) {
                                throw new DatabaseException("Error occurred and failonerror set to true, stopping execution.", (Throwable)e);
                            }
                            if (change == null || change.getChangeSet() == null || change.getChangeSet().getFailOnError() == null || !Boolean.TRUE.equals(change.getChangeSet().getFailOnError() == false)) throw new DatabaseException("Can not determine failonerror state, unable to continue.", (Throwable)e);
                            LbUtils.report("failonerror set to false, continuing execution");
                        } else {
                            if (!stmt.continueOnError()) {
                                throw new DatabaseException("Error occurred and continueonerror set to false, stopping execution.", (Throwable)e);
                            }
                            LbUtils.report("continueonerror set to true, continuing execution");
                        }
                        this.flushBuffer();
                        continue;
                    }
                    catch (InternalSqlException | RollbackSqlException e1) {
                        this.flushBuffer();
                        throw new DatabaseException(LbUtils.getRoot(e1).getLocalizedMessage());
                    }
                }
                LbUtils.report("No SQL to execute, nothing to do." + System.lineSeparator());
                this.flushBuffer();
            }
            return;
        } else {
            LbUtils.report("No SQL to execute, nothing to do." + System.lineSeparator());
            this.flushBuffer();
        }
    }

    private String runStmt(String sSql, boolean scan, SqlStatement stmt) throws DatabaseException, InternalSqlException, RollbackSqlException {
        String cdDir;
        AbstractOracleStatement astmt = null;
        Object dirObj = LbUtils.getContext().getProperty("script.runner.cd_command");
        String cwd = System.getProperty(USER_DIR);
        String _pwd = (String)LbUtils.getContext().getMap().get("_PWD");
        String string = cdDir = dirObj != null ? dirObj.toString() : "";
        if (!cwd.equals(_pwd) && _pwd.equals(cdDir)) {
            cwd = _pwd;
        }
        String result = "";
        try {
            if ((stmt instanceof RunOrdsScriptStatement || stmt instanceof RunApexScriptStatement || stmt instanceof RunOracleScriptStatement) && (astmt = (AbstractOracleStatement)stmt).getSourceType().equalsIgnoreCase("FILE") && astmt.getRelativeToChangelogFile().equalsIgnoreCase("true")) {
                String newCwd = LbFileUtils.getSourceResourceParent(astmt);
                System.setProperty(USER_DIR, newCwd);
                LbFileUtils.setCwd(newCwd, LbUtils.getContext());
            }
            result = QueryUtils.runSqlReturnResult(sSql, ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), scan, astmt);
            LbFileUtils.setCwd(cwd, LbUtils.getContext());
            System.setProperty(USER_DIR, cwd);
        }
        catch (Exception e) {
            LbFileUtils.setCwd(cwd, LbUtils.getContext());
            System.setProperty(USER_DIR, cwd);
            if (stmt instanceof LogOracleActionStatement || stmt instanceof LogOracleSyncStatement || stmt instanceof CreateInternalSxmlStatement || stmt instanceof RunInternalScriptStatement || stmt instanceof DropInternalSxmlStatement) {
                throw new InternalSqlException(LbUtils.getRoot(e).getMessage());
            }
            if (stmt instanceof RollbackOraclePlSqlStatement || stmt instanceof RollbackOracleSxmlStatement) {
                throw new RollbackSqlException(LbUtils.getRoot(e).getMessage());
            }
            throw new DatabaseException(LbUtils.getRoot(e).getMessage());
        }
        return result;
    }

    public void execute(Change change) throws DatabaseException {
        if (!(change instanceof AbstractOracleChange)) {
            super.execute(change);
            this.flushBuffer();
            return;
        }
        this.execute(change, new ArrayList<SqlVisitor>());
    }

    public void execute(Change change, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (!(change instanceof AbstractOracleChange)) {
            super.execute(change, sqlVisitors);
            this.flushBuffer();
            return;
        }
        SqlStatement[] sqlStatements = change.generateStatements(this.database);
        if (sqlStatements != null) {
            for (SqlStatement statement : sqlStatements) {
                if (statement.skipOnUnsupported() && !SqlGeneratorFactory.getInstance().supports(statement, this.database)) continue;
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Executing Statement: " + statement);
                try {
                    this.execute(statement, sqlVisitors);
                }
                catch (DatabaseException e) {
                    if (change.getChangeSet() != null) {
                        change.getChangeSet().setExecType(ChangeSet.ExecType.FAILED);
                        change.getChangeSet().setErrorMsg(LbUtils.getRoot(e).getLocalizedMessage());
                    }
                    if (statement.continueOnError()) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Error executing statement '" + statement + "', but continuing", (Throwable)e);
                        LbUtils.report("ContinueOnError set to true, processesing will continue.");
                        this.flushBuffer();
                    }
                    if (LbUtils.getRoot(e) instanceof DatabaseException) {
                        this.flushBuffer();
                        throw e;
                    }
                    this.flushBuffer();
                    throw new DatabaseException((Throwable)LbUtils.getRoot(e));
                }
                this.flushBuffer();
            }
        }
    }

    private void flushBuffer() {
        try {
            if (LbUtils.getContext() != null && LbUtils.getContext().getOutputStream() != null) {
                LbUtils.getContext().getOutputStream().flush();
            }
        }
        catch (IOException Ignored) {
            Logger.severe(((Object)((Object)this)).getClass(), (String)Ignored.getMessage());
        }
    }

    private void rollbackChange(AbstractOracleStatement stmt) throws DatabaseException {
        if (stmt instanceof RunOracleScriptStatement || stmt instanceof RunApexScriptStatement || stmt instanceof RunOrdsScriptStatement) {
            LbUtils.report("Unable to rollback Scripts automatically, taking no action.");
            throw new DatabaseException("Unable to rollback Scripts automatically, taking no action.");
        }
        if (stmt instanceof LogOracleActionStatement || stmt instanceof LogOracleSyncStatement || stmt instanceof CreateInternalSxmlStatement || stmt instanceof RunInternalScriptStatement || stmt instanceof DropInternalSxmlStatement) {
            Logger.warn(SqlClExecutor.class, (String)"Error occurred running internal sql.");
            Logger.warn(SqlClExecutor.class, (String)stmt.getSource());
            throw new DatabaseException("Error occurred running internal sql can not continue.");
        }
        LbUtils.report("\nRolling back changeset.\n");
        try {
            ActionLogTableManager tm = new ActionLogTableManager(this.database);
            String origObject = tm.getActionFromActionLog(stmt.getId(), stmt.getAuthor(), stmt.getFile());
            stmt.setSource(origObject);
            if (stmt instanceof AbstractCommonPlSqlStatement) {
                this.execute((SqlStatement)new RollbackOraclePlSqlStatement(stmt), null);
            } else {
                this.execute((SqlStatement)new RollbackOracleSxmlStatement(stmt), null);
            }
        }
        catch (IOException | SQLException | DatabaseException e) {
            throw new DatabaseException("Migration failed and continue on error is set to false");
        }
        LbUtils.report("Rollback completed successfully.\n");
    }
}

