/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFactory;
import liquibase.command.CommandScope;
import liquibase.command.CommandStep;
import liquibase.command.core.AbstractUpdateCommandStep;
import liquibase.command.core.UpdateCommandStep;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.ui.CompositeUIService;
import liquibase.ui.ConsoleUIService;
import liquibase.ui.UIService;
import liquibase.util.StringUtil;
import lombok.Generated;
import oracle.dbtools.raptor.liquibase.configuration.SqlClConfigurationProvider;
import oracle.dbtools.raptor.liquibase.core.CommandGenerator;
import oracle.dbtools.raptor.liquibase.resourceaccessor.SqlClSearchPathResourceAccessor;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.UncloseableJdbcConnection;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Option;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParsedCommand;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LBOptions;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.Messages;
import oracle.dbtools.util.Logger;

public class ActiveCommand {
    static final String NO_PROCESS = "Unable to process command without a valid connection";
    private final ScriptRunnerContext _ctx;
    private SqlClSearchPathResourceAccessor spa;
    private Map<String, Object> _optionValuesMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private CommandDefinition _lbCommandmandDef;
    private JdbcConnection activeConn;
    private Database _db;
    private Properties _props;
    private CommandScope _lbCommand;
    private ParsedCommand _sqlclCommand;

    private ActiveCommand(ParsedCommand parsedCommand, ScriptRunnerContext ctx, Connection conn) throws Exception {
        try {
            this._ctx = LbUtils.getPctx() != null ? LbUtils.getPctx() : ctx;
            this._ctx.consumerRuning(true);
            this._sqlclCommand = parsedCommand;
            if (conn == null) {
                throw new CommandExecutionException(NO_PROCESS);
            }
            this.checkConnection(conn);
            this.activeConn = new UncloseableJdbcConnection(conn);
            if (this.isSqlclOnlyCommand((LBOptions.Commands)parsedCommand.getType().getId())) {
                this.dispSqlClArgs();
                this._ctx.getOutputStream().flush();
                return;
            }
            CommandFactory factory = (CommandFactory)Scope.getCurrentScope().getSingleton(CommandFactory.class);
            this._lbCommandmandDef = this._sqlclCommand.getType().getName().equals(LBOptions.Commands.DATA.toString()) ? factory.getCommandDefinition(new String[]{StringUtil.toCamelCase((String)LBOptions.Commands.GENERATE_CHANGELOG.toString())}) : factory.getCommandDefinition(new String[]{StringUtil.toCamelCase((String)this._sqlclCommand.getType().getName())});
            this._lbCommand = new CommandScope(this._lbCommandmandDef.getName());
            this._lbCommand.setOutput((OutputStream)ctx.getOutputStream());
            UIService ui = Scope.getCurrentScope().getUI();
            if (ui instanceof CompositeUIService) {
                ((CompositeUIService)ui).getOutputServices().stream().filter(ConsoleUIService.class::isInstance).forEach(console -> ((ConsoleUIService)console).setOutputStream(new PrintStream((OutputStream)this._ctx.getOutputStream())));
                ((CompositeUIService)ui).getOutputServices().stream().filter(ConsoleUIService.class::isInstance).forEach(console -> ((ConsoleUIService)console).setErrorStream(new PrintStream((OutputStream)this._ctx.getOutputStream())));
            } else if (ui instanceof ConsoleUIService) {
                ((ConsoleUIService)ui).setOutputStream(new PrintStream((OutputStream)this._ctx.getOutputStream()));
                ((ConsoleUIService)ui).setErrorStream(new PrintStream((OutputStream)this._ctx.getOutputStream()));
            }
            String def = (String)this._sqlclCommand.getOptionValue((Id)LBOptions.Options.DEFAULTS_FILE);
            if (def != null && !def.isEmpty()) {
                this.loadSystemProperties(def);
            } else {
                this.loadSystemProperties(null);
            }
            this._db = this.loadDatabase(this.activeConn);
            ChangeLogParameters cp = new ChangeLogParameters(this._db);
            this._lbCommand.addArgumentValue("database", (Object)this._db);
            this._lbCommand.addArgumentValue("changeLogParameters", (Object)cp);
            this.spa = this.loadSearchPath();
            LiquibaseConfiguration config = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            for (ConfigurationValueProvider provider : config.getProviders()) {
                if (!(provider instanceof SqlClConfigurationProvider)) continue;
                config.unregisterProvider(provider);
                config.removeProvider(provider);
            }
            SqlClConfigurationProvider provider = new SqlClConfigurationProvider(ctx, this.getOptions(), def);
            config.registerProvider((ConfigurationValueProvider)provider);
            this.dispArgs();
            this._ctx.getOutputStream().flush();
        }
        catch (CommandExecutionException e) {
            Logger.warn(this.getClass(), (Throwable)e);
            throw e;
        }
    }

    public static ActiveCommand createActiveCommand(ParsedCommand parsedCommand, ScriptRunnerContext ctx, Connection conn) throws Exception {
        return new ActiveCommand(parsedCommand, ctx, conn);
    }

    private void checkConnection(Connection conn) throws CommandExecutionException {
        try {
            boolean closed = conn.isClosed();
            if (closed) {
                throw new CommandExecutionException(NO_PROCESS);
            }
        }
        catch (CommandExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    private boolean isSqlclOnlyCommand(LBOptions.Commands cmd) {
        return cmd == LBOptions.Commands.GENERATE_APEX_OBJECT || cmd == LBOptions.Commands.GENERATE_CONTROLFILE || cmd == LBOptions.Commands.GENERATE_DB_OBJECT || cmd == LBOptions.Commands.GENERATE_ORDS_MODULE || cmd == LBOptions.Commands.GENERATE_ORDS_SCHEMA || cmd == LBOptions.Commands.GENERATE_SCHEMA || cmd == LBOptions.Commands.VERSION || cmd == LBOptions.Commands.SET || cmd == LBOptions.Commands.SHOW;
    }

    private void dispSqlClArgs() {
        if (!this._sqlclCommand.isFlagSet((Id)LBOptions.Options.DEBUG)) {
            return;
        }
        try {
            this._ctx.write("/*-----------------------------  DISPLAY ARGUMENTS ------------------------------------      */" + System.lineSeparator());
            this._ctx.write("  " + System.lineSeparator());
            this._ctx.write("-------Provided Arguments-------" + System.lineSeparator());
            List options = this._sqlclCommand.getType().getOptions();
            for (Option option : options) {
                String val = null == this.getOptionValue(option.getId()) ? "null" : this.getOptionValue(option.getId()).toString();
                String req = option.isRequired() ? "REQUIRED  " : "";
                this._ctx.write("PARAM   " + req + option.getName() + LbUtils.pad(40 - (option.getName().length() + req.length())) + val + System.lineSeparator());
            }
            this._ctx.write("---------------------" + System.lineSeparator());
            this._ctx.write("  " + System.lineSeparator() + System.lineSeparator());
        }
        catch (RuntimeException e) {
            Logger.warn(CommandGenerator.class, (Throwable)e);
        }
    }

    private Database loadDatabase(JdbcConnection connection) throws DatabaseException {
        this._db = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
        this._db.setConnection((DatabaseConnection)connection);
        if (this.isParmSet(this.getOptionValue(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA))) {
            boolean ouds = (Boolean)this.getOptionValue(LBOptions.Options.OUTPUT_DEFAULT_SCHEMA);
            this._db.setOutputDefaultSchema(ouds);
        }
        if (this.isParmSet(this.getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME))) {
            this._db.setDefaultSchemaName((String)this.getOptionValue(LBOptions.Options.DEFAULT_SCHEMA_NAME));
        }
        if (this.isParmSet(this.getOptionValue(LBOptions.Options.LIQUIBASE_TABLESPACE_NAME))) {
            this._db.setLiquibaseTablespaceName((String)this.getOptionValue(LBOptions.Options.LIQUIBASE_TABLESPACE_NAME));
        }
        if (this.isParmSet(this.getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME))) {
            this._db.setLiquibaseSchemaName((String)this.getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME));
            this._db.setLiquibaseCatalogName((String)this.getOptionValue(LBOptions.Options.LIQUIBASE_SCHEMA_NAME));
        }
        this._db.setOutputDefaultCatalog(true);
        this._db.setDatabaseChangeLogTableName(this.getChangeLogTableName());
        this._db.setDatabaseChangeLogLockTableName(this.getChangeLogTableName() + "LOCK");
        return this._db;
    }

    private String getChangeLogTableName() {
        String name = (String)this.getOptionValue(LBOptions.Options.DATABASE_CHANGELOG_TABLE_NAME);
        if (name != null) {
            String defname;
            if (!name.equals("DATABASECHANGELOG")) {
                return name;
            }
            if (this.isParmSet(this.getOptionValue(LBOptions.Options.DEFAULTS_FILE)) && (defname = System.getProperty("databaseChangelogTableName")) != null) {
                return defname;
            }
            return name;
        }
        return "DATABASECHANGELOG";
    }

    private SqlClSearchPathResourceAccessor loadSearchPath() throws Exception {
        try (SqlClSearchPathResourceAccessor lSpa = new SqlClSearchPathResourceAccessor(new ResourceAccessor[0]);){
            ArrayList sps = null != this.getOptionValue(LBOptions.Options.SEARCH_PATH) ? (ArrayList)this.getOptionValue(LBOptions.Options.SEARCH_PATH) : new ArrayList();
            Path cwd = Paths.get(LbUtils.getCWD(), new String[0]);
            String srcRef = this._ctx.getSourceRef();
            String scriptDir = "";
            if (!srcRef.isEmpty()) {
                Path scriptFile;
                if (srcRef.startsWith("file:")) {
                    srcRef = srcRef.substring(5);
                }
                if ((scriptFile = Paths.get(srcRef, new String[0]).toRealPath(new LinkOption[0])).toFile().exists()) {
                    scriptDir = scriptFile.getParent().normalize().toRealPath(new LinkOption[0]).toString();
                }
            }
            ArrayList<String> paths = new ArrayList<String>();
            if (!sps.isEmpty()) {
                for (String path1 : sps) {
                    Path tPath = Paths.get(path1, new String[0]);
                    if (tPath.isAbsolute()) {
                        paths.add(tPath.toString());
                        continue;
                    }
                    paths.add(Paths.get(cwd.resolve(scriptDir).toString(), tPath.toString()).toString());
                }
            }
            if (!paths.contains(cwd.toString())) {
                paths.add(cwd.toString());
            }
            if (!scriptDir.isEmpty() && !paths.contains(scriptDir)) {
                paths.add(scriptDir);
            }
            for (String path : paths) {
                if (!Paths.get(path, new String[0]).toFile().exists()) continue;
                lSpa.addResourceAccessor(path);
            }
            Object object = lSpa;
            return object;
        }
    }

    private void dispArgs() {
        this.dispSqlClArgs();
        this.dispLbArgs();
    }

    public <T> T getOptionValue(Id optionId) {
        try {
            if (this._optionValuesMap.containsKey(optionId.toString())) {
                return (T)this._optionValuesMap.get(optionId.toString());
            }
            if (null != this._sqlclCommand.getOptionValue(optionId)) {
                return (T)this._sqlclCommand.getOptionValue(optionId);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Map<String, Object> getOptions() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry entry : this.getParsedCommand().getOptions().entrySet()) {
            map.put("liquibase.command." + StringUtil.toCamelCase((String)((String)entry.getKey()).toLowerCase()), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this._optionValuesMap.entrySet()) {
            map.put("liquibase.command." + StringUtil.toCamelCase((String)((String)entry.getKey()).toLowerCase()), entry.getValue());
        }
        if (this._sqlclCommand.getType().getName().equals(LBOptions.Commands.DATA.toString())) {
            map.put("liquibase.command.diffTypes", "data");
        }
        return map;
    }

    public void setOptionValue(Id id, Object value) {
        this._optionValuesMap.put(id.toString(), value);
    }

    private boolean isParmSet(Object parm) {
        return parm != null;
    }

    private void dispLbArgs() {
        if (!this._sqlclCommand.isFlagSet((Id)LBOptions.Options.DEBUG)) {
            return;
        }
        SortedMap args = this._lbCommand.getCommand().getArguments();
        try {
            this._ctx.write("--------Command Arguments----------" + System.lineSeparator());
            for (Map.Entry entry : args.entrySet()) {
                String arg = (String)entry.getKey();
                String pre = (((CommandArgumentDefinition)entry.getValue()).getHidden() ? "HIDDEN " : "PARAM  ") + (((CommandArgumentDefinition)entry.getValue()).isRequired() ? " REQUIRED " : " ");
                this._ctx.write(pre + arg + LbUtils.pad(40 - (arg.length() + pre.length())) + this._lbCommand.getConfiguredValue((CommandArgumentDefinition)this._lbCommand.getCommand().getArguments().get(arg)).getValueObfuscated() + System.lineSeparator());
            }
            this._ctx.write("---------------------" + System.lineSeparator() + System.lineSeparator());
        }
        catch (RuntimeException e) {
            Logger.warn(CommandGenerator.class, (Throwable)e);
        }
        this._ctx.write("/*--------------------------  END DISPLAY ARGUMENTS ---------------------------------  */" + System.lineSeparator());
        try {
            this._ctx.getOutputStream().flush();
        }
        catch (IOException e) {
            Logger.warn(CommandGenerator.class, (Throwable)e);
        }
    }

    public Database getDb() {
        return this._db;
    }

    public ScriptRunnerContext getContext() {
        return this._ctx;
    }

    public void runCommand() throws Exception {
        List pipeline = CommandFactory.getInstance().getCommandDefinition(UpdateCommandStep.COMMAND_NAME).getPipeline();
        for (CommandStep commandStep : pipeline) {
            if (!(commandStep instanceof AbstractUpdateCommandStep)) continue;
            AbstractUpdateCommandStep abstractUpdateCommandStep = (AbstractUpdateCommandStep)commandStep;
            abstractUpdateCommandStep.setFastCheckEnabled(false);
        }
        Scope.child((String)Scope.Attr.resourceAccessor.name(), (Object)((Object)this.spa), () -> ((CommandScope)this._lbCommand).execute());
        this._ctx.getOutputStream().flush();
    }

    public void close() {
        this._optionValuesMap = null;
        this._lbCommandmandDef = null;
        LbUtils.getConfig().setCommand(null);
        LbUtils.getConfig().setContext(null);
        LbUtils.setPctx(null);
        try {
            if (this._db != null) {
                this._db.close();
            }
            this._db = null;
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        this.spa = null;
        this.activeConn = null;
        this.clearDefaultProperties();
        this._lbCommand = null;
        this._sqlclCommand = null;
    }

    public ParsedCommand getParsedCommand() {
        return this._sqlclCommand;
    }

    public void clearDefaultProperties() {
        if (this._props == null || this._props.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : this._props.entrySet()) {
            System.clearProperty(((String)entry.getKey()).replaceFirst("^parameter.", ""));
        }
        this._props = null;
    }

    private void loadSystemProperties(String propertyFileName) throws IOException {
        File propertyFile;
        if (propertyFileName != null && (propertyFile = Paths.get(propertyFileName, new String[0]).isAbsolute() ? new File(propertyFileName) : new File(LbUtils.getCWD(), propertyFileName)).exists()) {
            try (FileInputStream stream = new FileInputStream(propertyFile);){
                this._props = new Properties();
                this._props.load(stream);
                for (Map.Entry<Object, Object> entry : this._props.entrySet()) {
                    System.setProperty(((String)entry.getKey()).replaceFirst("^parameter.", ""), (String)entry.getValue());
                }
            }
        }
        System.setProperty(LBOptions.Options.SQLCLVERSION.toString(), Messages.getString("SQLclVersion.VERSION"));
        System.setProperty("liquibase.logLevel", "OFF");
        System.setProperty("liquibase.sql.logLevel", "OFF");
        System.setProperty("liquibase.logChannels", "ALL");
        System.setProperty("logLevel", "OFF");
        System.setProperty("sql.logLevel", "OFF");
        System.setProperty("logChannels", "ALL");
    }

    public <T> T getArgumentValue(CommandArgumentDefinition<T> argument) {
        return (T)this._lbCommand.getArgumentValue(argument);
    }

    public void addArgumentValue(String argument, Object value) {
        this._lbCommand = this._lbCommand.addArgumentValue(argument, value);
    }

    public <T> void addArgumentValue(CommandArgumentDefinition<T> argument, T value) {
        this._lbCommand = this._lbCommand.addArgumentValue(argument, value);
    }

    public CommandDefinition getDefinition() {
        return this._lbCommandmandDef;
    }

    public CommandScope getCommandScope() {
        return this._lbCommand;
    }

    public boolean isFlagSet(Id flagId) {
        try {
            if (this._sqlclCommand == null) {
                return false;
            }
            return this._sqlclCommand.isFlagSet(flagId);
        }
        catch (Exception e) {
            try {
                return (Boolean)this._sqlclCommand.getOptionValue(flagId);
            }
            catch (Exception e1) {
                return false;
            }
        }
    }

    @Generated
    public SqlClSearchPathResourceAccessor getSpa() {
        return this.spa;
    }

    @Generated
    public JdbcConnection getActiveConn() {
        return this.activeConn;
    }
}

