/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.changelog.visitor;

import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.ext.ora.change.AbstractOracleChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.CreateInternalSxmlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.DropInternalSxmlChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.LogOracleActionChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.LogOracleSyncChange;
import oracle.dbtools.raptor.liquibase.ext.ora.change.RunInternalScriptChange;
import oracle.dbtools.raptor.liquibase.ext.ora.statement.LogOracleActionStatement;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

public class OracleChangeExecListener
extends DefaultChangeExecListener
implements ChangeLogSyncListener {
    public OracleChangeExecListener() {
        super(new ChangeExecListener[0]);
    }

    public void willRollback(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        super.willRollback(changeSet, databaseChangeLog, database);
        for (Change change : changeSet.getChanges()) {
            if ((!(change instanceof AbstractOracleChange) || this.shouldNotLog(change)) && !(change instanceof RawSQLChange)) continue;
            try {
                this.doUpdate(this.getUpdateChange(change, database, "WILL_RB"), database);
            }
            catch (Exception e) {
                LbUtils.addError("OracleChangeExecListener", e);
            }
        }
    }

    public void rolledBack(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        super.rolledBack(changeSet, databaseChangeLog, database);
        for (Change change : changeSet.getChanges()) {
            if ((!(change instanceof AbstractOracleChange) || this.shouldNotLog(change)) && !(change instanceof RawSQLChange)) continue;
            try {
                this.doUpdate(this.getUpdateChange(change, database, "ROLLED_BACK"), database);
            }
            catch (Exception e) {
                LbUtils.addError("OracleChangeExecListener", e);
            }
        }
    }

    public void willRun(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
        super.willRun(change, changeSet, changeLog, database);
        if (change instanceof AbstractOracleChange && !this.shouldNotLog(change) || change instanceof RawSQLChange) {
            try {
                this.doUpdate(this.getCreateChange(change, database), database);
            }
            catch (Exception e) {
                LbUtils.addError("OracleChangeExecListener", e);
            }
        }
    }

    public void ran(Change change, ChangeSet changeSet, DatabaseChangeLog changeLog, Database database) {
        super.ran(change, changeSet, changeLog, database);
        if (change instanceof AbstractOracleChange && !this.shouldNotLog(change) || change instanceof RawSQLChange) {
            try {
                this.doUpdate(this.getUpdateChange(change, database, "RAN"), database);
            }
            catch (Exception e) {
                LbUtils.addError("OracleChangeExecListener", e);
            }
        }
    }

    public void runFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception exception) {
        super.runFailed(changeSet, databaseChangeLog, database, exception);
        for (Change change : changeSet.getChanges()) {
            if ((!(change instanceof AbstractOracleChange) || this.shouldNotLog(change)) && !(change instanceof RawSQLChange)) continue;
            try {
                this.doUpdate(this.getUpdateChange(change, database, "FAILED"), database);
            }
            catch (Exception e) {
                LbUtils.addError("OracleChangeExecListener", e);
            }
        }
        try {
            LbUtils.getCommand().getDb().commit();
        }
        catch (Exception e1) {
            LbUtils.addError("OracleChangeExecListener", e1);
        }
    }

    public void rollbackFailed(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database, Exception e) {
        super.rollbackFailed(changeSet, databaseChangeLog, database, e);
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof AbstractOracleChange) && !(change instanceof RawSQLChange)) continue;
            try {
                this.doUpdate(this.getUpdateChange(change, database, "RB_FAILED"), database);
            }
            catch (Exception e1) {
                LbUtils.addError("OracleChangeExecListener", e);
            }
        }
        try {
            LbUtils.getCommand().getDb().commit();
        }
        catch (Exception e1) {
            LbUtils.addError("OracleChangeExecListener", e);
        }
    }

    public void markedRan(ChangeSet changeSet, DatabaseChangeLog databaseChangeLog, Database database) {
        super.markedRan(changeSet, databaseChangeLog, database);
    }

    private SqlStatement getCreateChange(Change change, Database database) throws DatabaseException {
        if (change instanceof RawSQLChange) {
            ActionLogTableManager tm = new ActionLogTableManager(database);
            String sql = ((RawSQLChange)change).getSql();
            String actionLogging = tm.getActionLogSql((RawSQLChange)change, sql);
            LogOracleActionStatement log = new LogOracleActionStatement();
            log.setSource(actionLogging);
            log.setSourceType("STRING");
            return log;
        }
        if (change instanceof AbstractOracleChange && !this.shouldNotLog(change)) {
            String sql;
            SqlStatement statement;
            ActionLogTableManager tm = new ActionLogTableManager(database);
            SqlStatement[] statements = change.generateStatements(database);
            if (statements.length > 0) {
                statement = statements[0];
                try {
                    Sql[] sqls = SqlGeneratorFactory.getInstance().generateSql(statement, database);
                    if (sqls.length > 0) {
                        sql = SqlGeneratorFactory.getInstance().generateSql(statement, database)[0].toSql();
                    }
                    sql = "No sql generated for change.";
                }
                catch (Exception e) {
                    throw new DatabaseException("Unable to determine SQL for logging, Please verify your search path is correct.");
                }
            } else {
                throw new DatabaseException("Unable to determine SQL for logging, Please verify your search path is correct.");
            }
            String actionLogging = tm.getActionLogSql(statement, sql);
            LogOracleActionStatement log = new LogOracleActionStatement();
            log.setSource(actionLogging);
            log.setSourceType("STRING");
            return log;
        }
        return null;
    }

    private boolean shouldNotLog(Change change) {
        return change instanceof CreateInternalSxmlChange || change instanceof RunInternalScriptChange || change instanceof DropInternalSxmlChange || change instanceof LogOracleSyncChange || change instanceof LogOracleActionChange || change instanceof RawSQLChange;
    }

    private void doUpdate(SqlStatement statement, Database database) throws DatabaseException {
        if (statement == null) {
            throw new RuntimeException("No logging statement, log a bug!");
        }
        try {
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            exec.execute(statement);
        }
        catch (Exception e) {
            LbUtils.addError("OracleChangeExecListener", e);
        }
    }

    private SqlStatement getUpdateChange(Change change, Database database, String status) {
        if (change instanceof AbstractOracleChange && !this.shouldNotLog(change) || change instanceof RawSQLChange) {
            String schema;
            try {
                schema = LbUtils.getLiquibaseSchema(LbUtils.getCommand().getDb());
            }
            catch (Exception e) {
                try {
                    schema = LbUtils.getConfig().getContext().getCurrentConnection() != null ? LbUtils.getConfig().getContext().getCurrentConnection().getSchema() : (LbUtils.getConfig().getContext().getBaseConnection() != null ? LbUtils.getConfig().getContext().getBaseConnection().getSchema() : "UNKNOWN");
                }
                catch (Exception ex) {
                    schema = "UNKNOWN";
                }
            }
            Object sql = "update " + schema + ".%DATABASECHANGELOG%_ACTIONS set status = '" + status + "' where id = '" + change.getChangeSet().getId() + "' and status != 'FAILED'  and sequence = (select max(sequence) from " + schema + ".%DATABASECHANGELOG%_ACTIONS where id = '" + change.getChangeSet().getId() + "')";
            sql = "UNKNOWN".equals(schema) ? ((String)sql).replaceAll(".%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName()) : ((String)sql).replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
            LogOracleActionStatement log = new LogOracleActionStatement();
            log.setSource((String)sql);
            log.setSourceType("STRING");
            return log;
        }
        return null;
    }
}

