/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogFormatter;

public class TraceLogger {
    private static final HashMap<String, Logger> m_loggerCache = new HashMap();
    private static String[] m_fineLoggers;
    private static String[] m_finerLoggers;
    private static String[] m_finestLoggers;
    private static Level m_defaultLevel;
    private static final Handler TRACE_HANDLER;
    private static volatile Handler SECONDARY_TRACE_HANDLER;
    private static final Formatter FORMATTER;
    private static String m_systemPropertyPrefix;

    public static void setSystemPropertyPrefix(String systemPropertyPrefix) {
        m_systemPropertyPrefix = systemPropertyPrefix;
    }

    public static Logger getLogger(Class aClass) {
        if (m_loggerCache.get(aClass.getName()) != null) {
            return m_loggerCache.get(aClass.getName());
        }
        Logger logger = Logger.getLogger(aClass.getName());
        if (logger.getHandlers().length != 0) {
            return logger;
        }
        logger.addHandler(TRACE_HANDLER);
        logger.setUseParentHandlers(false);
        m_loggerCache.put(aClass.getName(), logger);
        if (m_defaultLevel != null) {
            logger.setLevel(m_defaultLevel);
        } else {
            Level level = TraceLogger.getDynamicLevel(logger.getName());
            if (level != null) {
                logger.setLevel(level);
            }
        }
        return logger;
    }

    public static void injectHandler(Handler handler) {
        SECONDARY_TRACE_HANDLER = handler;
    }

    public static void removeHandler() {
        SECONDARY_TRACE_HANDLER = null;
    }

    public static Handler getSecondaryHandler() {
        return SECONDARY_TRACE_HANDLER;
    }

    public static boolean isTraceLogger(String loggerName) {
        return loggerName != null && m_loggerCache.get(loggerName) != null;
    }

    public static void setDefaultLevel(Level defaultLevel) {
        m_defaultLevel = defaultLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Level getDynamicLevel(String loggerName) {
        HashMap<String, Logger> hashMap = m_loggerCache;
        synchronized (hashMap) {
            if (m_fineLoggers == null) {
                m_fineLoggers = TraceLogger.getEnabledLoggers(m_systemPropertyPrefix + ".fine");
                m_finerLoggers = TraceLogger.getEnabledLoggers(m_systemPropertyPrefix + ".finer");
                m_finestLoggers = TraceLogger.getEnabledLoggers(m_systemPropertyPrefix + ".finest");
            }
        }
        if (TraceLogger.isDynamicallyEnabled(m_fineLoggers, loggerName)) {
            return Level.FINE;
        }
        if (TraceLogger.isDynamicallyEnabled(m_finerLoggers, loggerName)) {
            return Level.FINER;
        }
        if (TraceLogger.isDynamicallyEnabled(m_finestLoggers, loggerName)) {
            return Level.FINEST;
        }
        return null;
    }

    private static boolean isDynamicallyEnabled(String[] loggerNames, String loggerName) {
        for (String name : loggerNames) {
            if (name.equals(loggerName)) {
                return true;
            }
            if (!loggerName.startsWith(name + ".")) continue;
            return true;
        }
        return false;
    }

    private static String[] getEnabledLoggers(String propertyName) {
        ArrayList<String> enable = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(System.getProperty(propertyName, ""), ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 0) continue;
            enable.add(token);
        }
        return enable.toArray(new String[enable.size()]);
    }

    static {
        m_defaultLevel = null;
        TRACE_HANDLER = new TraceLoggerHandler();
        SECONDARY_TRACE_HANDLER = null;
        FORMATTER = new TraceLogFormatter();
        m_systemPropertyPrefix = "oracle.oc4j.trace";
    }

    static class TraceLoggerHandler
    extends Handler {
        TraceLoggerHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            System.out.println(FORMATTER.format(record));
            if (SECONDARY_TRACE_HANDLER != null) {
                SECONDARY_TRACE_HANDLER.publish(record);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

