/*
 * Decompiled with CFR 0.152.
 */
package oracle.j2ee.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.annotation.logging.MessageInfo;
import oracle.j2ee.util.LoggingUtils;

public class AnnotatedLogger {
    private Logger m_logger;
    private Map<String, Level> m_levels;

    public AnnotatedLogger(Logger logger) {
        this.m_logger = logger;
    }

    public boolean isLoggable(String messageId) {
        return this.m_logger.isLoggable(this.getLevel(messageId));
    }

    public void log(String messageId, Object ... parameters) {
        this.m_logger.log(this.getLevel(messageId), messageId, parameters);
    }

    public void logWithThrowable(String messageId, Throwable throwable, Object ... parameters) {
        Level level = this.getLevel(messageId);
        LogRecord logRecord = new LogRecord(level, messageId);
        if (this.shouldLogStackTrace(level)) {
            logRecord.setThrown(throwable);
        }
        logRecord.setParameters(parameters);
        logRecord.setLoggerName(this.m_logger.getName());
        logRecord.setResourceBundleName(this.m_logger.getResourceBundleName());
        logRecord.setResourceBundle(this.m_logger.getResourceBundle());
        this.m_logger.log(logRecord);
    }

    public void logAndEchoToConsole(String messageId, Throwable throwable, Object ... parameters) {
        this.logWithThrowable(messageId, throwable, parameters);
        System.err.println(this.getFormattedMessage(messageId, parameters));
    }

    public String getFormattedMessage(String messageId, Object ... parameters) {
        return LoggingUtils.getMessage(this.m_logger, messageId, parameters);
    }

    private boolean shouldLogStackTrace(Level level) {
        return level == Level.SEVERE || level == Level.WARNING && this.m_logger.isLoggable(Level.FINE);
    }

    private Level getLevel(String messageId) {
        Level level;
        if (this.m_levels == null) {
            this.m_levels = this.getAnnotatedLevels();
        }
        if ((level = this.m_levels.get(messageId)) == null) {
            return Level.INFO;
        }
        return level;
    }

    private Map<String, Level> getAnnotatedLevels() {
        HashMap<String, Level> annotatedLevels = new HashMap<String, Level>();
        for (Field field : this.m_logger.getResourceBundle().getClass().getFields()) {
            try {
                if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !String.class.equals(field.getType())) continue;
                String id = (String)field.get(null);
                MessageInfo messageInfo = field.getAnnotation(MessageInfo.class);
                if (messageInfo == null) continue;
                annotatedLevels.put(id, messageInfo.severity().getLevel());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return annotatedLevels;
    }
}

