/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.controls.ConnectionDetails;
import oracle.jdevimpl.db.resource.ConnBundle;

public abstract class AbstractConnectionPanelUI
extends JPanel {
    private Collection<ItemListener> m_listeners;
    private boolean m_listening;
    private ItemListener m_listener;
    private boolean m_showDetails;
    private boolean m_addButtons;
    private ConnectionInfo m_lastShownInfo;
    private String[] m_subTypes;
    private String m_noConnectionString;
    private Context m_ideContext;
    private JWrappedLabel m_promptLabel;
    private JLabel m_connectionsLabel;
    private JComboBox m_picker;
    private JPanel m_panel;
    private JButton m_btnNew;
    private JButton m_btnEdit;
    private JPanel m_detailsPanel;
    private GridBagConstraints m_detailsGBC;
    private final DBUIResourceHelper m_reshelp;

    protected AbstractConnectionPanelUI(boolean bl) {
        this((String[])null, bl);
    }

    protected AbstractConnectionPanelUI(boolean bl, boolean bl2) {
        String[] stringArray;
        if (bl) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = AbstractConnectionPanelUI.getOracleSubType();
        } else {
            stringArray = null;
        }
        this(stringArray, bl2);
    }

    protected AbstractConnectionPanelUI(String[] stringArray, boolean bl) {
        this.m_listening = true;
        this.m_listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (AbstractConnectionPanelUI.this.m_listening && itemEvent.getStateChange() == 1) {
                    AbstractConnectionPanelUI.this.fireSelectionChanged();
                }
            }
        };
        this.m_showDetails = true;
        this.m_addButtons = true;
        this.m_connectionsLabel = new JLabel();
        this.m_btnNew = new JButton(OracleIcons.getIcon((String)"add.png"));
        this.m_btnEdit = new JButton(OracleIcons.getIcon((String)"edit.png"));
        this.m_reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
        this.m_subTypes = stringArray;
        this.m_showDetails = bl;
    }

    protected String[] getSubTypes() {
        return this.m_subTypes;
    }

    public void setNoConnectionString(String string) {
        if (ModelUtil.areDifferent((Object)this.m_noConnectionString, (Object)string)) {
            this.m_noConnectionString = string;
            this.resetConnections();
        }
    }

    protected String getNoConnectionString() {
        return this.m_noConnectionString;
    }

    protected void initialise() {
        this.getPanel();
    }

    private JPanel getPanel() {
        if (this.m_panel == null) {
            this.setLayout(new BorderLayout(0, 15));
            this.m_panel = new JPanel();
            this.layoutComponents(this.m_panel);
            this.setShowDetailsImpl(this.m_showDetails);
            this.add((Component)this.m_panel, "Center");
            this.resetConnections();
            this.validate();
        }
        return this.m_panel;
    }

    protected DBUIResourceHelper getResourceHelper() {
        return this.m_reshelp;
    }

    private void layoutComponents(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0);
        jPanel.add((Component)this.m_connectionsLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        ++gridBagConstraints.gridx;
        if (this.m_addButtons) {
            this.addButtons(jPanel, gridBagConstraints);
        }
        this.m_detailsGBC = new GridBagConstraints(0, ++n, gridBagConstraints.gridx - 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 24, 0, 24), 0, 0);
        this.m_picker = this.getPicker();
        this.m_picker.addItemListener(this.m_listener);
        this.m_reshelp.setName((Component)this.m_picker, "Connection");
        jPanel.add((Component)this.m_picker, gridBagConstraints2);
        this.setConnectionLabel(ConnBundle.get("LABEL_CONNECTION"));
        jPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 10, 1, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setShowDetails(boolean bl) {
        if (this.m_panel != null && this.m_showDetails != bl) {
            this.setShowDetailsImpl(bl);
        }
        this.m_showDetails = bl;
    }

    private void setShowDetailsImpl(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().unregisterComponent(this.m_picker);
            if (this.m_detailsPanel == null) {
                this.m_detailsPanel = this.getDetailsPanel();
            }
            if (this.m_detailsPanel != null) {
                this.m_panel.add((Component)this.m_detailsPanel, this.m_detailsGBC);
            }
        } else {
            if (this.m_detailsPanel != null) {
                this.m_panel.remove(this.m_detailsPanel);
            }
            ToolTipManager.sharedInstance().registerComponent(this.m_picker);
        }
        this.repaint();
    }

    protected void addButtons(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.insets.right = 5;
        this.m_btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractConnectionPanelUI.this.launchConnectionDialog(false);
                AbstractConnectionPanelUI.this.checkFocus();
            }
        });
        this.addButton(jPanel, this.m_btnNew, gridBagConstraints, ConnBundle.get("BUTTON_NEW_TT"), ConnBundle.get("BUTTON_NEW"), "New");
        ++gridBagConstraints.gridx;
        this.m_btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractConnectionPanelUI.this.launchConnectionDialog(true);
                AbstractConnectionPanelUI.this.checkFocus();
            }
        });
        this.addButton(jPanel, this.m_btnEdit, gridBagConstraints, ConnBundle.get("BUTTON_EDIT_TT"), ConnBundle.get("BUTTON_EDIT"), "Edit");
        ++gridBagConstraints.gridx;
    }

    protected void addButton(JPanel jPanel, JButton jButton, GridBagConstraints gridBagConstraints, String string, String string2, String string3) {
        this.m_reshelp.setName((Component)jButton, string3);
        jButton.setToolTipText(string);
        if (ModelUtil.hasLength((String)string2)) {
            jButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string2));
        }
        IconicButtonUI.install((AbstractButton)jButton);
        jPanel.add((Component)jButton, gridBagConstraints);
    }

    protected JPanel getDetailsPanel() {
        ConnectionDetails connectionDetails = new ConnectionDetails();
        return connectionDetails;
    }

    protected final void checkFocus() {
        this.getDefaultFocusComponent().requestFocusInWindow();
    }

    protected void enableButtons(boolean bl) {
        if (this.getPanel().isEnabled()) {
            this.m_btnEdit.setEnabled(bl);
        }
    }

    public void enableActiveComponents(boolean bl) {
        this.m_btnNew.setEnabled(bl);
        this.m_picker.setEnabled(bl);
        if (bl) {
            this.checkConnection();
        } else {
            this.m_btnEdit.setEnabled(false);
            this.disableDetails();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.getPanel().setEnabled(bl);
        if (this.m_promptLabel != null) {
            this.m_promptLabel.setEnabled(bl);
        }
        this.m_connectionsLabel.setEnabled(bl);
        this.enableActiveComponents(bl);
    }

    public final void addComboListener(ItemListener itemListener) {
        if (itemListener != null) {
            if (this.m_listeners == null) {
                this.m_listeners = new ArrayList<ItemListener>();
            }
            if (!this.m_listeners.contains(itemListener)) {
                this.m_listeners.add(itemListener);
            }
        }
    }

    public final void removeComboListener(ItemListener itemListener) {
        if (this.m_listeners != null && itemListener != null) {
            this.m_listeners.remove(itemListener);
        }
    }

    protected final Collection<ItemListener> getListeners() {
        return this.m_listeners == null ? Collections.emptyList() : this.m_listeners;
    }

    protected boolean isListening() {
        return this.m_listening;
    }

    protected void setListening(boolean bl) {
        this.m_listening = bl;
    }

    protected final void fireSelectionChanged() {
        this.checkConnection();
        ItemEvent itemEvent = new ItemEvent(this.m_picker, 701, this.m_picker.getSelectedItem(), 1);
        for (ItemListener itemListener : this.getListeners()) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    protected void checkConnection() {
        ConnectionInfo connectionInfo = this.getConnectionInfo();
        if (this.m_addButtons) {
            this.enableButtons(connectionInfo != null && connectionInfo.isValid());
        }
        if (this.m_lastShownInfo == null || ModelUtil.areDifferent((Object)((Object)this.m_lastShownInfo), (Object)((Object)connectionInfo))) {
            this.populateDetails(connectionInfo);
            this.m_lastShownInfo = new ConnectionInfo(connectionInfo == null ? null : connectionInfo.getStoreName(), connectionInfo == null ? null : connectionInfo.getConnectionName());
        }
    }

    protected final void clearLastShownInfo() {
        this.m_lastShownInfo = null;
    }

    protected void disableDetails() {
        if (this.m_detailsPanel != null) {
            this.m_detailsPanel.setEnabled(false);
        }
    }

    protected void populateDetails(ConnectionInfo connectionInfo) {
        if (this.m_detailsPanel instanceof ConnectionDetails) {
            ((ConnectionDetails)this.m_detailsPanel).populateDetails(connectionInfo);
        } else {
            String string = ConnectionDetails.getTooltipText(connectionInfo);
            this.m_picker.setToolTipText(string);
        }
    }

    @Deprecated
    protected String getPromptText() {
        return null;
    }

    public void setConnectionLabel(String string) {
        this.initialise();
        ResourceUtils.resLabel((JLabel)this.m_connectionsLabel, (Component)this.m_picker, (String)string);
        this.validate();
    }

    public void setConnectionPrompt(String string) {
        if (ModelUtil.hasLength((String)string)) {
            this.m_promptLabel = new JWrappedLabel(string);
            this.add((Component)this.m_promptLabel, "North");
        } else if (this.m_promptLabel != null) {
            this.remove((Component)this.m_promptLabel);
            this.m_promptLabel = null;
        }
        if (this.m_panel != null) {
            this.validate();
        }
    }

    protected final Context getContext() {
        if (this.m_ideContext == null) {
            this.setContext(Context.newIdeContext());
        }
        return this.m_ideContext;
    }

    public void setContext(Context context) {
        this.m_ideContext = context;
    }

    public void setAddButtons(boolean bl) {
        this.m_addButtons = bl;
    }

    public Component getDefaultFocusComponent() {
        this.initialise();
        JComponent jComponent = this.m_btnNew;
        if (this.m_picker.getItemCount() > 0) {
            jComponent = this.m_picker;
        }
        return jComponent;
    }

    protected abstract String getComponentNamePrefix();

    public abstract ConnectionInfo getConnectionInfo();

    public abstract void setConnectionInfo(ConnectionInfo var1);

    public abstract int resetConnections();

    protected abstract JComboBox getPicker();

    protected abstract void launchConnectionDialog(boolean var1);

    public static String getOracleSubType() {
        return "oraJDBC";
    }

    public static ConnectionInfo getConnection(final AbstractConnectionPanelUI abstractConnectionPanelUI, String string, ConnectionInfo connectionInfo) {
        HelpSystem.getHelpSystem().registerTopic((JComponent)abstractConnectionPanelUI, "f1_odbselectconnection_html");
        final JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)abstractConnectionPanelUI, (Component)abstractConnectionPanelUI.getDefaultFocusComponent(), (String)string);
        if (connectionInfo != null) {
            abstractConnectionPanelUI.setConnectionInfo(connectionInfo);
        }
        if (abstractConnectionPanelUI.getNoConnectionString() == null) {
            abstractConnectionPanelUI.addComboListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ConnectionInfo connectionInfo = abstractConnectionPanelUI.getConnectionInfo();
                    jEWTDialog.setOKButtonEnabled(connectionInfo != null && connectionInfo.isValid());
                }
            });
            ConnectionInfo connectionInfo2 = abstractConnectionPanelUI.getConnectionInfo();
            jEWTDialog.setOKButtonEnabled(connectionInfo2 != null && connectionInfo2.isValid());
        }
        jEWTDialog.setMinimumSize(new Dimension(400, 200));
        jEWTDialog.setName(abstractConnectionPanelUI.getComponentNamePrefix() + "Dialog");
        return WizardLauncher.runDialog((JDialog)jEWTDialog) ? abstractConnectionPanelUI.getConnectionInfo() : null;
    }

    @Override
    public void addNotify() {
        this.initialise();
        super.addNotify();
    }
}

