/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.topicDisplay.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import oracle.bali.ewt.plaf.UIUtils;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.topicDisplay.BrowserTopicDisplay;

public class HTMLPopupWindow
extends JComponent
implements URLListener,
ProtocolListener {
    public static double COMPONENT_PERCENTAGE = 0.8;
    public static double GOLDEN_RATIO = 1.618;
    public static double ACCEPTABLE_DIFFERENCE = 0.2;
    public static double MAX_ATTEMPT_COUNT = 5.0;
    public static int BROWSER_MINIMUM_WIDTH = 105;
    public static int SCROLLBAR_SIZE = 8;
    private JComponent _overComponent;
    private Component _glassPane;
    private JRootPane _rootPane;
    private JLayeredPane _layeredPane;
    private HTMLBrowser _popupBrowser;
    private Component _popupComponent;
    private Window _parentWindow;
    private PopupMouseListener _popupMouseListener;
    private PopupKeyListener _popupKeyListener;
    private PopupWindowListener _popupWindowListener;
    private BrowserTopicDisplay _parentDisplay;

    public HTMLPopupWindow(BrowserTopicDisplay parentDisplay, Class htmlBrowserClass, URL url, Point where, JComponent over) {
        this._parentDisplay = parentDisplay;
        this._overComponent = over;
        this._rootPane = over.getRootPane();
        this._layeredPane = this._rootPane.getLayeredPane();
        this._glassPane = this._rootPane.getGlassPane();
        this._popupComponent = this;
        this._parentWindow = this._parentWindow(over);
        this._popupBrowser = null;
        try {
            this._popupBrowser = (HTMLBrowser)htmlBrowserClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create instance of HTMLBrowser for HTML Popup Window");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this._popupBrowser.getHTMLContainer(), "Center");
        this.setBackground(UIManager.getColor("ToolTip.background"));
        this.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.setBorder(UIManager.getBorder("ToolTip.border"));
        int bestWidth = 0;
        int bestHeight = 0;
        double bestRatio = Double.MAX_VALUE;
        int count = 0;
        boolean done = false;
        double maxMult = 1.0;
        double minMult = 0.0;
        double currentMult = 1.0;
        Dimension componentSize = over.getSize();
        Dimension maximumSize = new Dimension();
        maximumSize.width = (int)((double)componentSize.width * COMPONENT_PERCENTAGE);
        maximumSize.height = (int)((double)componentSize.height * COMPONENT_PERCENTAGE);
        Dimension renderedSize = new Dimension();
        Dimension minimumSize = new Dimension();
        this._layeredPane.add((Component)this, JLayeredPane.POPUP_LAYER);
        this.validate();
        this._popupBrowser.setURL(url, true);
        renderedSize = this._popupBrowser.getCurrentRenderedSize();
        minimumSize.width = renderedSize.width;
        if (minimumSize.width < BROWSER_MINIMUM_WIDTH) {
            minimumSize.width = BROWSER_MINIMUM_WIDTH;
        }
        if (minimumSize.width > maximumSize.width) {
            minimumSize.width = maximumSize.width;
        }
        this.setSize(maximumSize.width, 20);
        this.validate();
        renderedSize = this._popupBrowser.getCurrentRenderedSize();
        minimumSize.height = renderedSize.height;
        if (minimumSize.height > maximumSize.height) {
            minimumSize.height = maximumSize.height;
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (maximumSize.width > screenSize.width / 2) {
            currentMult = 0.5;
        }
        while (!done) {
            int attemptWidth = (int)((double)maximumSize.width * currentMult);
            ++count;
            if (attemptWidth < minimumSize.width) {
                attemptWidth = minimumSize.width;
            }
            this.setSize(attemptWidth, minimumSize.height);
            this.validate();
            renderedSize = this._popupBrowser.getCurrentRenderedSize();
            int attemptHeight = renderedSize.height > maximumSize.height ? maximumSize.height : renderedSize.height;
            double attemptRatio = 1.0 * (double)attemptWidth / (double)attemptHeight;
            if (Math.abs(attemptRatio - GOLDEN_RATIO) < Math.abs(bestRatio - GOLDEN_RATIO)) {
                bestRatio = attemptRatio;
                bestWidth = attemptWidth;
                bestHeight = attemptHeight;
            }
            if ((double)count == MAX_ATTEMPT_COUNT || Math.abs(bestRatio - GOLDEN_RATIO) < ACCEPTABLE_DIFFERENCE) {
                done = true;
                continue;
            }
            if (attemptRatio > GOLDEN_RATIO) {
                maxMult = currentMult;
            } else if (attemptWidth == maximumSize.width) {
                done = true;
            } else {
                minMult = currentMult;
            }
            currentMult = (maxMult + minMult) / 2.0;
        }
        this.setSize(bestWidth + SCROLLBAR_SIZE, bestHeight + SCROLLBAR_SIZE);
        Point overCompLocation = this._translatePoint(this._overComponent.getParent(), this._parentWindow, this._overComponent.getLocation().x, this._overComponent.getLocation().y);
        this.setLocation(overCompLocation.x + (componentSize.width - bestWidth) / 2, overCompLocation.y + (componentSize.height - bestHeight) / 2);
        this.validate();
        this._popupBrowser.setDefaultBackground(UIManager.getColor("ToolTip.background"));
        this._popupKeyListener = new PopupKeyListener();
        this._manageKeyListeners(true, this._popupKeyListener, this._parentWindow);
        this._popupMouseListener = new PopupMouseListener();
        this._manageMouseListeners(true, this._popupMouseListener, this._parentWindow);
        this._popupWindowListener = new PopupWindowListener();
        this._parentWindow.addWindowListener(this._popupWindowListener);
        this._popupBrowser.addURLListener(this);
        this._popupBrowser.addProtocolListener(this);
    }

    @Override
    public void urlChanged(URLEvent event) {
        if (event != null && event.getID() == 2000) {
            this.dispose();
            this._parentDisplay.setBrowserURL(event.getURL());
        }
    }

    @Override
    public void anchorChanged(URLEvent event) {
    }

    @Override
    public void protocolReceived(ProtocolEvent event) {
        if (event != null) {
            this.dispose();
            this._parentDisplay.protocolReceived(event);
        }
    }

    public synchronized void dispose() {
        if (this.isVisible()) {
            this.setVisible(false);
            this._manageMouseListeners(false, this._popupMouseListener, this._parentWindow);
            this._manageKeyListeners(false, this._popupKeyListener, this._parentWindow);
            this._parentWindow.removeWindowListener(this._popupWindowListener);
            this._layeredPane.remove(this);
            this._popupBrowser.dispose();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        UIUtils.fillBackground((Graphics)g, (JComponent)this);
    }

    private void _manageKeyListeners(boolean add, KeyListener keyListener, Component comp) {
        Component[] children;
        if (add) {
            comp.addKeyListener(keyListener);
        } else {
            comp.removeKeyListener(keyListener);
        }
        if (comp instanceof Container && (children = ((Container)comp).getComponents()) != null) {
            for (int i = 0; i < children.length; ++i) {
                this._manageKeyListeners(add, keyListener, children[i]);
            }
        }
    }

    private void _manageMouseListeners(boolean add, MouseListener mouseListener, Component comp) {
        Component[] children;
        if (add) {
            comp.addMouseListener(mouseListener);
        } else {
            comp.removeMouseListener(mouseListener);
        }
        if (comp instanceof Container && (children = ((Container)comp).getComponents()) != null) {
            for (int i = 0; i < children.length; ++i) {
                this._manageMouseListeners(add, mouseListener, children[i]);
            }
        }
    }

    private boolean _componentInSubTree(Component root, Component testChild) {
        Component[] children;
        if (root == testChild) {
            return true;
        }
        if (root instanceof Container && (children = ((Container)root).getComponents()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (!this._componentInSubTree(children[i], testChild)) continue;
                return true;
            }
        }
        return false;
    }

    private Window _parentWindow(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private Point _translatePoint(Component from, Component to, int x, int y) {
        while (from != to) {
            Point location = from.getLocation();
            x += location.x;
            y += location.y;
            from = from.getParent();
        }
        return new Point(x, y);
    }

    private class PopupKeyListener
    extends KeyAdapter {
        private PopupKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getSource() != HTMLPopupWindow.this._parentWindow && !HTMLPopupWindow.this._componentInSubTree(HTMLPopupWindow.this._popupComponent, (Component)e.getSource())) {
                HTMLPopupWindow.this.dispose();
            }
        }
    }

    private class PopupMouseListener
    extends MouseAdapter {
        private PopupMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!HTMLPopupWindow.this._componentInSubTree(HTMLPopupWindow.this._popupComponent, (Component)e.getSource())) {
                HTMLPopupWindow.this.dispose();
            }
        }
    }

    private class PopupWindowListener
    extends WindowAdapter {
        private PopupWindowListener() {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            HTMLPopupWindow.this.dispose();
        }
    }
}

