/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import oracle.help.common.util.java.StaticLocaleContext;

public class Version {
    public static final String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    public static final String VERSION_START = "version.start";
    public static final String LEVEL = "version.production";
    public static final int MAJORVER = 5;
    public static final int MINORVER = 0;
    public static final int FREEZE = 0;

    public static String getVersion() {
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        StringBuffer version = new StringBuffer();
        version.append(bundle.getString(VERSION_START));
        version.append(" ");
        version.append(5);
        version.append(".");
        version.append(0);
        version.append(".");
        version.append(0);
        String labelNumber = Version.getLabelNumber();
        if (labelNumber != null) {
            version.append(".");
            version.append(labelNumber);
        }
        version.append(" ");
        version.append(bundle.getString(LEVEL));
        return version.toString();
    }

    public static String getLabelNumber() {
        String labelNumber = null;
        try {
            String[] parts;
            String implementationVersion = Version.class.getPackage().getImplementationVersion();
            if (implementationVersion != null && (parts = implementationVersion.split("\\.")).length >= 3) {
                labelNumber = parts[parts.length - 1];
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return labelNumber;
    }

    public static String getImplementationVersionYear() {
        Object year = null;
        try {
            String interestingPart;
            String[] parts;
            String implementationVersion = Version.class.getPackage().getImplementationVersion();
            if (implementationVersion != null && (parts = implementationVersion.split("\\.")).length >= 3 && (interestingPart = parts[parts.length - 3]).length() > 6) {
                String date = interestingPart.substring(interestingPart.length() - 6);
                year = "20" + date.substring(0, 2);
            }
        }
        catch (RuntimeException e) {
            year = null;
        }
        if (year == null) {
            Integer yearNumber = new GregorianCalendar().get(1);
            year = yearNumber.toString();
        }
        return year;
    }
}

