/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.Search;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.StormBase;
import ice.storm.StormLocaleUtils;
import ice.storm.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.FindSupport;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ICEToolTipManager;
import oracle.help.htmlBrowser.PopupEvent;
import oracle.help.htmlBrowser.PopupListener;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.htmlBrowser.find.FindDialog;
import oracle.help.htmlBrowser.print.ICEPrintImpl;
import oracle.help.htmlBrowser.print.ICEPrintImplJava2;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class ICEBrowser
extends JPanel
implements HTMLBrowser,
PropertyChangeListener {
    private static String PROPERTY_LOCATION = "location";
    private static String PROPERTY_PILOT_LOADING = "pilotLoading";
    private static String PROPERTY_CONTENT_LOADING = "contentLoading";
    private static String PROPERTY_CONTENT_RENDERING = "contentRendering";
    private static String MAIN_VIEWPORT_NAME = "main_viewport";
    private static String PILOT_TOOLKIT_NAME = "swing";
    private static String LOADING_CONNECT = "connect";
    private static String LOADING_BEGIN = "begin";
    private static String LOADING_END = "end";
    private static String LOADING_ERROR = "error";
    private static String RENDERING_BEGIN = "begin";
    private static String RENDERING_END = "end";
    private static String PILOT_BEGIN = "begin";
    private static String PILOT_END = "end";
    private static String PILOT_ERROR = "error";
    private AnchorListener _ANCHOR_LISTENER = new AnchorListener();
    private ICEFindSupport _findSupport = new ICEFindSupport();
    private String _queuedBackgroundColor = null;
    private String _queuedTextColor = null;
    private String _queuedLinkColor = null;
    private String _pilotEncoding = null;
    private URL _currentLocation;
    private String _loadingStatus;
    private String _renderingStatus;
    private String _pilotStatus;
    private ListenerManager _urlListeners;
    private ListenerManager _popupListeners;
    private ListenerManager _protocolListeners;
    private StormBase _iceStorm = new DeferringStormBase();

    public ICEBrowser() {
        this._iceStorm.setComponentToolkitName(PILOT_TOOLKIT_NAME);
        this._iceStorm.setContainer((Container)this, MAIN_VIEWPORT_NAME);
        this._iceStorm.addPropertyChangeListener((PropertyChangeListener)this, MAIN_VIEWPORT_NAME);
        this._iceStorm.clearContent("text/html", MAIN_VIEWPORT_NAME);
        this._currentLocation = null;
        this._loadingStatus = null;
        this._renderingStatus = null;
    }

    @Override
    public void setURL(URL url) {
        this._renderContent(url);
    }

    @Override
    public void setURL(URL url, boolean waitForRendering) {
        if (waitForRendering) {
            this._renderContentAndWait(url);
        } else {
            this._renderContent(url);
        }
    }

    @Override
    public void clear() {
        this._iceStorm.clearContent("text/html", MAIN_VIEWPORT_NAME);
    }

    @Override
    public Printable getPrintable(URL[] urls) {
        return this._getICEPrintImpl().getPrintable(urls);
    }

    @Override
    public URL getURL() {
        return this._currentLocation;
    }

    @Override
    public void reloadURL() {
        this._iceStorm.clearContent(null, MAIN_VIEWPORT_NAME);
        this._renderContent(this._currentLocation);
    }

    @Override
    public boolean isPrintingSupported() {
        return true;
    }

    @Override
    public void printURL(URL url) {
        this._getICEPrintImpl().printURL(url);
    }

    @Override
    public void printURLs(URL[] urls) {
        this._getICEPrintImpl().printURLs(urls);
    }

    @Override
    public JPanel getHTMLContainer() {
        return this;
    }

    @Override
    public Dimension getCurrentRenderedSize() {
        Dimension docSize = new Dimension();
        try {
            ThePilot pilot = this._getThePilot();
            docSize = pilot != null ? pilot.getDocumentDimension(docSize) : null;
        }
        catch (Exception e) {
            docSize = null;
        }
        return docSize;
    }

    @Override
    public void addURLListener(URLListener listener) {
        if (this._urlListeners == null) {
            this._urlListeners = new ListenerManager();
        }
        this._urlListeners.addListener((java.util.EventListener)listener);
    }

    @Override
    public void removeURLListener(URLListener listener) {
        if (this._urlListeners != null) {
            this._urlListeners.removeListener((java.util.EventListener)listener);
        }
    }

    @Override
    public void addPopupListener(PopupListener listener) {
        if (this._popupListeners == null) {
            this._popupListeners = new ListenerManager();
        }
        this._popupListeners.addListener((java.util.EventListener)listener);
    }

    @Override
    public void removePopupListener(PopupListener listener) {
        if (this._popupListeners != null) {
            this._popupListeners.removeListener((java.util.EventListener)listener);
        }
    }

    @Override
    public FindSupport getFindSupport() {
        return this._findSupport;
    }

    @Override
    public void runFindDialog() {
        ThePilot pilot = this._getThePilot();
        if (pilot != null) {
            FindDialog.createFindDialog(this, this.getFindSupport());
        } else {
            System.err.println("Search cannot be executed");
        }
    }

    @Override
    public String getCharset() {
        String charSet = null;
        ThePilot pilot = this._getThePilot();
        if (pilot != null) {
            charSet = pilot.getEncoding();
        }
        if (charSet == null) {
            charSet = this._pilotEncoding;
        }
        return charSet;
    }

    @Override
    public void setCharset(String charset) {
        if (charset != null) {
            ThePilot pilot = this._getThePilot();
            if (pilot != null) {
                pilot.setEncoding(charset);
                this.reloadURL();
            }
            this._pilotEncoding = charset;
        }
    }

    @Override
    public Locale getLocale() {
        return StormLocaleUtils.getLocale();
    }

    @Override
    public void setLocale(Locale aLocale) {
        StormLocaleUtils.setLocale((Locale)aLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        URLEvent dispatchEvent = null;
        boolean registerPilotListeners = false;
        ICEBrowser iCEBrowser = this;
        synchronized (iCEBrowser) {
            if (PROPERTY_LOCATION.equals(property)) {
                try {
                    this._currentLocation = new URL((String)e.getNewValue());
                    dispatchEvent = new URLEvent(this, 2000, this._currentLocation);
                }
                catch (Exception urlEx) {
                    this._currentLocation = null;
                }
            } else if (PROPERTY_CONTENT_LOADING.equals(property)) {
                this._loadingStatus = (String)e.getNewValue();
                if (LOADING_ERROR.equals(this._loadingStatus) || LOADING_END.equals(this._loadingStatus)) {
                    if (LOADING_END.equals(this._loadingStatus)) {
                        if (this._queuedBackgroundColor != null) {
                            this._setBackgroundColorNow(this._queuedBackgroundColor);
                        }
                        if (this._queuedTextColor != null) {
                            this._setTextColorNow(this._queuedTextColor);
                        }
                        if (this._queuedLinkColor != null) {
                            this._setLinkColorNow(this._queuedLinkColor);
                        }
                    }
                    this._queuedBackgroundColor = null;
                    this._queuedTextColor = null;
                    this._queuedLinkColor = null;
                }
            } else if (PROPERTY_CONTENT_RENDERING.equals(property)) {
                this._renderingStatus = (String)e.getNewValue();
            } else if (PROPERTY_PILOT_LOADING.equals(property)) {
                this._pilotStatus = (String)e.getNewValue();
                if (PILOT_END.equals(this._pilotStatus)) {
                    registerPilotListeners = true;
                    if (this._pilotEncoding != null) {
                        this.setCharset(this._pilotEncoding);
                    }
                }
            }
        }
        if (dispatchEvent != null) {
            this._findSupport.clearSearch();
            this._dispatchURLEvent(dispatchEvent);
        }
        if (registerPilotListeners) {
            this._registerPilotListeners();
        }
    }

    @Override
    public synchronized void setDefaultBackground(Color bgcolor) {
        if (bgcolor != null && !LOADING_ERROR.equals(this._loadingStatus)) {
            if (!LOADING_END.equals(this._loadingStatus)) {
                this._queuedBackgroundColor = this._colorToString(bgcolor);
            } else {
                this._setBackgroundColorNow(this._colorToString(bgcolor));
            }
        }
    }

    @Override
    public synchronized void setDefaultTextForeground(Color textfg) {
        if (textfg != null && !LOADING_ERROR.equals(this._loadingStatus)) {
            if (!LOADING_END.equals(this._loadingStatus)) {
                this._queuedTextColor = this._colorToString(textfg);
            } else {
                this._setTextColorNow(this._colorToString(textfg));
            }
        }
    }

    @Override
    public synchronized void setDefaultLinkForeground(Color linkfg) {
        if (linkfg != null && !LOADING_ERROR.equals(this._loadingStatus)) {
            if (!LOADING_END.equals(this._loadingStatus)) {
                this._queuedLinkColor = this._colorToString(linkfg);
            } else {
                this._setLinkColorNow(this._colorToString(linkfg));
            }
        }
    }

    @Override
    public void addProtocolListener(ProtocolListener listener) {
        if (this._protocolListeners == null) {
            this._protocolListeners = new ListenerManager();
        }
        this._protocolListeners.addListener((java.util.EventListener)listener);
    }

    @Override
    public void removeProtocolListener(ProtocolListener listener) {
        if (this._protocolListeners != null) {
            this._protocolListeners.removeListener((java.util.EventListener)listener);
        }
    }

    @Override
    public boolean canGoBack() {
        return this._iceStorm.getHistoryManager().canGoBack(MAIN_VIEWPORT_NAME);
    }

    @Override
    public void goBack() {
        this._iceStorm.getHistoryManager().goBack(MAIN_VIEWPORT_NAME);
    }

    @Override
    public boolean canGoForward() {
        return this._iceStorm.getHistoryManager().canGoForward(MAIN_VIEWPORT_NAME);
    }

    @Override
    public void goForward() {
        this._iceStorm.getHistoryManager().goForward(MAIN_VIEWPORT_NAME);
    }

    @Override
    public String getSelectedText() {
        ThePilot pilot = this._getThePilot();
        if (pilot != null) {
            return pilot.getSelectedText();
        }
        return null;
    }

    @Override
    public void increaseFontSize() {
        this._changeZoom(16);
    }

    @Override
    public void decreaseFontSize() {
        this._changeZoom(-16);
    }

    @Override
    public void selectAll() {
        ThePilot pilot = this._getThePilot();
        if (pilot != null) {
            pilot.getSearch().selectAll();
        }
    }

    @Override
    public String getCurrentPageTitle() {
        String title = null;
        DDocument document = this._getDDocument();
        if (document != null) {
            title = document.getTitle();
        }
        if (title == null) {
            try {
                ResourceBundle miscBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle", StaticLocaleContext.getLocale());
                title = miscBundle.getString("icebrowser.untitleddocument");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return title;
    }

    private void _changeZoom(int factor) {
        Viewport view = this._iceStorm.findViewportByName(MAIN_VIEWPORT_NAME);
        view.setZoom(view.getZoom() + factor);
    }

    private ICEPrintImpl _getICEPrintImpl() {
        Frame parentFrame = WindowUtils.parentFrame((Component)this);
        if (parentFrame == null) {
            parentFrame = new Frame("Printing Frame");
        }
        return new ICEPrintImplJava2(this._iceStorm, MAIN_VIEWPORT_NAME, parentFrame);
    }

    private void _dispatchURLEvent(URLEvent event) {
        Enumeration e;
        if (this._urlListeners != null && (e = this._urlListeners.getListeners()) != null) {
            while (e.hasMoreElements()) {
                URLListener listener = (URLListener)e.nextElement();
                if (event.getID() == 2000) {
                    listener.urlChanged(event);
                    continue;
                }
                if (event.getID() != 2001) continue;
                listener.anchorChanged(event);
            }
        }
    }

    private void _dispatchPopupEvent(PopupEvent event) {
        Enumeration e;
        if (this._popupListeners != null && (e = this._popupListeners.getListeners()) != null) {
            while (e.hasMoreElements()) {
                PopupListener listener = (PopupListener)e.nextElement();
                listener.showPopup(event);
            }
        }
    }

    private void _fireProtocolEvent(ProtocolEvent event) {
        Enumeration e;
        if (this._protocolListeners != null && (e = this._protocolListeners.getListeners()) != null) {
            while (e.hasMoreElements()) {
                ProtocolListener listener = (ProtocolListener)e.nextElement();
                listener.protocolReceived(event);
            }
        }
    }

    @Override
    public void dispose() {
        this._iceStorm.dispose();
        this._popupListeners = null;
        this._protocolListeners = null;
        this._urlListeners = null;
        this._iceStorm = null;
    }

    private void _registerPilotListeners() {
        ThePilot pilot = this._getThePilot();
        if (pilot != null) {
            ICEToolTipManager toolTipManager = new ICEToolTipManager(this);
            try {
                toolTipManager.registerToolTipListeners(pilot);
                pilot.addPersistentDOMEventListener("goto", (EventListener)this._ANCHOR_LISTENER, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void _renderContent(URL url) {
        if (url != null) {
            ContentLoader loader = new ContentLoader(url, null);
            this._iceStorm.renderContent(loader, MAIN_VIEWPORT_NAME);
        }
    }

    private void _renderContentAndWait(URL url) {
        if (url != null) {
            ContentLoader loader = new ContentLoader(url, null);
            this._iceStorm.renderContentFully(loader, MAIN_VIEWPORT_NAME);
        }
    }

    private String _colorToString(Color c) {
        String colorString = null;
        if (c != null) {
            colorString = "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
        }
        return colorString;
    }

    private void _setBackgroundColorNow(String bgcolor) {
        try {
            DDocument document = this._getDDocument();
            if (document != null) {
                document.setBgColor(bgcolor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setTextColorNow(String textfg) {
        try {
            DDocument document = this._getDDocument();
            if (document != null) {
                document.setFgColor(textfg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setLinkColorNow(String linkfg) {
        try {
            DDocument document = this._getDDocument();
            if (document != null) {
                document.setLinkColor(linkfg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ThePilot _getThePilot() {
        Viewport view = this._iceStorm.findViewportByName(MAIN_VIEWPORT_NAME);
        if (view != null) {
            return (ThePilot)view.getPilot();
        }
        return null;
    }

    private DDocument _getDDocument() {
        ThePilot pilot = this._getThePilot();
        if (pilot != null) {
            return pilot.getDDocument();
        }
        return null;
    }

    private class AnchorListener
    implements EventListener {
        private AnchorListener() {
        }

        @Override
        public void handleEvent(Event e) {
            Node target;
            DOMEvent domEvent;
            if (e instanceof DOMEvent && 30 == (domEvent = (DOMEvent)e).getTypeId() && (target = (Node)((Object)domEvent.getTarget())).getNodeType() == 1) {
                String anchorName = ((Element)target).getAttribute("name");
                URLEvent event = new URLEvent(this, 2001, ICEBrowser.this._currentLocation, anchorName);
                ICEBrowser.this._dispatchURLEvent(event);
            }
        }
    }

    private class ICEFindSupport
    extends FindSupport {
        private Search _search;

        @Override
        public boolean findNext() {
            Search search = this.getSearch(true);
            if (search != null) {
                return search.findNext();
            }
            return false;
        }

        @Override
        public boolean findPrevious() {
            Search search = this.getSearch(true);
            if (search != null) {
                return search.findPrevious();
            }
            return false;
        }

        @Override
        public void reset() {
            Search search = this.getSearch(true);
            if (search != null) {
                search.dispose();
            }
        }

        @Override
        protected void onSearchStringChange(String oldSearchString, String newSearchString) {
            Search search = this.getSearch(false);
            if (search != null) {
                search.setSearchText(newSearchString);
            }
        }

        @Override
        protected void onCaseSensitiveChange(boolean newCaseSensitive) {
            Search search = this.getSearch(false);
            if (search != null) {
                search.setMatchCase(newCaseSensitive);
            }
        }

        protected synchronized void clearSearch() {
            this._search = null;
        }

        private synchronized Search getSearch(boolean createIfNeeded) {
            ThePilot pilot;
            if (this._search == null && createIfNeeded && (pilot = ICEBrowser.this._getThePilot()) != null) {
                this._search = pilot.getSearch();
                this._search.setSearchText(this.getSearchString());
                this._search.setMatchCase(this.isCaseSensitive());
            }
            return this._search;
        }
    }

    private class DeferringStormBase
    extends StormBase {
        private DeferringStormBase() {
        }

        public void renderContent(ContentLoader cl, String viewportName) {
            boolean ohjProtocol = this._captureOHJProtocol(cl.getLocation());
            if (!ohjProtocol) {
                super.renderContent(cl, viewportName);
            }
        }

        public void renderContent(String loc, String contentType, String viewportName) {
            boolean ohjProtocol = this._captureOHJProtocol(loc);
            if (!ohjProtocol) {
                super.renderContent(loc, contentType, viewportName);
            }
        }

        public void renderContentFully(ContentLoader cl, String viewportName) {
            boolean ohjProtocol = this._captureOHJProtocol(cl.getLocation());
            if (!ohjProtocol) {
                super.renderContentFully(cl, viewportName);
            }
        }

        private boolean _captureOHJProtocol(String link) {
            boolean handled = false;
            if (link != null) {
                if (link.toLowerCase().startsWith("alink:")) {
                    String linkId = link.substring(link.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2000, linkId, null));
                    handled = true;
                } else if (link.toLowerCase().startsWith("popup:")) {
                    String linkId = link.substring(link.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2001, linkId, null));
                    handled = true;
                } else if (link.toLowerCase().startsWith("topicid:")) {
                    String linkId = link.substring(link.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2002, linkId, null));
                    handled = true;
                } else if (link.toLowerCase().startsWith("custom:")) {
                    String linkId = link.substring(link.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2003, linkId, null));
                    handled = true;
                }
            }
            return handled;
        }
    }
}

