/*
 * Decompiled with CFR 0.152.
 */
package oracle.help;

import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.help.Help;
import oracle.help.library.Book;
import oracle.help.navigator.Navigator;

public class CSHManager {
    private static String GENERIC_RESOURCE_BUNDLE = "oracle.help.resource.Generic";
    private static String POPUP_TEXT = "cshmanager.popuptext";
    private Help _help;
    private String _popupText;
    private Book _defaultBook;
    private Hashtable _topicTable;
    private HelpKeyListener _helpKeyListener;
    private HelpMouseListener _helpMouseListener;

    public CSHManager(Help help) {
        ResourceBundle bundle = ResourceBundle.getBundle(GENERIC_RESOURCE_BUNDLE, Help.getHelpLocale());
        this._popupText = bundle.getString(POPUP_TEXT);
        this._help = help;
        this._helpKeyListener = new HelpKeyListener();
        this._helpMouseListener = new HelpMouseListener();
        this._topicTable = new Hashtable();
    }

    public void setDefaultBook(Book book) {
        this._defaultBook = book;
    }

    public void addBook(Book book, boolean isDefault) {
        this._help.addBook(book);
        if (isDefault) {
            this._defaultBook = book;
        }
    }

    public void removeBook(Book book) {
        this._help.removeBook(book);
    }

    public void showNavigatorWindow() {
        this._help.showNavigatorWindow();
    }

    public void showNavigatorWindow(Navigator activeNavigator) {
        if (activeNavigator != null) {
            this._help.showNavigatorWindow(activeNavigator);
        }
    }

    public void showNavigatorWindow(Book activeBook) {
        this._help.showNavigatorWindow(activeBook);
    }

    public Navigator[] getAllNavigators() {
        return this._help.getAllNavigators();
    }

    public void addComponent(Component component, String topicId) {
        if (this._defaultBook != null) {
            this.addComponent(component, this._defaultBook, topicId);
        }
    }

    public void addComponent(Component component, Book book, String topicId) {
        this.addComponent(component, book, topicId, false, false);
    }

    public void addComponent(Component component, String topicId, boolean needF1Help, boolean needPopupHelp) {
        if (this._defaultBook != null) {
            this.addComponent(component, this._defaultBook, topicId, needF1Help, needPopupHelp);
        }
    }

    public void addComponent(Component component, Book book, String topicId, boolean needF1Help, boolean needPopupHelp) {
        TopicInfo info;
        if (needF1Help) {
            component.addKeyListener(this._helpKeyListener);
        }
        if (needPopupHelp) {
            component.addMouseListener(this._helpMouseListener);
        }
        if ((info = (TopicInfo)this._topicTable.get(component)) != null) {
            this._topicTable.remove(component);
        }
        this._topicTable.put(component, new TopicInfo(book, topicId));
    }

    public void removeComponent(Component component) {
        if (component != null) {
            try {
                component.removeKeyListener(this._helpKeyListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                component.removeMouseListener(this._helpMouseListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._topicTable.remove(component);
        }
    }

    public void showHelpForComponent(Component component) {
        TopicInfo topicInfo = this._findTopicInfo(component);
        if (topicInfo != null) {
            this._help.showTopic(topicInfo.book, topicInfo.topicId);
        }
    }

    public void showTopic(String topicId) {
        this._help.showTopic(this._defaultBook, topicId);
    }

    protected Help getHelpObject() {
        return this._help;
    }

    private TopicInfo _findTopicInfo(Component component) {
        if (component == null) {
            return null;
        }
        TopicInfo foundInfo = (TopicInfo)this._topicTable.get(component);
        if (foundInfo != null) {
            return foundInfo;
        }
        return this._findTopicInfo(component.getParent());
    }

    private class HelpKeyListener
    extends KeyAdapter {
        private HelpKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!e.isConsumed() && e.getKeyCode() == 112) {
                CSHManager.this.showHelpForComponent((Component)e.getSource());
                e.consume();
            }
        }
    }

    private class HelpMouseListener
    extends MouseAdapter
    implements ActionListener {
        private PopupMenu _popup;
        private Component _component;

        public HelpMouseListener() {
            MenuItem item = new MenuItem(CSHManager.this._popupText);
            item.addActionListener(this);
            this._popup = new PopupMenu();
            this._popup.add(item);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._component = (Component)e.getSource();
                if (this._popup.getParent() != null) {
                    this._popup.getParent().remove(this._popup);
                }
                this._component.add(this._popup);
                this._popup.addNotify();
                this._popup.show(this._component, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._component = (Component)e.getSource();
                if (this._popup.getParent() != null) {
                    this._popup.getParent().remove(this._popup);
                }
                this._component.add(this._popup);
                this._popup.addNotify();
                this._popup.show(this._component, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this._component = (Component)e.getSource();
                if (this._popup.getParent() != null) {
                    this._popup.getParent().remove(this._popup);
                }
                this._component.add(this._popup);
                this._popup.addNotify();
                this._popup.show(this._component, e.getX(), e.getY());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CSHManager.this.showHelpForComponent(this._component);
            this._popup.getParent().remove(this._popup);
        }
    }

    private class TopicInfo {
        public Book book;
        public String topicId;

        public TopicInfo(Book book, String topicId) {
            this.book = book;
            this.topicId = topicId;
        }
    }
}

