/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedDialog;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.WindowUtils;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.WizardAdapter;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;

public class WizardDialog
extends BufferedDialog {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private Dimension _preferred;
    private WizardListener _listener;
    private Component _centerOver;
    private static final int _BORDER_INSET = 13;
    private static final BorderPainter _sBorderPainter = new FixedBorderPainter(13, 13, 13, 13);

    public WizardDialog(BaseWizard baseWizard) {
        this(baseWizard, null, true);
    }

    public WizardDialog(BaseWizard baseWizard, Frame frame) {
        this(baseWizard, frame, true);
    }

    public WizardDialog(BaseWizard baseWizard, Frame frame, boolean bl) {
        super(frame, "", bl);
        this._wizard = baseWizard;
        this._listener = new WizListener();
        this.enableEvents(64L);
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setPreferredSize(int n, int n2) {
        this._preferred = new Dimension(n, n2);
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public boolean runDialog() {
        Component component;
        BaseWizard baseWizard = this._wizard;
        if (this.isVisible() || baseWizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this.add((Component)baseWizard, "Center");
        baseWizard.addWizardListener(this._listener);
        this.pack();
        if (this._preferred != null) {
            this.setSize(this._preferred);
        }
        if ((component = this.getCenterOver()) == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow(this, component);
        this._cancelled = false;
        this.setVisible(true);
        if (this.isModal()) {
            baseWizard.removeWizardListener(this._listener);
            this.remove(baseWizard);
        }
        return !this._cancelled;
    }

    @Override
    public BorderPainter getBorderPainter() {
        return _sBorderPainter;
    }

    protected void dismissDialog(boolean bl) {
        this._cancelled = bl;
        this.setVisible(false);
        if (!this.isModal()) {
            this._wizard.removeWizardListener(this._listener);
            this.remove(this._wizard);
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        PushButton pushButton;
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201 && (pushButton = this._wizard._cancel).isEnabled()) {
            pushButton.simulatePush();
        }
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        @Override
        public void wizardFinished(WizardEvent wizardEvent) {
            WizardDialog.this.dismissDialog(false);
        }

        @Override
        public void wizardCanceled(WizardEvent wizardEvent) {
            WizardDialog.this.dismissDialog(true);
        }
    }
}

