/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.undo;

import java.util.Enumeration;
import java.util.Vector;
import oracle.ewt.undo.AbstractUndoableEdit;
import oracle.ewt.undo.CannotRedoException;
import oracle.ewt.undo.CannotUndoException;
import oracle.ewt.undo.UndoableEdit;

public class CompoundEdit
extends AbstractUndoableEdit {
    boolean inProgress = true;
    protected Vector edits = new Vector();

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        int n = this.edits.size();
        while (n-- > 0) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(n);
            undoableEdit.undo();
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            ((UndoableEdit)enumeration.nextElement()).redo();
        }
    }

    protected UndoableEdit lastEdit() {
        int n = this.edits.size();
        if (n > 0) {
            return (UndoableEdit)this.edits.elementAt(n - 1);
        }
        return null;
    }

    @Override
    public void die() {
        int n = this.edits.size();
        for (int i = n - 1; i >= 0; --i) {
            UndoableEdit undoableEdit = (UndoableEdit)this.edits.elementAt(i);
            undoableEdit.die();
        }
        super.die();
    }

    @Override
    public boolean addEdit(UndoableEdit undoableEdit) {
        if (!this.inProgress) {
            return false;
        }
        UndoableEdit undoableEdit2 = this.lastEdit();
        if (undoableEdit2 == null) {
            this.edits.addElement(undoableEdit);
        } else if (!undoableEdit2.addEdit(undoableEdit)) {
            if (undoableEdit.replaceEdit(undoableEdit2)) {
                this.edits.removeElementAt(this.edits.size() - 1);
            }
            this.edits.addElement(undoableEdit);
        }
        return true;
    }

    public void end() {
        this.inProgress = false;
    }

    @Override
    public boolean canUndo() {
        return !this.isInProgress() && super.canUndo();
    }

    @Override
    public boolean canRedo() {
        return !this.isInProgress() && super.canRedo();
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    @Override
    public boolean isSignificant() {
        Enumeration enumeration = this.edits.elements();
        while (enumeration.hasMoreElements()) {
            if (!((UndoableEdit)enumeration.nextElement()).isSignificant()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getPresentationName();
        }
        return super.getPresentationName();
    }

    @Override
    public String getUndoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getUndoPresentationName();
        }
        return super.getUndoPresentationName();
    }

    @Override
    public String getRedoPresentationName() {
        UndoableEdit undoableEdit = this.lastEdit();
        if (undoableEdit != null) {
            return undoableEdit.getRedoPresentationName();
        }
        return super.getRedoPresentationName();
    }

    @Override
    public String toString() {
        return super.toString() + " inProgress: " + this.inProgress + " edits: " + this.edits;
    }
}

